package com.transsion.baseui.dialog

import android.app.Activity
import android.app.Dialog
import android.content.Context
import androidx.fragment.app.Fragment
import com.tn.lib.logger.Logger
import com.transsion.base.report.athena.ILogView
import com.transsion.base.report.athena.LogViewConfig

abstract class BaseNativeDialog : Dialog, ILogView {

    // 构造函数与原生Dialog保持一致，增加布局ID快捷构造
    constructor(context: Context) : super(context)
    constructor(context: Context, themeResId: Int) : super(context, themeResId)
    constructor(context: Context, themeResId: Int, contentLayoutId: Int) : super(
        context,
        themeResId
    ) {
        setContentView(contentLayoutId)
    }

    // 重写show方法避免重复显示
    override fun show() {
        try {
            if (isShowing) return
            Logger.d("show dialog hasShownAnyDialogInSession $this :${DialogSessionManager.hasShownAnyDialogInSession}")
            if (DialogSessionManager.hasShownAnyDialogInSession) {
                // 已有弹窗显示时，仅允许绕过限制的弹窗
                if (!bypassSessionNoLimit()) {
                    return
                }
            }
            onShow()
            super.show()
            DialogSessionManager.hasShownAnyDialogInSession = true
        } catch (e: IllegalStateException) {
            e.printStackTrace()
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    // 多场景显示方法重载
    fun showDialog(context: Context?) {
        if (context is Activity && !context.isFinishing && !context.isDestroyed) {
            try {
                show()
            } catch (e: Exception) {
                e.printStackTrace()
            }
        }
    }

    fun showDialog(activity: Activity?) {
        if (activity != null && !activity.isFinishing && !activity.isDestroyed) {
            try {
                show()
            } catch (e: Exception) {
                e.printStackTrace()
            }
        }
    }

    fun showDialog(fragment: Fragment) {
        val activity = fragment.activity
        if (activity != null && !activity.isFinishing && !activity.isDestroyed) {
            try {
                show()
            } catch (e: Exception) {
                e.printStackTrace()
            }
        }
    }

    // ILogView接口实现
    override val logViewConfig: LogViewConfig? by lazy { newLogViewConfig() }

    // 生命周期管理
    override fun onStart() {
        super.onStart()
    }

    override fun onStop() {
        super.onStop()
    }

    fun onDestroy() {
        BaseDialogManager.dismissDialog(getPosition())
    }

    // 位置标识（与BaseDialog保持一致的接口）
    open fun getPosition(): String? = null

    /**
     * 是否受会话限制，默认不限制
     */
    open fun bypassSessionNoLimit(): Boolean {
        return true
    }

    open fun onShow() {

    }

}
