package com.transsion.baseui.dialog

import android.view.View
import android.widget.TextView
import androidx.core.content.ContextCompat
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.viewholder.BaseViewHolder
import com.transsion.baseui.R

/**
 * Created by gaoxin.liu on 2025/11/13.
 * Description:底部菜单弹框，内部使用 BaseQuickAdapter 简化列表渲染
 */
class BottomMenuDialog : BaseBottomSheetDialog(R.layout.dialog_bottom_menu) {

    // 原来构造传入的参数改为可配置属性
    private var content: List<String> = emptyList()
    private var listener: ((Int, String) -> Unit)? = null
    private var highlightText: String? = null
    private var onCancel: (() -> Unit)? = null

    /** 提供一个方法去设置参数 */
    fun setData(
        content: List<String>,
        listener: (Int, String) -> Unit,
        highlightText: String? = null,
        onCancel: (() -> Unit)? = null
    ) {
        this.content = content
        this.listener = listener
        this.highlightText = highlightText
        this.onCancel = onCancel
    }

    override fun initView(view: View) {
        val recyclerView = view.findViewById<RecyclerView>(R.id.recycler_view)
        val tvCancel = view.findViewById<TextView>(R.id.tvDialogBottomCancel)

        recyclerView.layoutManager = LinearLayoutManager(view.context)
        val adapter = MenuAdapter(highlightText)
        recyclerView.adapter = adapter
        adapter.setList(content)

        adapter.setOnItemClickListener { _, _, position ->
            listener?.invoke(position, content[position])
            dismiss()
        }

        tvCancel.setOnClickListener {
            onCancel?.invoke()
            dismiss()
        }
    }

    private class MenuAdapter(private val highlightText: String?) : BaseQuickAdapter<String, BaseViewHolder>(R.layout.item_dialog_bottom_menu) {
        override fun convert(holder: BaseViewHolder, item: String) {
            holder.setText(R.id.tvDialogBottomItem, item)
            val color = if (item == highlightText) {
                ContextCompat.getColor(holder.itemView.context, com.transsion.base.widgets.R.color.error)
            } else {
                ContextCompat.getColor(holder.itemView.context, com.transsion.base.widgets.R.color.white_100)
            }
            holder.setTextColor(R.id.tvDialogBottomItem, color)
        }
    }
}
