package com.transsion.baseui.dialog

import androidx.lifecycle.DefaultLifecycleObserver
import androidx.lifecycle.LifecycleOwner
import androidx.lifecycle.ProcessLifecycleOwner
import com.tn.lib.logger.Logger

object DialogSessionManager : DefaultLifecycleObserver {

    // 标记当次热启动会话是否已有弹窗显示
    var hasShownAnyDialogInSession: Boolean = false

    fun addAppLifeCycleStatus() {
        ProcessLifecycleOwner.get().lifecycle.addObserver(this)
    }

    override fun onStop(owner: LifecycleOwner) {
        //进入后台 重置标记为false
        Logger.d("DialogSessionManager", "onStop 重置标记为false")
        hasShownAnyDialogInSession = false
    }
}