package com.transsion.baseui.dialog

import android.animation.ObjectAnimator
import android.content.DialogInterface
import android.view.View
import android.view.Window
import androidx.fragment.app.FragmentManager
import androidx.lifecycle.DefaultLifecycleObserver
import androidx.lifecycle.LifecycleOwner
import com.transsion.baseui.R
import com.transsion.baseui.databinding.DialogLoadingBinding
import kotlin.apply

/**
 * Created by gaoxin.liu on 2025/8/20.
 * Description: 
 */
class NewLoadingDialog(private val tipText: Int = R.string.common_processing) : TRBaseDialog() {
    private var loadingAnimator: ObjectAnimator? = null

    private var alreadyDestroy = false

    override fun getLayoutId(): Int {
        return R.layout.dialog_loading
    }

    override fun initView(view: View) {
        val binding = DialogLoadingBinding.bind(view)
        binding.tvTips.text = getString(tipText)
        ObjectAnimator.ofFloat(binding.ivLoading, "rotation", 0f, 360f).apply {
            repeatCount = ObjectAnimator.INFINITE
             duration = 1500L
            loadingAnimator = this
        }.start()

        activity?.lifecycle?.addObserver(object : DefaultLifecycleObserver {
            override fun onDestroy(owner: LifecycleOwner) {
                super.onDestroy(owner)
                hide()
                alreadyDestroy = true
            }
        })

        isCancelable = false
    }

    override fun onStart() {
        super.onStart()
        dialog?.window?.apply {
            setBackgroundDrawableResource(com.transsion.base.widgets.R.color.transparent)
        }
    }

    override fun onDismiss(dialog: DialogInterface) {
        super.onDismiss(dialog)
        loadingAnimator?.cancel()
    }

    fun showDialog(fm: FragmentManager) {
        if (alreadyDestroy || fm.findFragmentByTag(TAG) != null) return
        runCatching {
            show(fm, TAG)
        }
    }

    fun hide() {
        if (alreadyDestroy) return
        runCatching { dismiss() }
    }

}