package com.transsion.baseui.dialog

import android.app.Dialog
import android.content.Context
import android.content.DialogInterface
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.fragment.app.DialogFragment
import androidx.fragment.app.Fragment
import androidx.fragment.app.FragmentActivity
import com.transsion.baseui.R

/**
 * 1、继承 TNBaseDialog 重写getLayoutId方法
 * @author: huangyeling
 * @date: 2021/9/10 10:55
 * @see {@link }
 */
abstract class TRBaseDialog : DialogFragment() {

    companion object {
        const val TAG = "TNBaseDialog"
    }

    private var mHasAnimation = false

    private val mIsVertical = true


    private var mDialogAnimation: Int = R.style.TNDialogAnimation
    // 防止调用show isAdd 还没有设置为true，出现 Fragment already added 问题
    private var isShow = false


    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        val contentView: View = inflater.inflate(getLayoutId(), container, false)
        val window = dialog?.window
        window?.let {
            if (mHasAnimation) {
                it.setWindowAnimations(mDialogAnimation)
            }
        }
        dialog?.setCanceledOnTouchOutside(isCancelable)
        initView(contentView)
        return contentView
    }

    fun showDialog(context: Context?, tag: String?) {
        if (context is FragmentActivity
            && !context.isFinishing
            && !context.isDestroyed) {
            try {
                if (!isAdded && !isShow) {
                    isShow = true
                    show(context.supportFragmentManager, tag)
                }
            } catch (e: IllegalStateException) {
                e.printStackTrace()
            } catch (e: java.lang.Exception) {
                e.printStackTrace()
            }
        }
    }

    fun showDialog(fragment: Fragment, tag: String?) {
        try {
            if (!isAdded && !isShow) {
                isShow = true
                show(fragment.childFragmentManager, tag)
            }
        } catch (e: IllegalStateException) {
            e.printStackTrace()
        } catch (e: java.lang.Exception) {
            e.printStackTrace()
        }
    }

    override fun onDismiss(dialog: DialogInterface) {
        super.onDismiss(dialog)
        isShow = false
    }

    abstract fun getLayoutId(): Int

    abstract fun initView(view: View)

    fun isVertical(): Boolean {
        return mIsVertical
    }

    fun isShow(): Boolean {
        return dialog != null && dialog!!.isShowing
    }


    fun setShowAnimation(isAnim: Boolean) {
        mHasAnimation = isAnim
    }


    fun setDimAmount(amount: Float) {
        dialog?.window?.setDimAmount(amount)
    }

    fun setDialogAnimation(mDialogAnimation: Int): TRBaseDialog {
        this.mDialogAnimation = mDialogAnimation
        return this
    }

    fun dismissDialog() {
        try {
            dismissAllowingStateLoss()
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    override fun onCreateDialog(savedInstanceState: Bundle?): Dialog {
        setStyle(STYLE_NO_FRAME, R.style.TNDialog)
        return super.onCreateDialog(savedInstanceState)
    }
}