/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.baseui.dialog;

import android.content.Context;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import com.tn.lib.logger.Logger;
import com.transsion.base.report.athena.ILogView;
import com.transsion.base.report.athena.LogViewConfig;
import com.transsion.baseui.dialog.BaseDialogManager;
import com.transsion.baseui.dialog.DialogSessionManager;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004B\u0011\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0003\u0010\u0007J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u001a\u0010\u000e\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u001a\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\b\u0010\u001a\u001a\u00020\tH\u0016J\b\u0010\u001b\u001a\u00020\tH\u0016J\b\u0010\u001c\u001a\u00020\tH\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\tH\u0016R\u001d\u0010\u0014\u001a\u0004\u0018\u00010\u00158VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006!"}, d2={"Lcom/transsion/baseui/dialog/BaseDialog;", "Landroidx/fragment/app/DialogFragment;", "Lcom/transsion/base/report/athena/ILogView;", "<init>", "()V", "contentLayoutId", "", "(I)V", "show", "", "manager", "Landroidx/fragment/app/FragmentManager;", "tag", "", "showDialog", "context", "Landroid/content/Context;", "fragment", "Landroidx/fragment/app/Fragment;", "fragmentManager", "logViewConfig", "Lcom/transsion/base/report/athena/LogViewConfig;", "getLogViewConfig", "()Lcom/transsion/base/report/athena/LogViewConfig;", "logViewConfig$delegate", "Lkotlin/Lazy;", "onResume", "onPause", "onDestroy", "getPosition", "bypassSessionNoLimit", "", "onShow", "base-dialog_psRelease"})
public abstract class BaseDialog
extends DialogFragment
implements ILogView {
    @NotNull
    private final Lazy logViewConfig$delegate = LazyKt.lazy(() -> BaseDialog.logViewConfig_delegate$lambda$0(this));

    public BaseDialog() {
    }

    public BaseDialog(int contentLayoutId) {
        super(contentLayoutId);
    }

    public void show(@NotNull FragmentManager manager, @Nullable String tag) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        try {
            manager.executePendingTransactions();
            if (this.isAdded() || manager.findFragmentByTag(tag) != null) {
                return;
            }
            Logger.Companion.d$default((Logger.Companion)Logger.Companion, (String)("show dialog hasShownAnyDialogInSession " + (Object)((Object)this) + " :" + DialogSessionManager.INSTANCE.getHasShownAnyDialogInSession()), (boolean)false, (int)2, null);
            if (DialogSessionManager.INSTANCE.getHasShownAnyDialogInSession()) {
                if (!this.bypassSessionNoLimit()) {
                    return;
                }
            } else {
                DialogSessionManager.INSTANCE.setHasShownAnyDialogInSession(true);
            }
            this.onShow();
            super.show(manager, tag);
            BaseDialogManager.INSTANCE.showDialog(this.getPosition());
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void showDialog(@Nullable Context context, @Nullable String tag) {
        if (context instanceof FragmentActivity && !((FragmentActivity)context).isFinishing() && !((FragmentActivity)context).isDestroyed()) {
            try {
                FragmentManager fragmentManager = ((FragmentActivity)context).getSupportFragmentManager();
                Intrinsics.checkNotNullExpressionValue((Object)fragmentManager, (String)"getSupportFragmentManager(...)");
                this.showDialog(fragmentManager, tag);
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public final void showDialog(@NotNull Fragment fragment, @Nullable String tag) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        try {
            FragmentManager fragmentManager = fragment.getChildFragmentManager();
            Intrinsics.checkNotNullExpressionValue((Object)fragmentManager, (String)"getChildFragmentManager(...)");
            this.show(fragmentManager, tag);
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final void showDialog(FragmentManager fragmentManager, String tag) {
        try {
            fragmentManager.executePendingTransactions();
            if (this.isAdded() || fragmentManager.findFragmentByTag(tag) != null) {
                return;
            }
            this.show(fragmentManager, tag);
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Nullable
    public LogViewConfig getLogViewConfig() {
        Lazy lazy = this.logViewConfig$delegate;
        return (LogViewConfig)lazy.getValue();
    }

    public void onResume() {
        super.onResume();
        ILogView.DefaultImpls.onPageResume((ILogView)this);
    }

    public void onPause() {
        super.onPause();
        ILogView.DefaultImpls.onPagePause((ILogView)this);
    }

    public void onDestroy() {
        super.onDestroy();
        BaseDialogManager.INSTANCE.dismissDialog(this.getPosition());
    }

    @Nullable
    public String getPosition() {
        return null;
    }

    public boolean bypassSessionNoLimit() {
        return true;
    }

    public void onShow() {
    }

    @Nullable
    public LogViewConfig newLogViewConfig() {
        return ILogView.DefaultImpls.newLogViewConfig((ILogView)this);
    }

    public void onPageResume() {
        ILogView.DefaultImpls.onPageResume((ILogView)this);
    }

    public void onPagePause() {
        ILogView.DefaultImpls.onPagePause((ILogView)this);
    }

    private static final LogViewConfig logViewConfig_delegate$lambda$0(BaseDialog this$0) {
        return this$0.newLogViewConfig();
    }
}

