/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.baseui.dialog;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.tn.lib.logger.Logger;
import com.transsion.base.report.athena.ILogView;
import com.transsion.base.report.athena.LogViewConfig;
import com.transsion.baseui.dialog.BaseDialogManager;
import com.transsion.baseui.dialog.DialogSessionManager;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\tB!\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u000e\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0019\u001a\u00020\rH\u0014J\b\u0010\u001a\u001a\u00020\rH\u0014J\u0006\u0010\u001b\u001a\u00020\rJ\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\rH\u0016R\u001d\u0010\u0013\u001a\u0004\u0018\u00010\u00148VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006!"}, d2={"Lcom/transsion/baseui/dialog/BaseNativeDialog;", "Landroid/app/Dialog;", "Lcom/transsion/base/report/athena/ILogView;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "themeResId", "", "(Landroid/content/Context;I)V", "contentLayoutId", "(Landroid/content/Context;II)V", "show", "", "showDialog", "activity", "Landroid/app/Activity;", "fragment", "Landroidx/fragment/app/Fragment;", "logViewConfig", "Lcom/transsion/base/report/athena/LogViewConfig;", "getLogViewConfig", "()Lcom/transsion/base/report/athena/LogViewConfig;", "logViewConfig$delegate", "Lkotlin/Lazy;", "onStart", "onStop", "onDestroy", "getPosition", "", "bypassSessionNoLimit", "", "onShow", "base-dialog_psRelease"})
public abstract class BaseNativeDialog
extends Dialog
implements ILogView {
    @NotNull
    private final Lazy logViewConfig$delegate;

    public BaseNativeDialog(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.logViewConfig$delegate = LazyKt.lazy(() -> BaseNativeDialog.logViewConfig_delegate$lambda$0(this));
    }

    public BaseNativeDialog(@NotNull Context context, int themeResId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, themeResId);
        this.logViewConfig$delegate = LazyKt.lazy(() -> BaseNativeDialog.logViewConfig_delegate$lambda$0(this));
    }

    public BaseNativeDialog(@NotNull Context context, int themeResId, int contentLayoutId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, themeResId);
        this.logViewConfig$delegate = LazyKt.lazy(() -> BaseNativeDialog.logViewConfig_delegate$lambda$0(this));
        this.setContentView(contentLayoutId);
    }

    public void show() {
        try {
            if (this.isShowing()) {
                return;
            }
            Logger.Companion.d$default((Logger.Companion)Logger.Companion, (String)("show dialog hasShownAnyDialogInSession " + (Object)((Object)this) + " :" + DialogSessionManager.INSTANCE.getHasShownAnyDialogInSession()), (boolean)false, (int)2, null);
            if (DialogSessionManager.INSTANCE.getHasShownAnyDialogInSession() && !this.bypassSessionNoLimit()) {
                return;
            }
            this.onShow();
            super.show();
            DialogSessionManager.INSTANCE.setHasShownAnyDialogInSession(true);
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void showDialog(@Nullable Context context) {
        if (context instanceof Activity && !((Activity)context).isFinishing() && !((Activity)context).isDestroyed()) {
            try {
                this.show();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public final void showDialog(@Nullable Activity activity) {
        if (activity != null && !activity.isFinishing() && !activity.isDestroyed()) {
            try {
                this.show();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public final void showDialog(@NotNull Fragment fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        FragmentActivity activity = fragment.getActivity();
        if (activity != null && !activity.isFinishing() && !activity.isDestroyed()) {
            try {
                this.show();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Nullable
    public LogViewConfig getLogViewConfig() {
        Lazy lazy = this.logViewConfig$delegate;
        return (LogViewConfig)lazy.getValue();
    }

    protected void onStart() {
        super.onStart();
    }

    protected void onStop() {
        super.onStop();
    }

    public final void onDestroy() {
        BaseDialogManager.INSTANCE.dismissDialog(this.getPosition());
    }

    @Nullable
    public String getPosition() {
        return null;
    }

    public boolean bypassSessionNoLimit() {
        return true;
    }

    public void onShow() {
    }

    @Nullable
    public LogViewConfig newLogViewConfig() {
        return ILogView.DefaultImpls.newLogViewConfig((ILogView)this);
    }

    public void onPageResume() {
        ILogView.DefaultImpls.onPageResume((ILogView)this);
    }

    public void onPagePause() {
        ILogView.DefaultImpls.onPagePause((ILogView)this);
    }

    private static final LogViewConfig logViewConfig_delegate$lambda$0(BaseNativeDialog this$0) {
        return this$0.newLogViewConfig();
    }
}

