/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.baseui.dialog;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextPaint;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.blankj.utilcode.util.BarUtils;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0004\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0002\u001a\u0012\u0010\u0007\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\b\u001a\u00020\u0006\u001a\"\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u00022\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0007\u001a(\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0011\u001a7\u0010\u001a\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u001b\u001a\u00020\u00152!\u0010\u001c\u001a\u001d\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b( \u0012\u0004\u0012\u00020\u00010\u001d\u001a\n\u0010!\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010%\u001a\u00020&*\u00020'\"\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\"\u0011\u0010\"\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006("}, d2={"visible", "", "Landroid/view/View;", "invisible", "gone", "isVisibility", "", "setVisibility", "show", "toBitmap", "Landroid/graphics/Bitmap;", "scale", "", "config", "Landroid/graphics/Bitmap$Config;", "createBitmapSafely", "width", "", "height", "retryCount", "lastClickTime", "", "getLastClickTime", "()J", "setLastClickTime", "(J)V", "clickNoRepeat", "interval", "action", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "view", "fitStatusBar", "rightToLeft", "getRightToLeft", "()Z", "autoSplitText", "", "Landroid/widget/TextView;", "base-dialog_psRelease"})
@SourceDebugExtension(value={"SMAP\nViewExt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ViewExt.kt\ncom/transsion/baseui/dialog/ViewExtKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,148:1\n739#2,9:149\n37#3:158\n36#3,3:159\n*S KotlinDebug\n*F\n+ 1 ViewExt.kt\ncom/transsion/baseui/dialog/ViewExtKt\n*L\n118#1:149,9\n118#1:158\n118#1:159,3\n*E\n"})
public final class ViewExtKt {
    private static long lastClickTime;

    public static final void visible(@NotNull View $this$visible) {
        Intrinsics.checkNotNullParameter((Object)$this$visible, (String)"<this>");
        $this$visible.setVisibility(0);
    }

    public static final void invisible(@NotNull View $this$invisible) {
        Intrinsics.checkNotNullParameter((Object)$this$invisible, (String)"<this>");
        $this$invisible.setVisibility(4);
    }

    public static final void gone(@NotNull View $this$gone) {
        Intrinsics.checkNotNullParameter((Object)$this$gone, (String)"<this>");
        $this$gone.setVisibility(8);
    }

    public static final boolean isVisibility(@NotNull View $this$isVisibility) {
        Intrinsics.checkNotNullParameter((Object)$this$isVisibility, (String)"<this>");
        return $this$isVisibility.getVisibility() == 0;
    }

    public static final void setVisibility(@NotNull View $this$setVisibility, boolean show) {
        Intrinsics.checkNotNullParameter((Object)$this$setVisibility, (String)"<this>");
        $this$setVisibility.setVisibility(show ? 0 : 8);
    }

    @Deprecated(message="use View.drawToBitmap()")
    @Nullable
    public static final Bitmap toBitmap(@NotNull View $this$toBitmap, float scale, @NotNull Bitmap.Config config) {
        Intrinsics.checkNotNullParameter((Object)$this$toBitmap, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if ($this$toBitmap instanceof ImageView && ((ImageView)$this$toBitmap).getDrawable() instanceof BitmapDrawable) {
            Drawable drawable = ((ImageView)$this$toBitmap).getDrawable();
            Intrinsics.checkNotNull((Object)drawable, (String)"null cannot be cast to non-null type android.graphics.drawable.BitmapDrawable");
            return ((BitmapDrawable)drawable).getBitmap();
        }
        $this$toBitmap.clearFocus();
        Bitmap bitmap = ViewExtKt.createBitmapSafely((int)((float)$this$toBitmap.getWidth() * scale), (int)((float)$this$toBitmap.getHeight() * scale), config, 1);
        if (bitmap != null) {
            Canvas $this$toBitmap_u24lambda_u240 = new Canvas();
            boolean bl = false;
            $this$toBitmap_u24lambda_u240.setBitmap(bitmap);
            $this$toBitmap_u24lambda_u240.save();
            $this$toBitmap_u24lambda_u240.drawColor(-1);
            $this$toBitmap_u24lambda_u240.scale(scale, scale);
            $this$toBitmap.draw($this$toBitmap_u24lambda_u240);
            $this$toBitmap_u24lambda_u240.restore();
            $this$toBitmap_u24lambda_u240.setBitmap(null);
        }
        return bitmap;
    }

    public static /* synthetic */ Bitmap toBitmap$default(View view, float f, Bitmap.Config config, int n, Object object) {
        if ((n & 1) != 0) {
            f = 1.0f;
        }
        if ((n & 2) != 0) {
            config = Bitmap.Config.ARGB_8888;
        }
        return ViewExtKt.toBitmap(view, f, config);
    }

    @Nullable
    public static final Bitmap createBitmapSafely(int width, int height, @NotNull Bitmap.Config config, int retryCount) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        try {
            return Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            if (retryCount > 0) {
                System.gc();
                return ViewExtKt.createBitmapSafely(width, height, config, retryCount - 1);
            }
            return null;
        }
    }

    public static final long getLastClickTime() {
        return lastClickTime;
    }

    public static final void setLastClickTime(long l) {
        lastClickTime = l;
    }

    public static final void clickNoRepeat(@NotNull View $this$clickNoRepeat, long interval, @NotNull Function1<? super View, Unit> action) {
        Intrinsics.checkNotNullParameter((Object)$this$clickNoRepeat, (String)"<this>");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        $this$clickNoRepeat.setOnClickListener(arg_0 -> ViewExtKt.clickNoRepeat$lambda$1(interval, action, arg_0));
    }

    public static /* synthetic */ void clickNoRepeat$default(View view, long l, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            l = 500L;
        }
        ViewExtKt.clickNoRepeat(view, l, (Function1<? super View, Unit>)function1);
    }

    public static final void fitStatusBar(@NotNull View $this$fitStatusBar) {
        Intrinsics.checkNotNullParameter((Object)$this$fitStatusBar, (String)"<this>");
        $this$fitStatusBar.setPadding($this$fitStatusBar.getPaddingStart(), $this$fitStatusBar.getPaddingTop() + BarUtils.getStatusBarHeight(), $this$fitStatusBar.getPaddingEnd(), $this$fitStatusBar.getPaddingBottom());
    }

    public static final boolean getRightToLeft() {
        return TextUtils.getLayoutDirectionFromLocale((Locale)Locale.getDefault()) == 1;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String autoSplitText(@NotNull TextView $this$autoSplitText) {
        void $this$toTypedArray$iv;
        List list;
        Collection $this$dropLastWhile$iv;
        Intrinsics.checkNotNullParameter((Object)$this$autoSplitText, (String)"<this>");
        String rawText = ((Object)$this$autoSplitText.getText()).toString();
        TextPaint textPaint = $this$autoSplitText.getPaint();
        Intrinsics.checkNotNullExpressionValue((Object)textPaint, (String)"getPaint(...)");
        Paint tvPaint = (Paint)textPaint;
        float tvWidth = $this$autoSplitText.getWidth() - $this$autoSplitText.getPaddingLeft() - $this$autoSplitText.getPaddingRight();
        Object object = rawText;
        Regex regex = new Regex("\r");
        String string2 = "";
        object = regex.replace((CharSequence)object, string2);
        regex = new Regex("\n");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] rawTextLines = thisCollection$iv.toArray(new String[0]);
        StringBuilder sbNewText = new StringBuilder();
        for (String rawTextLine : rawTextLines) {
            if (tvPaint.measureText(rawTextLine) <= tvWidth) {
                sbNewText.append(rawTextLine);
            } else {
                float lineWidth = 0.0f;
                for (int cnt = 0; cnt != rawTextLine.length(); ++cnt) {
                    Comparable<StringBuilder> comparable;
                    char ch = rawTextLine.charAt(cnt);
                    if ((lineWidth += tvPaint.measureText(String.valueOf(ch))) <= tvWidth) {
                        comparable = sbNewText.append(ch);
                        continue;
                    }
                    sbNewText.append("\n");
                    lineWidth = 0.0f;
                    comparable = --cnt;
                }
            }
            sbNewText.append("\n");
        }
        if (!StringsKt.endsWith$default((String)rawText, (String)"\n", (boolean)false, (int)2, null)) {
            sbNewText.deleteCharAt(sbNewText.length() - 1);
        }
        String string3 = sbNewText.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        return string3;
    }

    private static final void clickNoRepeat$lambda$1(long $interval, Function1 $action, View it) {
        long currentTime = System.currentTimeMillis();
        if (lastClickTime != 0L && currentTime - lastClickTime < $interval) {
            return;
        }
        lastClickTime = currentTime;
        Intrinsics.checkNotNull((Object)it);
        $action.invoke((Object)it);
    }
}

