package com.transsion.mb.config.download

import com.tn.lib.net.bean.BaseDto
import com.tn.lib.net.cons.NetConst
import com.tn.lib.net.env.Host
import io.reactivex.rxjava3.core.Observable
import retrofit2.http.GET
import retrofit2.http.Path
import retrofit2.http.Query

interface ConfigApi {
    /**
     * 获取启动配置
     */
    @GET("/{dynamicPath}/app/config")
    fun appConfig(
        @Path("dynamicPath") dynamicPath: String,
        @Query(NetConst.HOST) host: String = Host.getHost(),
        @Query("keys") keys: String = "all",
        @Query("version") version: String = "",
    ): Observable<BaseDto<AppStartConfig>>
}