/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.mb.config.manager;

import android.text.TextUtils;
import android.util.Log;
import com.blankj.utilcode.util.GsonUtils;
import com.google.firebase.remoteconfig.FirebaseRemoteConfig;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.transsion.base.report.athena.Report;
import com.transsion.mb.config.manager.ConfigBean;
import com.transsion.mb.config.manager.ConfigMMKV;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0015\u001a\u00020\n2\b\b\u0002\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\nH\u0002J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u000bH\u0002R.\u0010\b\u001a\"\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\tj\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\n0\u000ej\b\u0012\u0004\u0012\u00020\n`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/transsion/mb/config/manager/ConfigManager;", "", "<init>", "()V", "setLocalConfig", "", "items", "Lcom/google/gson/JsonArray;", "mCacheMap", "Ljava/util/HashMap;", "", "Lcom/transsion/mb/config/manager/ConfigBean;", "Lkotlin/collections/HashMap;", "abResultSet", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "updateConfig", "saveFirebaseConfig", "firebaseRemoteConfig", "Lcom/google/firebase/remoteconfig/FirebaseRemoteConfig;", "getConfig", "key", "needNewest", "", "getCurrentDate", "reportAbResult", "configBean", "Companion", "Config_psRelease"})
@SourceDebugExtension(value={"SMAP\nConfigManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigManager.kt\ncom/transsion/mb/config/manager/ConfigManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,139:1\n1869#2,2:140\n216#3,2:142\n*S KotlinDebug\n*F\n+ 1 ConfigManager.kt\ncom/transsion/mb/config/manager/ConfigManager\n*L\n45#1:140,2\n65#1:142,2\n*E\n"})
public final class ConfigManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HashMap<String, ConfigBean> mCacheMap = new HashMap();
    @NotNull
    private final HashSet<String> abResultSet = new HashSet();
    @NotNull
    private static final Lazy<ConfigManager> instance$delegate = LazyKt.lazy(ConfigManager::instance_delegate$lambda$2);
    @NotNull
    private static final String CONFIG_AB_RESULT = "config_ab_result";

    public final void setLocalConfig(@NotNull JsonArray items) {
        Intrinsics.checkNotNullParameter((Object)items, (String)"items");
        this.updateConfig(items);
    }

    public final void updateConfig(@NotNull JsonArray items) {
        boolean bl;
        Object it;
        Intrinsics.checkNotNullParameter((Object)items, (String)"items");
        Object $this$forEach$iv = (Iterable)items;
        boolean $i$f$forEach = false;
        Iterator<Object> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            JsonObject jsonObject;
            Object t = iterator.next();
            it = (JsonElement)t;
            bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it.getAsJsonObject(), (String)"getAsJsonObject(...)");
            String key = jsonObject.get("key").getAsString();
            String beforeValue = ConfigMMKV.INSTANCE.getMmkv().getString(key, null);
            CharSequence charSequence = beforeValue;
            if (charSequence == null || charSequence.length() == 0 || !StringsKt.contains$default((CharSequence)beforeValue, (CharSequence)"\"isFirebase\":true", (boolean)false, (int)2, null)) {
                ConfigMMKV.INSTANCE.getMmkv().putString(key, jsonObject.toString());
            }
            if (Intrinsics.areEqual((Object)key, (Object)"ad_scene_config")) {
                Log.w((String)"co_non", (String)("ConfigManager --> updateConfig --> ad_scene_config = " + jsonObject));
            }
            if (!Intrinsics.areEqual((Object)key, (Object)"business_guide_config")) continue;
            Log.w((String)"co_non", (String)("ConfigManager --> updateConfig --> business_guide_config = " + jsonObject));
        }
        $this$forEach$iv = this.mCacheMap;
        $i$f$forEach = false;
        for (Map.Entry entry : $this$forEach$iv.entrySet()) {
            it = entry;
            bl = false;
            ConfigBean configBean = (ConfigBean)it.getValue();
            if (configBean == null) continue;
            configBean.setHasUpdate(true);
        }
    }

    public final void saveFirebaseConfig(@NotNull FirebaseRemoteConfig firebaseRemoteConfig) {
        Intrinsics.checkNotNullParameter((Object)firebaseRemoteConfig, (String)"firebaseRemoteConfig");
        Set set = firebaseRemoteConfig.getKeysByPrefix("");
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getKeysByPrefix(...)");
        Set keys = set;
        for (String key : keys) {
            ConfigBean bean = new ConfigBean();
            bean.setKey(key);
            bean.setValue(firebaseRemoteConfig.getString(key));
            bean.setFirebase(true);
            ConfigMMKV.INSTANCE.getMmkv().putString(key, GsonUtils.toJson((Object)bean));
        }
    }

    @Nullable
    public final ConfigBean getConfig(@NotNull String key, boolean needNewest) {
        String json;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ConfigBean configBean = null;
        if (((Map)this.mCacheMap).containsKey(key)) {
            configBean = this.mCacheMap.get(key);
            if (needNewest) {
                ConfigBean configBean2 = configBean;
                boolean bl = configBean2 != null ? configBean2.getHasUpdate() : false;
                if (bl) {
                    configBean = null;
                }
            }
        }
        if (configBean == null && !TextUtils.isEmpty((CharSequence)(json = ConfigMMKV.INSTANCE.getMmkv().getString(key, null)))) {
            try {
                configBean = (ConfigBean)GsonUtils.fromJson((String)json, ConfigBean.class);
                ((Map)this.mCacheMap).put(key, configBean);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String reportKey = key + this.getCurrentDate();
        if (configBean != null && !this.abResultSet.contains(reportKey)) {
            this.reportAbResult(configBean);
            this.abResultSet.add(reportKey);
        }
        return configBean;
    }

    public static /* synthetic */ ConfigBean getConfig$default(ConfigManager configManager, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return configManager.getConfig(string, bl);
    }

    private final String getCurrentDate() {
        Date currentDate = Calendar.getInstance().getTime();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
        String string = formatter.format(currentDate);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    private final void reportAbResult(ConfigBean configBean) {
        if (!TextUtils.isEmpty((CharSequence)configBean.getOps())) {
            HashMap map = new HashMap();
            ((Map)map).put("key", configBean.getKey());
            ((Map)map).put("ops", configBean.getOps());
            ((Map)map).put("isFirebase", String.valueOf(configBean.isFirebase()));
            Report.INSTANCE.reportEvent(CONFIG_AB_RESULT, (Map)map);
        }
    }

    private static final ConfigManager instance_delegate$lambda$2() {
        return new ConfigManager();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/transsion/mb/config/manager/ConfigManager$Companion;", "", "<init>", "()V", "instance", "Lcom/transsion/mb/config/manager/ConfigManager;", "getInstance", "()Lcom/transsion/mb/config/manager/ConfigManager;", "instance$delegate", "Lkotlin/Lazy;", "CONFIG_AB_RESULT", "", "Config_psRelease"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ConfigManager getInstance() {
            Lazy lazy = instance$delegate;
            return (ConfigManager)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

