package com.transsion.mb.config.manager

import android.os.Parcel
import android.os.Parcelable

/**
 *   Transsion MI
 *   Created By Liupeng
 *   On 2023/8/14 20:22
 *
 *   Desc 配置对象
 */
class ConfigBean() :Parcelable{
    var key: String? = null
    var ops: String? = null
    var value: String? = null
    var hasUpdate = false //处理缓存的flag
    var isFirebase = false //是simba还是firebase下发的

    constructor(parcel: Parcel) : this() {
        key = parcel.readString()
        ops = parcel.readString()
        value = parcel.readString()
    }

    override fun writeToParcel(parcel: Parcel, flags: Int) {
        parcel.writeString(key)
        parcel.writeString(ops)
        parcel.writeString(value)
    }

    override fun describeContents(): Int {
        return 0
    }

    companion object CREATOR : Parcelable.Creator<ConfigBean> {
        override fun createFromParcel(parcel: Parcel): ConfigBean {
            return ConfigBean(parcel)
        }

        override fun newArray(size: Int): Array<ConfigBean?> {
            return arrayOfNulls(size)
        }
    }

}