package com.transsion.mb.config.manager

import com.tencent.mmkv.MMKV
import com.transsion.annotations.ConfigRequestParam

/**
 *
 * @Description:    描述
 * @Author:         xusong.yang
 * @CreateDate:     2022/8/12$ 17:35$
 * @Version:        1.0
 */
object ConfigMMKV {
    val mmkv: MMKV by lazy { MMKV.mmkvWithID("kv_app_config") }

    /**
     * config版本号
     */
    const val CONFIG_VERSION = "configVersion"

    /**
     * 列表拉新配置
     */
    @ConfigRequestParam
    const val FISSION_CONFIG = "vipFissionOn"

    /**
     * 下载range大小
     */
    @ConfigRequestParam
    const val DOWNLOAD_RANGE_SIZE = "downloadRangeSize"

    /**
     * 拉活开关
     */
    @ConfigRequestParam
    const val KEY_ALIVE_OFF = "keyAliveOff"

    /**
     * 后台上报开关
     */
    @ConfigRequestParam
    const val KEY_BACKGROUND_REPORT_OFF = "keyBackgroundReportOff"

    /**
     * 日志回捞开关
     */
    @ConfigRequestParam
    const val CLIENT_LOGS_RETRIEVE = "clientLogsRetrieve"


    /**
     * 下载错误ch
     */
    @ConfigRequestParam
    const val DOWNLOAD_ERROR_OPT_OFF = "download_error_opt_off"

    /**
     * 短剧tab开关:默认false discover页，true：for you 视频页
     */
    @ConfigRequestParam
    const val SHORTS_TAB_IN_FOR_YOU = "shorts_tab_in_for_you"


    /**
     * 播放器是否独立线程
     */
    @ConfigRequestParam
    const val PLAY_ASYNC = "player_async"

    /**
     * game center 和 app center 开关控制
     */
    @ConfigRequestParam
    const val APP_CENTER_SWITCH = "app_center_switch"

    /**
     * 播放模式
     */
    @ConfigRequestParam
    const val PLAY_MODE = "play_mode"

    /**
     * 埋点配置
     *
     * 通用能力
     * https://transsioner.feishu.cn/wiki/ZFLcwmsusifJREkmxJlc54MvnAc
     */
    @ConfigRequestParam
    const val POINT_CONFIG = "point_config"
}