package com.transsnet.flow.event

import androidx.annotation.Keep
import androidx.lifecycle.ViewModelProvider
import androidx.lifecycle.ViewModelStoreOwner

//_______________________________________
//          post event
//_______________________________________

//Application范围的事件
@Keep
inline fun <reified T> postEvent(event: T, timeMillis: Long = 0L) {
    AppScopeVMlProvider.getApplicationScopeViewModel(FlowEventBus::class.java)
        .postEvent(T::class.java.name, event!!, timeMillis)
}

//限定范围的事件
inline fun <reified T> postEvent(scope: ViewModelStoreOwner, event: T, timeMillis: Long = 0L) {
    ViewModelProvider(scope).get(FlowEventBus::class.java)
        .postEvent(T::class.java.name, event!!, timeMillis)
}