package com.transsnet.flow.event.sync

import com.blankj.utilcode.util.GsonUtils
//import com.transsion.publish.api.bean.RequestPostEntity
import com.transsion.user.action.sync.event.CommentEvent
import com.transsnet.flow.event.postEvent
import com.transsnet.flow.event.sync.event.*


/**
 * 全局状态同步 基于FlowEvent
 * 点赞、评论等状态同步
 */
class SyncManager {

    companion object {

        @JvmStatic
        val INSTANCE: SyncManager by lazy(mode = LazyThreadSafetyMode.SYNCHRONIZED) {
            SyncManager()
        }

        const val LIKE = 0
        const val UNLIKE = 1

        const val VIDEO_COMMENT_ADD = 1
        const val VIDEO_COMMENT_DELETE = 2

        const val DELETE_POST = 3//删除帖子

        //作品的watch_later事件
        const val NOT_WANT_TO_SEE = 0
        const val WANT_TO_SEE = 1

        //圈子的加入退出事件
        const val EXIT = 0
        const val JOIN = 1

    }

    private constructor()


    /**
     * 通知全局状态 相应视频点赞、取消点赞状态
     */
    fun notifyLike(reqType: Int, subjectId: String) {
        var action = false
        when (reqType) {
            LIKE -> {
                action = true
            }
            UNLIKE -> {
                action = false
            }
        }
        postEvent(LikeEvent(action, subjectId))//postEvent发送，observeEvent监听，所有监听LikeEvent的页面都能收到
    }


    /**
     * 通知全局状态 相应作品的WatchLater 事件
     */
    fun notifyWatchLater(reqType: Int, subjectId: String) {
        var action = false
        when (reqType) {
            WANT_TO_SEE -> {
                action = true
            }
            NOT_WANT_TO_SEE -> {
                action = false
            }
        }
        postEvent(WatchLaterEvent(action, subjectId))//postEvent发送，observeEvent监听
    }

    /**
     * 通知全局状态 相应圈子join和exit 事件
     */
    fun notifyJoinRoom(reqType: Int, groupId: String) {
        var action = false
        when (reqType) {
            JOIN -> {
                action = true
            }
            EXIT -> {
                action = false
            }
        }
        postEvent(JoinRoomEvent(action, groupId))//postEvent发送，observeEvent监听
    }

    /**
     * 通知全局状态 相应评论添加、删除
     */
    fun notifyComments(
        reqType: Int,
        commentId: String,
        commentNum: String = "",
        subjectId: String?
    ) {
        var action = false
        when (reqType) {
            VIDEO_COMMENT_ADD -> {
                action = true
            }
            VIDEO_COMMENT_DELETE -> {
                action = false
            }
        }
        postEvent(CommentEvent(action, commentId, commentNum, subjectId))
    }


    //todo 加入圈子状态，想看数量，下载数量，发帖数量，点赞数量
    fun notifyDeletePost(postId:String){
        postEvent(DeletePostEvent(postId))
    }


    /**
     * 同步新增帖子成功
     * postId 帖子id
     * json 对应的帖子信息 json
     */
    fun notifyPostSucceed(postId:String,groupId :String?,sourceType:Int){
        try {
            //var entity = GsonUtils.fromJson(json,RequestPostEntity::class.java)
            postEvent(PublishEvent(postId,groupId,sourceType))
        }catch (e : Exception){
            postEvent(PublishEvent(postId,null,sourceType))
        }

    }

}