package com.transsion.base.image

import android.app.ActivityManager
import android.content.Context
import com.blankj.utilcode.util.Utils
import com.bumptech.glide.Glide
import com.bumptech.glide.GlideBuilder
import com.bumptech.glide.Registry
import com.bumptech.glide.annotation.GlideModule
import com.bumptech.glide.integration.okhttp3.OkHttpUrlLoader
import com.bumptech.glide.load.DecodeFormat
import com.bumptech.glide.load.engine.cache.MemorySizeCalculator
import com.bumptech.glide.load.model.GlideUrl
import com.bumptech.glide.module.AppGlideModule
import com.bumptech.glide.request.RequestOptions
import com.tn.lib.logger.MBLogger
import com.transsion.baseui.image.glide.GlideSafeBitmapPool
import org.chromium.net.CronetEngine
import java.io.InputStream


/**
 *   Transsion MI
 *   Created By Liupeng
 *   On 2023/3/27 15:16
 *
 *   Desc:
 */
@GlideModule
class CustomGlideModule : AppGlideModule() {
    private val requestOptions = RequestOptions()


    override fun registerComponents(context: Context, glide: Glide, registry: Registry) {
        //如果检测当前没有cronet支持 图片加载交给okhttp
        if (!isCronetSupported()) {
            MBLogger.d("CustomGlideModule", "glide cronet disabled,use okhttp")
            registry.replace(GlideUrl::class.java, InputStream::class.java, OkHttpUrlLoader.Factory())
        }
    }

    private fun isCronetSupported(): Boolean {
        return try {
            val builder = CronetEngine.Builder(Utils.getApp())
            val cronetEngine = builder.build()
            cronetEngine.shutdown()
            true
        } catch (e: Throwable) {
            false
        }
    }

    override fun applyOptions(context: Context, builder: GlideBuilder) {
        val activityManager = context.getSystemService(Context.ACTIVITY_SERVICE) as ActivityManager
        val memoryInfo = ActivityManager.MemoryInfo()
        activityManager.getMemoryInfo(memoryInfo)
        val totalMemory = memoryInfo.totalMem
        val totalMemoryGB = totalMemory / (1024f * 1024 * 1024)

        if (totalMemoryGB < 4) {
            builder.setDefaultRequestOptions(this.requestOptions.format(DecodeFormat.PREFER_RGB_565))
        }

        // 用 Glide 的 MemorySizeCalculator 获取默认大小
        val calculator = MemorySizeCalculator.Builder(context).build()
        val defaultBitmapPoolSize = calculator.bitmapPoolSize.toLong()
        // 使用安全的 Pool 替代默认实现
        builder.setBitmapPool(GlideSafeBitmapPool(defaultBitmapPoolSize))
    }
}