package com.transsion.base.image

import com.bumptech.glide.util.LruCache

object Resizer {
    const val ThumbnailSize = 32
    const val NeedThumbnailMinSize = 3 * ThumbnailSize

    private var SIZE_ARRAY = arrayOf(120, 180, 240, 360, 540, 720, 1080)
    private var cacheImageSize: LruCache<String, Int> = LruCache(600)

    fun getReSizeUrl(
        url: String,
        width: Int,
        isWebP: Boolean = true,
        isQuality:Boolean = true,
        height: Int = 0,
        supportH: Boolean = false,
        preloadImg:Boolean = false
    ): String {
        if (isServerImage(url)) return url

        var useWidth = getSize(width)

        val cachedMax = cacheImageSize.get(url) ?: 0
        if (cachedMax >= useWidth) {
            useWidth = cachedMax
        }
        //高同比例调整
        val useHeight = useWidth.times(1.0F).div(width).times(height).toInt()
        //预加载在成功之前不加入cache size
        if (cachedMax != useWidth && !preloadImg) {
            cacheImageSize.put(url, useWidth)
        }

        return buildResizeUrl(url, useWidth, isWebP,isQuality, useHeight, supportH)
    }

    fun getCachedSize(url: String): Int {
        return cacheImageSize.get(url) ?: 0
    }

    fun putCachedSize(originUrl: String,width: Int) {
        if (isServerImage(originUrl)) return
        var useWidth = getSize(width)
        val cachedMax = cacheImageSize.get(originUrl) ?: 0
        if (cachedMax >= useWidth) {
            useWidth = cachedMax
        }
        if (cachedMax != useWidth) {
            cacheImageSize.put(originUrl, useWidth)
        }
    }
    fun buildResizeUrl(url: String, width: Int, isWebP: Boolean = true,isQuality:Boolean = true,
                       height:Int = 0, supportH: Boolean = false): String {
        if (isServerImage(url)) return ""

        val sBuilder = StringBuilder(url)
        if (url.contains("?")) {
            sBuilder.append("&x-oss-process=image")
        } else {
            sBuilder.append("?x-oss-process=image")
        }

        sBuilder.append("/resize,w_")
        sBuilder.append(width)
        if (supportH) {
            sBuilder.append(",h_")
            sBuilder.append(height)
        }

        if (isWebP) {
            sBuilder.append("/format,webp")
        }
        if (isQuality){
            // 质量压缩 50%
            sBuilder.append("/quality,Q_50")
        }

        return sBuilder.toString()
    }

    // 是否是服务端下发的不可resize的url
    private fun isServerImage(url: String): Boolean {
        return url.contains("?x-oss-process=image")
                || url.contains("x-server-image=1")
    }

    private fun getSize(width: Int): Int {
        var result = SIZE_ARRAY.last()
        for (el in SIZE_ARRAY) {
            if (width <= el) {
                result = el
                break
            }
        }
        return result
    }
}