package com.transsion.base.image.blurhash

import android.graphics.drawable.Drawable
import com.bumptech.glide.RequestBuilder
import com.transsion.base.image.blurhash.BlurHash

// FOR GLIDE
fun RequestBuilder<Drawable>.blurPlaceHolder(
    blurString: String,
    width: Int = 0,
    height: Int = 0,
    blurHash: BlurHash,
    response: (requestBuilder: RequestBuilder<Drawable>) -> Unit
) {
    if (width != 0 && height != 0) {
        blurHash.execute(blurString, width, height) { drawable ->
            this@blurPlaceHolder.placeholder(drawable)
            response(this@blurPlaceHolder)
        }
    }
}