/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.base.image.blurhash;

import android.graphics.Bitmap;
import android.graphics.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0013\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0010\f\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u000bJ6\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015J$\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u000f2\b\b\u0002\u0010\u0018\u001a\u00020\u00062\b\b\u0002\u0010\u0019\u001a\u00020\u0006H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0006H\u0002J\u0010\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0006H\u0002J\u0018\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u0013H\u0002J\u0010\u0010!\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0013H\u0002JC\u0010\"\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u00062\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001b0&2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010'J \u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u0006H\u0002J \u0010*\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u0006H\u0002J4\u0010+\u001a\u00020,*\u00020\u00072\u0006\u0010)\u001a\u00020\u00152\u0006\u0010-\u001a\u00020\u00062\u0006\u0010.\u001a\u00020\u00062\u0006\u0010/\u001a\u00020\u00062\u0006\u00100\u001a\u00020\u0006H\u0002J\u0010\u00101\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0013H\u0002R*\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00102\u001a\u000e\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00020\u000603X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/transsion/base/image/blurhash/BlurHashDecoder;", "", "<init>", "()V", "cacheCosinesX", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "cacheCosinesY", "clearCache", "", "decode", "Landroid/graphics/Bitmap;", "blurHash", "", "width", "height", "punch", "", "useCache", "", "decode83", "str", "from", "to", "decodeDc", "", "colorEnc", "srgbToLinear", "decodeAc", "value", "maxAc", "signedPow2", "composeBitmap", "numCompX", "numCompY", "colors", "", "(IIII[[FZ)Landroid/graphics/Bitmap;", "getArrayForCosinesY", "calculate", "getArrayForCosinesX", "getCos", "", "x", "numComp", "y", "size", "linearToSrgb", "charMap", "", "", "image_psRelease"})
@SourceDebugExtension(value={"SMAP\nBlurHashDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlurHashDecoder.kt\ncom/transsion/base/image/blurhash/BlurHashDecoder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,185:1\n1573#2:186\n1604#2,4:187\n*S KotlinDebug\n*F\n+ 1 BlurHashDecoder.kt\ncom/transsion/base/image/blurhash/BlurHashDecoder\n*L\n182#1:186\n182#1:187,4\n*E\n"})
public final class BlurHashDecoder {
    @NotNull
    public static final BlurHashDecoder INSTANCE;
    @NotNull
    private static final HashMap<Integer, double[]> cacheCosinesX;
    @NotNull
    private static final HashMap<Integer, double[]> cacheCosinesY;
    @NotNull
    private static final Map<Character, Integer> charMap;

    private BlurHashDecoder() {
    }

    public final void clearCache() {
        cacheCosinesX.clear();
        cacheCosinesY.clear();
    }

    @Nullable
    public final Bitmap decode(@Nullable String blurHash, int width, int height, float punch, boolean useCache) {
        if (blurHash == null || blurHash.length() < 6) {
            return null;
        }
        int numCompEnc = this.decode83(blurHash, 0, 1);
        int numCompX = numCompEnc % 9 + 1;
        int numCompY = numCompEnc / 9 + 1;
        if (blurHash.length() != 4 + 2 * numCompX * numCompY) {
            return null;
        }
        int maxAcEnc = this.decode83(blurHash, 1, 2);
        float maxAc = (float)(maxAcEnc + 1) / 166.0f;
        int n = numCompX * numCompY;
        float[][] fArrayArray = new float[n][];
        for (int i = 0; i < n; ++i) {
            float[] fArray;
            int n2 = i;
            if (n2 == 0) {
                int colorEnc = INSTANCE.decode83(blurHash, 2, 6);
                fArray = INSTANCE.decodeDc(colorEnc);
            } else {
                int from = 4 + n2 * 2;
                int colorEnc = INSTANCE.decode83(blurHash, from, from + 2);
                fArray = INSTANCE.decodeAc(colorEnc, maxAc * punch);
            }
            fArrayArray[n2] = fArray;
        }
        float[][] colors = fArrayArray;
        return this.composeBitmap(width, height, numCompX, numCompY, colors, useCache);
    }

    public static /* synthetic */ Bitmap decode$default(BlurHashDecoder blurHashDecoder, String string, int n, int n2, float f, boolean bl, int n3, Object object) {
        if ((n3 & 8) != 0) {
            f = 1.0f;
        }
        if ((n3 & 0x10) != 0) {
            bl = true;
        }
        return blurHashDecoder.decode(string, n, n2, f, bl);
    }

    private final int decode83(String str, int from, int to) {
        int result = 0;
        for (int i = from; i < to; ++i) {
            int index;
            Integer n = charMap.get(Character.valueOf(str.charAt(i)));
            int n2 = index = n != null ? n : -1;
            if (index == -1) continue;
            result = result * 83 + index;
        }
        return result;
    }

    static /* synthetic */ int decode83$default(BlurHashDecoder blurHashDecoder, String string, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = string.length();
        }
        return blurHashDecoder.decode83(string, n, n2);
    }

    private final float[] decodeDc(int colorEnc) {
        int r = colorEnc >> 16;
        int g = colorEnc >> 8 & 0xFF;
        int b = colorEnc & 0xFF;
        float[] fArray = new float[]{this.srgbToLinear(r), this.srgbToLinear(g), this.srgbToLinear(b)};
        return fArray;
    }

    private final float srgbToLinear(int colorEnc) {
        float v = (float)colorEnc / 255.0f;
        return v <= 0.04045f ? v / 12.92f : (float)Math.pow((v + 0.055f) / 1.055f, 2.4f);
    }

    private final float[] decodeAc(int value, float maxAc) {
        int r = value / 361;
        int g = value / 19 % 19;
        int b = value % 19;
        float[] fArray = new float[]{this.signedPow2((float)(r - 9) / 9.0f) * maxAc, this.signedPow2((float)(g - 9) / 9.0f) * maxAc, this.signedPow2((float)(b - 9) / 9.0f) * maxAc};
        return fArray;
    }

    private final float signedPow2(float value) {
        return Math.copySign((float)Math.pow(value, 2.0f), value);
    }

    private final Bitmap composeBitmap(int width, int height, int numCompX, int numCompY, float[][] colors, boolean useCache) {
        int[] imageArray = new int[width * height];
        boolean calculateCosX = !useCache || !cacheCosinesX.containsKey(width * numCompX);
        double[] cosinesX = this.getArrayForCosinesX(calculateCosX, width, numCompX);
        boolean calculateCosY = !useCache || !cacheCosinesY.containsKey(height * numCompY);
        double[] cosinesY = this.getArrayForCosinesY(calculateCosY, height, numCompY);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                float r = 0.0f;
                float g = 0.0f;
                float b = 0.0f;
                for (int j = 0; j < numCompY; ++j) {
                    for (int i = 0; i < numCompX; ++i) {
                        double cosX = this.getCos(cosinesX, calculateCosX, i, numCompX, x, width);
                        double cosY = this.getCos(cosinesY, calculateCosY, j, numCompY, y, height);
                        float basis = (float)(cosX * cosY);
                        float[] color2 = colors[j * numCompX + i];
                        r += color2[0] * basis;
                        g += color2[1] * basis;
                        b += color2[2] * basis;
                    }
                }
                imageArray[x + width * y] = Color.rgb((int)this.linearToSrgb(r), (int)this.linearToSrgb(g), (int)this.linearToSrgb(b));
            }
        }
        Bitmap bitmap = Bitmap.createBitmap((int[])imageArray, (int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(...)");
        return bitmap;
    }

    private final double[] getArrayForCosinesY(boolean calculate, int height, int numCompY) {
        double[] dArray;
        if (calculate) {
            double[] dArray2;
            double[] it = dArray2 = new double[height * numCompY];
            boolean bl = false;
            ((Map)cacheCosinesY).put(height * numCompY, it);
            dArray = dArray2;
        } else {
            double[] dArray3 = cacheCosinesY.get(height * numCompY);
            Intrinsics.checkNotNull((Object)dArray3);
            dArray = dArray3;
        }
        return dArray;
    }

    private final double[] getArrayForCosinesX(boolean calculate, int width, int numCompX) {
        double[] dArray;
        if (calculate) {
            double[] dArray2;
            double[] it = dArray2 = new double[width * numCompX];
            boolean bl = false;
            ((Map)cacheCosinesX).put(width * numCompX, it);
            dArray = dArray2;
        } else {
            double[] dArray3 = cacheCosinesX.get(width * numCompX);
            Intrinsics.checkNotNull((Object)dArray3);
            dArray = dArray3;
        }
        return dArray;
    }

    private final double getCos(double[] $this$getCos, boolean calculate, int x, int numComp, int y, int size) {
        if (calculate) {
            $this$getCos[x + numComp * y] = Math.cos(Math.PI * (double)y * (double)x / (double)size);
        }
        return $this$getCos[x + numComp * y];
    }

    private final int linearToSrgb(float value) {
        float v = RangesKt.coerceIn((float)value, (float)0.0f, (float)1.0f);
        return v <= 0.0031308f ? (int)(v * 12.92f * 255.0f + 0.5f) : (int)((1.055f * (float)Math.pow(v, 0.41666666f) - 0.055f) * (float)255 + 0.5f);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapIndexedTo$iv$iv;
        INSTANCE = new BlurHashDecoder();
        cacheCosinesX = new HashMap();
        cacheCosinesY = new HashMap();
        Object[] objectArray = new Character[]{Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('G'), Character.valueOf('H'), Character.valueOf('I'), Character.valueOf('J'), Character.valueOf('K'), Character.valueOf('L'), Character.valueOf('M'), Character.valueOf('N'), Character.valueOf('O'), Character.valueOf('P'), Character.valueOf('Q'), Character.valueOf('R'), Character.valueOf('S'), Character.valueOf('T'), Character.valueOf('U'), Character.valueOf('V'), Character.valueOf('W'), Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z'), Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('i'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('o'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('u'), Character.valueOf('v'), Character.valueOf('w'), Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z'), Character.valueOf('#'), Character.valueOf('$'), Character.valueOf('%'), Character.valueOf('*'), Character.valueOf('+'), Character.valueOf(','), Character.valueOf('-'), Character.valueOf('.'), Character.valueOf(':'), Character.valueOf(';'), Character.valueOf('='), Character.valueOf('?'), Character.valueOf('@'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('^'), Character.valueOf('_'), Character.valueOf('{'), Character.valueOf('|'), Character.valueOf('}'), Character.valueOf('~')};
        Iterable $this$mapIndexed$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void i;
            void c;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            char c2 = ((Character)item$iv$iv).charValue();
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)Character.valueOf((char)c), (Object)((int)i)));
        }
        charMap = MapsKt.toMap((Iterable)((List)var3_3));
    }
}

