/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.base.image;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.widget.ImageView;
import androidx.annotation.DrawableRes;
import androidx.fragment.app.FragmentActivity;
import com.blankj.utilcode.util.ScreenUtils;
import com.blankj.utilcode.util.Utils;
import com.bumptech.glide.Glide;
import com.bumptech.glide.Priority;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.TransitionOptions;
import com.bumptech.glide.integration.cronet.CronetEngineSingleton;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.MultiTransformation;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.target.ViewTarget;
import com.bumptech.glide.request.transition.DrawableCrossFadeFactory;
import com.bumptech.glide.request.transition.TransitionFactory;
import com.tn.lib.logger.MBLogger;
import com.transsion.base.image.R;
import com.transsion.base.image.Resizer;
import com.transsion.base.image.blurhash.BlurHash;
import com.transsion.base.image.blurhash.BlurHashExtKt;
import java.lang.reflect.Field;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.chromium.net.CronetEngine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u0000 \u00042\u00020\u0001:\u0002\u0004\u0005B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0006"}, d2={"Lcom/transsion/base/image/ImageHelper;", "", "<init>", "()V", "Companion", "ImageBuilder", "image_psRelease"})
public final class ImageHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String TAG = "ImageHelper";
    private static int defaultGridWith = ScreenUtils.getScreenWidth() / 3;
    private static int defaultWidth = ScreenUtils.getAppScreenWidth() / 2;
    private static int defaultHeight = ScreenUtils.getScreenHeight();
    @SuppressLint(value={"StaticFieldLeak"})
    @NotNull
    private static final BlurHash blurHash;
    @NotNull
    private static final DrawableTransitionOptions fadeTransi;

    static {
        try {
            CronetEngine engine = new CronetEngine.Builder((Context)Utils.getApp()).enableHttpCache(0, 0L).enableHttp2(true).enableQuic(true).addQuicHint("test-acdn.aoneroom.com", 443, 443).addQuicHint("acdn.aoneroom.com", 443, 443).build();
            Iterator iterator = ArrayIteratorKt.iterator((Object[])CronetEngineSingleton.class.getDeclaredFields());
            while (iterator.hasNext()) {
                Field f = (Field)iterator.next();
                if (!Intrinsics.areEqual(f.getType(), CronetEngine.class)) continue;
                f.setAccessible(true);
                f.set(null, engine);
                MBLogger.Companion.d$default((MBLogger.Companion)MBLogger.Companion, (String)TAG, (String)"init CronetEngine", (boolean)false, (int)4, null);
                break;
            }
        }
        catch (Throwable ignore) {
            MBLogger.Companion.d$default((MBLogger.Companion)MBLogger.Companion, (String)TAG, (String)"init CronetEngine failed", (Throwable)ignore, (boolean)false, (int)8, null);
        }
        Application application = Utils.getApp();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApp(...)");
        blurHash = new BlurHash((Context)application, 5, 0.6f);
        DrawableTransitionOptions drawableTransitionOptions = DrawableTransitionOptions.with((TransitionFactory)((TransitionFactory)new DrawableCrossFadeFactory.Builder(100).setCrossFadeEnabled(true).build()));
        Intrinsics.checkNotNullExpressionValue((Object)drawableTransitionOptions, (String)"with(...)");
        fadeTransi = drawableTransitionOptions;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u00df\u0001\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00052\b\b\u0003\u0010\u0017\u001a\u00020\u00072\b\b\u0002\u0010\u0018\u001a\u00020\u00072\b\b\u0002\u0010\u0019\u001a\u00020\u00072\b\b\u0002\u0010\u001a\u001a\u00020\u00072\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u00052\b\b\u0002\u0010\u001e\u001a\u00020\u001c2\b\b\u0002\u0010\u001f\u001a\u00020\u001c2\b\b\u0002\u0010 \u001a\u00020\u001c2\b\b\u0002\u0010!\u001a\u00020\u001c2\b\b\u0002\u0010\"\u001a\u00020#2O\b\u0002\u0010$\u001aI\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b&\u0012\b\b'\u0012\u0004\b\b((\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b&\u0012\b\b'\u0012\u0004\b\b()\u0012\u0013\u0012\u00110*\u00a2\u0006\f\b&\u0012\b\b'\u0012\u0004\b\b(+\u0012\u0004\u0012\u00020\u0013\u0018\u00010%H\u0002J\u00e1\u0001\u00100\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00052\b\b\u0003\u0010\u0017\u001a\u00020\u00072\b\b\u0002\u0010\u001a\u001a\u00020\u00072\b\b\u0002\u0010\u0018\u001a\u00020\u00072\b\b\u0002\u0010\u0019\u001a\u00020\u00072\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u00052\b\b\u0002\u0010\u001e\u001a\u00020\u001c2\b\b\u0002\u0010\u001f\u001a\u00020\u001c2\b\b\u0002\u0010 \u001a\u00020\u001c2\b\b\u0002\u0010!\u001a\u00020\u001c2\b\b\u0002\u0010\"\u001a\u00020#2Q\b\u0002\u0010$\u001aK\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b&\u0012\b\b'\u0012\u0004\b\b((\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b&\u0012\b\b'\u0012\u0004\b\b()\u0012\u0013\u0012\u00110*\u00a2\u0006\f\b&\u0012\b\b'\u0012\u0004\b\b(+\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0018\u00010%H\u0002J2\u00101\u001a\u0002022\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00072\b\b\u0002\u0010\"\u001a\u00020#H\u0002JE\u00103\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u00104\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00072%\b\u0002\u00105\u001a\u001f\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b&\u0012\b\b'\u0012\u0004\b\b(7\u0012\u0004\u0012\u00020\u0013\u0018\u000106J,\u00108\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\b\b\u0002\u0010\u0018\u001a\u00020\u00072\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u00109\u001a\u00020\u001cR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010,\u001a\u00020-8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/transsion/base/image/ImageHelper$Companion;", "", "<init>", "()V", "TAG", "", "defaultGridWith", "", "getDefaultGridWith", "()I", "setDefaultGridWith", "(I)V", "defaultWidth", "defaultHeight", "with", "Lcom/transsion/base/image/ImageHelper$ImageBuilder;", "context", "Landroid/content/Context;", "loadNet", "", "imageView", "Landroid/widget/ImageView;", "url", "placeHolder", "width", "height", "round", "isWebP", "", "thumbnail", "isQuality", "thumbScaleType", "overrideWH", "supportH", "priority", "Lcom/bumptech/glide/Priority;", "downloadCallback", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "loadCoverSuccess", "cache", "", "duration", "blurHash", "Lcom/transsion/base/image/blurhash/BlurHash;", "fadeTransi", "Lcom/bumptech/glide/load/resource/drawable/DrawableTransitionOptions;", "intoWithThumbnail", "requestOptions", "Lcom/bumptech/glide/request/RequestOptions;", "preload", "originUrl", "callback", "Lkotlin/Function1;", "result", "getReSizeUrl", "preloadImg", "image_psRelease"})
    public static final class Companion {
        private Companion() {
        }

        public final int getDefaultGridWith() {
            return defaultGridWith;
        }

        public final void setDefaultGridWith(int n) {
            defaultGridWith = n;
        }

        @NotNull
        public final ImageBuilder with(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return new ImageBuilder(context);
        }

        private final void loadNet(Context context, ImageView imageView, String url, @DrawableRes int placeHolder, int width, int height, int round, boolean isWebP, String thumbnail, boolean isQuality, boolean thumbScaleType, boolean overrideWH, boolean supportH, Priority priority, Function3<? super Boolean, ? super Boolean, ? super Long, Unit> downloadCallback) {
            if (context instanceof FragmentActivity && ((FragmentActivity)context).isDestroyed()) {
                return;
            }
            if (TextUtils.isEmpty((CharSequence)url)) {
                Glide.with((Context)context).load("").transition((TransitionOptions)fadeTransi).apply((BaseRequestOptions)com.transsion.base.image.ImageHelper$Companion.requestOptions$default(this, placeHolder, round, overrideWH ? height : -1, overrideWH ? width : -1, null, 16, null)).into(imageView);
                return;
            }
            int needW = width;
            if (width == defaultWidth && imageView.getLayoutParams().width > 0) {
                needW = imageView.getLayoutParams().width;
            }
            try {
                this.intoWithThumbnail(context, imageView, url, placeHolder, round, needW, height, isWebP, thumbnail, isQuality, thumbScaleType, overrideWH, supportH, priority, downloadCallback);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        static /* synthetic */ void loadNet$default(Companion companion, Context context, ImageView imageView, String string, int n, int n2, int n3, int n4, boolean bl, String string2, boolean bl2, boolean bl3, boolean bl4, boolean bl5, Priority priority, Function3 function3, int n5, Object object) {
            if ((n5 & 8) != 0) {
                n = R.color.image_default;
            }
            if ((n5 & 0x10) != 0) {
                n2 = defaultWidth;
            }
            if ((n5 & 0x20) != 0) {
                n3 = defaultHeight;
            }
            if ((n5 & 0x40) != 0) {
                n4 = 0;
            }
            if ((n5 & 0x80) != 0) {
                bl = true;
            }
            if ((n5 & 0x100) != 0) {
                string2 = "";
            }
            if ((n5 & 0x200) != 0) {
                bl2 = true;
            }
            if ((n5 & 0x400) != 0) {
                bl3 = true;
            }
            if ((n5 & 0x800) != 0) {
                bl4 = false;
            }
            if ((n5 & 0x1000) != 0) {
                bl5 = false;
            }
            if ((n5 & 0x2000) != 0) {
                priority = Priority.NORMAL;
            }
            if ((n5 & 0x4000) != 0) {
                function3 = null;
            }
            companion.loadNet(context, imageView, string, n, n2, n3, n4, bl, string2, bl2, bl3, bl4, bl5, priority, (Function3<? super Boolean, ? super Boolean, ? super Long, Unit>)function3);
        }

        private final void intoWithThumbnail(Context context, ImageView imageView, String url, @DrawableRes int placeHolder, int round, int width, int height, boolean isWebP, String thumbnail, boolean isQuality, boolean thumbScaleType, boolean overrideWH, boolean supportH, Priority priority, Function3<? super Boolean, ? super Boolean, ? super Long, Unit> downloadCallback) {
            ViewTarget viewTarget;
            if (context instanceof FragmentActivity && ((FragmentActivity)context).isDestroyed()) {
                return;
            }
            int cachedSize = Resizer.INSTANCE.getCachedSize(url);
            String smallUrl = (1 <= cachedSize ? cachedSize < width + 1 : false) ? Resizer.buildResizeUrl$default(Resizer.INSTANCE, url, cachedSize, isWebP, false, 0, false, 56, null) : (((CharSequence)thumbnail).length() == 0 && width > 96 && cachedSize <= width ? Resizer.buildResizeUrl$default(Resizer.INSTANCE, url, 32, isWebP, false, 0, false, 56, null) : thumbnail);
            String bigUrl = Resizer.getReSizeUrl$default(Resizer.INSTANCE, url, width, isWebP, isQuality, height, supportH, false, 64, null);
            long reqStartTime = System.currentTimeMillis();
            if (StringsKt.startsWith$default((String)smallUrl, (String)"http", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)smallUrl, (String)"data:image", (boolean)false, (int)2, null)) {
                RequestBuilder requestBuilder = thumbScaleType ? (RequestBuilder)Glide.with((Context)context).load(smallUrl).optionalCenterCrop() : Glide.with((Context)context).load(smallUrl);
                Intrinsics.checkNotNull((Object)requestBuilder);
                RequestBuilder thumbnailRequest = requestBuilder;
                viewTarget = Glide.with((Context)context).load(bigUrl).thumbnail(thumbnailRequest).listener((RequestListener)new RequestListener<Drawable>(reqStartTime, downloadCallback){
                    final /* synthetic */ long $reqStartTime;
                    final /* synthetic */ Function3<Boolean, Boolean, Long, Unit> $downloadCallback;
                    {
                        this.$reqStartTime = $reqStartTime;
                        this.$downloadCallback = $downloadCallback;
                    }

                    public boolean onLoadFailed(GlideException e, Object model, Target<Drawable> target, boolean isFirstResource) {
                        block0: {
                            Intrinsics.checkNotNullParameter(target, (String)"target");
                            long duration = System.currentTimeMillis() - this.$reqStartTime;
                            Function3<Boolean, Boolean, Long, Unit> function3 = this.$downloadCallback;
                            if (function3 == null) break block0;
                            Unit cfr_ignored_0 = (Unit)function3.invoke((Object)false, (Object)false, (Object)duration);
                        }
                        return false;
                    }

                    public boolean onResourceReady(Drawable resource, Object model, Target<Drawable> target, DataSource dataSource, boolean isFirstResource) {
                        block0: {
                            Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
                            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
                            long duration = System.currentTimeMillis() - this.$reqStartTime;
                            Function3<Boolean, Boolean, Long, Unit> function3 = this.$downloadCallback;
                            if (function3 == null) break block0;
                            Unit cfr_ignored_0 = (Unit)function3.invoke((Object)true, (Object)(dataSource != DataSource.REMOTE ? 1 : 0), (Object)duration);
                        }
                        return false;
                    }
                }).transition((TransitionOptions)fadeTransi).apply((BaseRequestOptions)this.requestOptions(placeHolder, round, overrideWH ? height : -1, overrideWH ? width : -1, priority)).into(imageView);
            } else if (smallUrl.length() >= 6) {
                RequestBuilder requestBuilder = Glide.with((Context)context).load(bigUrl);
                Intrinsics.checkNotNullExpressionValue((Object)requestBuilder, (String)"load(...)");
                RequestBuilder loader = requestBuilder;
                BlurHashExtKt.blurPlaceHolder((RequestBuilder<Drawable>)loader, smallUrl, 20, 20, blurHash, (Function1<? super RequestBuilder<Drawable>, Unit>)((Function1)arg_0 -> Companion.intoWithThumbnail$lambda$0(imageView, arg_0)));
                viewTarget = loader.transition((TransitionOptions)fadeTransi).listener((RequestListener)new RequestListener<Drawable>(reqStartTime, downloadCallback){
                    final /* synthetic */ long $reqStartTime;
                    final /* synthetic */ Function3<Boolean, Boolean, Long, Unit> $downloadCallback;
                    {
                        this.$reqStartTime = $reqStartTime;
                        this.$downloadCallback = $downloadCallback;
                    }

                    public boolean onLoadFailed(GlideException e, Object model, Target<Drawable> target, boolean isFirstResource) {
                        block0: {
                            Intrinsics.checkNotNullParameter(target, (String)"target");
                            long duration = System.currentTimeMillis() - this.$reqStartTime;
                            Function3<Boolean, Boolean, Long, Unit> function3 = this.$downloadCallback;
                            if (function3 == null) break block0;
                            Unit cfr_ignored_0 = (Unit)function3.invoke((Object)false, (Object)false, (Object)duration);
                        }
                        return false;
                    }

                    public boolean onResourceReady(Drawable resource, Object model, Target<Drawable> target, DataSource dataSource, boolean isFirstResource) {
                        block0: {
                            Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
                            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
                            long duration = System.currentTimeMillis() - this.$reqStartTime;
                            Function3<Boolean, Boolean, Long, Unit> function3 = this.$downloadCallback;
                            if (function3 == null) break block0;
                            Unit cfr_ignored_0 = (Unit)function3.invoke((Object)true, (Object)(dataSource != DataSource.REMOTE ? 1 : 0), (Object)duration);
                        }
                        return false;
                    }
                }).apply((BaseRequestOptions)this.requestOptions(0, round, overrideWH ? height : -1, overrideWH ? width : -1, priority)).into(imageView);
            } else {
                viewTarget = Glide.with((Context)context).load(bigUrl).transition((TransitionOptions)fadeTransi).listener((RequestListener)new RequestListener<Drawable>(reqStartTime, downloadCallback){
                    final /* synthetic */ long $reqStartTime;
                    final /* synthetic */ Function3<Boolean, Boolean, Long, Unit> $downloadCallback;
                    {
                        this.$reqStartTime = $reqStartTime;
                        this.$downloadCallback = $downloadCallback;
                    }

                    public boolean onLoadFailed(GlideException e, Object model, Target<Drawable> target, boolean isFirstResource) {
                        block0: {
                            Intrinsics.checkNotNullParameter(target, (String)"target");
                            long duration = System.currentTimeMillis() - this.$reqStartTime;
                            Function3<Boolean, Boolean, Long, Unit> function3 = this.$downloadCallback;
                            if (function3 == null) break block0;
                            Unit cfr_ignored_0 = (Unit)function3.invoke((Object)false, (Object)false, (Object)duration);
                        }
                        return false;
                    }

                    public boolean onResourceReady(Drawable resource, Object model, Target<Drawable> target, DataSource dataSource, boolean isFirstResource) {
                        block0: {
                            Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
                            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
                            long duration = System.currentTimeMillis() - this.$reqStartTime;
                            Function3<Boolean, Boolean, Long, Unit> function3 = this.$downloadCallback;
                            if (function3 == null) break block0;
                            Unit cfr_ignored_0 = (Unit)function3.invoke((Object)true, (Object)(dataSource != DataSource.REMOTE ? 1 : 0), (Object)duration);
                        }
                        return false;
                    }
                }).apply((BaseRequestOptions)this.requestOptions(placeHolder, round, overrideWH ? height : -1, overrideWH ? width : -1, priority)).into(imageView);
            }
            MBLogger.Companion.d$default((MBLogger.Companion)MBLogger.Companion, (String)ImageHelper.TAG, (String)("load " + width + " use " + bigUrl + " with small " + smallUrl), (boolean)false, (int)4, null);
        }

        static /* synthetic */ void intoWithThumbnail$default(Companion companion, Context context, ImageView imageView, String string, int n, int n2, int n3, int n4, boolean bl, String string2, boolean bl2, boolean bl3, boolean bl4, boolean bl5, Priority priority, Function3 function3, int n5, Object object) {
            if ((n5 & 8) != 0) {
                n = R.color.image_default;
            }
            if ((n5 & 0x10) != 0) {
                n2 = 0;
            }
            if ((n5 & 0x20) != 0) {
                n3 = -1;
            }
            if ((n5 & 0x40) != 0) {
                n4 = -1;
            }
            if ((n5 & 0x80) != 0) {
                bl = true;
            }
            if ((n5 & 0x100) != 0) {
                string2 = "";
            }
            if ((n5 & 0x200) != 0) {
                bl2 = true;
            }
            if ((n5 & 0x400) != 0) {
                bl3 = true;
            }
            if ((n5 & 0x800) != 0) {
                bl4 = false;
            }
            if ((n5 & 0x1000) != 0) {
                bl5 = false;
            }
            if ((n5 & 0x2000) != 0) {
                priority = Priority.NORMAL;
            }
            if ((n5 & 0x4000) != 0) {
                function3 = null;
            }
            companion.intoWithThumbnail(context, imageView, string, n, n2, n3, n4, bl, string2, bl2, bl3, bl4, bl5, priority, (Function3<? super Boolean, ? super Boolean, ? super Long, Unit>)function3);
        }

        private final RequestOptions requestOptions(int placeHolder, int round, int height, int width, Priority priority) {
            BaseRequestOptions baseRequestOptions = ((RequestOptions)new RequestOptions().priority(priority)).diskCacheStrategy(DiskCacheStrategy.DATA);
            Intrinsics.checkNotNullExpressionValue((Object)baseRequestOptions, (String)"diskCacheStrategy(...)");
            RequestOptions options = (RequestOptions)baseRequestOptions;
            if (placeHolder != 0) {
                BaseRequestOptions baseRequestOptions2 = options.placeholder(placeHolder);
                Intrinsics.checkNotNullExpressionValue((Object)baseRequestOptions2, (String)"placeholder(...)");
                options = (RequestOptions)baseRequestOptions2;
            }
            if (round > 0) {
                Transformation[] transformationArray = new Transformation[]{new CenterCrop(), new RoundedCorners(round)};
                BaseRequestOptions baseRequestOptions3 = options.transform((Transformation)new MultiTransformation(transformationArray));
                Intrinsics.checkNotNullExpressionValue((Object)baseRequestOptions3, (String)"transform(...)");
                options = (RequestOptions)baseRequestOptions3;
            } else if (round < 0) {
                RequestOptions requestOptions = RequestOptions.circleCropTransform();
                Intrinsics.checkNotNullExpressionValue((Object)requestOptions, (String)"circleCropTransform(...)");
                options = requestOptions;
            }
            if (height != -1 || width != -1) {
                BaseRequestOptions baseRequestOptions4 = options.override(width, height);
                Intrinsics.checkNotNullExpressionValue((Object)baseRequestOptions4, (String)"override(...)");
                options = (RequestOptions)baseRequestOptions4;
            }
            return options;
        }

        static /* synthetic */ RequestOptions requestOptions$default(Companion companion, int n, int n2, int n3, int n4, Priority priority, int n5, Object object) {
            if ((n5 & 0x10) != 0) {
                priority = Priority.NORMAL;
            }
            return companion.requestOptions(n, n2, n3, n4, priority);
        }

        public final void preload(@NotNull String url, @NotNull String originUrl, int width, @Nullable Function1<? super Boolean, Unit> callback) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)originUrl, (String)"originUrl");
            ((RequestBuilder)Glide.with((Context)((Context)Utils.getApp())).load(url).diskCacheStrategy(DiskCacheStrategy.DATA)).addListener((RequestListener)new RequestListener<Drawable>(callback, originUrl, width){
                final /* synthetic */ Function1<Boolean, Unit> $callback;
                final /* synthetic */ String $originUrl;
                final /* synthetic */ int $width;
                {
                    this.$callback = $callback;
                    this.$originUrl = $originUrl;
                    this.$width = $width;
                }

                public boolean onLoadFailed(GlideException e, Object model, Target<Drawable> target, boolean isFirstResource) {
                    block0: {
                        Intrinsics.checkNotNullParameter(target, (String)"target");
                        Function1<Boolean, Unit> function1 = this.$callback;
                        if (function1 == null) break block0;
                        function1.invoke((Object)false);
                    }
                    return true;
                }

                public boolean onResourceReady(Drawable resource, Object model, Target<Drawable> target, DataSource dataSource, boolean isFirstResource) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
                        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
                        Resizer.INSTANCE.putCachedSize(this.$originUrl, this.$width);
                        Function1<Boolean, Unit> function1 = this.$callback;
                        if (function1 == null) break block0;
                        function1.invoke((Object)true);
                    }
                    return true;
                }
            }).preload();
        }

        public static /* synthetic */ void preload$default(Companion companion, String string, String string2, int n, Function1 function1, int n2, Object object) {
            if ((n2 & 8) != 0) {
                function1 = null;
            }
            companion.preload(string, string2, n, (Function1<? super Boolean, Unit>)function1);
        }

        @NotNull
        public final String getReSizeUrl(@NotNull String url, int width, boolean isWebP, boolean preloadImg) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return Resizer.getReSizeUrl$default(Resizer.INSTANCE, url, width, isWebP, false, 0, false, preloadImg, 56, null);
        }

        public static /* synthetic */ String getReSizeUrl$default(Companion companion, String string, int n, boolean bl, boolean bl2, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            if ((n2 & 4) != 0) {
                bl = true;
            }
            if ((n2 & 8) != 0) {
                bl2 = false;
            }
            return companion.getReSizeUrl(string, n, bl, bl2);
        }

        private static final Unit intoWithThumbnail$lambda$0(ImageView $imageView, RequestBuilder it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            it.into($imageView);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0007J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0007J\u0010\u0010!\u001a\u00020\u00002\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0010\u0010\u000e\u001a\u00020\u00002\b\b\u0001\u0010\"\u001a\u00020\u0007J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0007J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\fJ\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0011J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0011J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0011J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0017JU\u0010\u0018\u001a\u00020\u00002M\u0010\u0018\u001aI\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001d\u0012\u0013\u0012\u00110\u001e\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020 \u0018\u00010\u0019J\u000e\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020%R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000RU\u0010\u0018\u001aI\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001d\u0012\u0013\u0012\u00110\u001e\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020 \u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/transsion/base/image/ImageHelper$ImageBuilder;", "", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "defaultWidth", "", "defaultHeight", "width", "height", "url", "", "thumbnail", "placeholder", "round", "isWebP", "", "isQuality", "thumbScaleType", "overrideWH", "supportH", "priority", "Lcom/bumptech/glide/Priority;", "downloadCallback", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "loadCoverSuccess", "cache", "", "duration", "", "load", "res", "into", "imageView", "Landroid/widget/ImageView;", "image_psRelease"})
    public static final class ImageBuilder {
        @NotNull
        private final Context context;
        private final int defaultWidth;
        private final int defaultHeight;
        private int width;
        private int height;
        @NotNull
        private String url;
        @NotNull
        private String thumbnail;
        private int placeholder;
        private int round;
        private boolean isWebP;
        private boolean isQuality;
        private boolean thumbScaleType;
        private boolean overrideWH;
        private boolean supportH;
        @NotNull
        private Priority priority;
        @Nullable
        private Function3<? super Boolean, ? super Boolean, ? super Long, Unit> downloadCallback;

        public ImageBuilder(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.context = context;
            this.defaultWidth = ScreenUtils.getAppScreenWidth() / 2;
            this.defaultHeight = ScreenUtils.getScreenHeight();
            this.width = this.defaultWidth;
            this.height = this.defaultHeight;
            this.url = "";
            this.thumbnail = "";
            this.placeholder = R.color.image_default;
            this.isWebP = true;
            this.isQuality = true;
            this.thumbScaleType = true;
            this.priority = Priority.NORMAL;
        }

        @NotNull
        public final ImageBuilder width(int width) {
            this.width = width;
            return this;
        }

        @NotNull
        public final ImageBuilder height(int height) {
            this.height = height;
            this.supportH = true;
            return this;
        }

        @NotNull
        public final ImageBuilder load(@Nullable String url) {
            String string = url;
            if (string == null) {
                string = "";
            }
            this.url = string;
            return this;
        }

        @NotNull
        public final ImageBuilder placeholder(@DrawableRes int res) {
            this.placeholder = res;
            return this;
        }

        @NotNull
        public final ImageBuilder round(int round) {
            this.round = round;
            return this;
        }

        @NotNull
        public final ImageBuilder isWebP(boolean isWebP) {
            this.isWebP = isWebP;
            return this;
        }

        @NotNull
        public final ImageBuilder thumbnail(@NotNull String thumbnail) {
            Intrinsics.checkNotNullParameter((Object)thumbnail, (String)"thumbnail");
            this.thumbnail = thumbnail;
            return this;
        }

        @NotNull
        public final ImageBuilder isQuality(boolean isQuality) {
            this.isQuality = isQuality;
            return this;
        }

        @NotNull
        public final ImageBuilder thumbScaleType(boolean thumbScaleType) {
            this.thumbScaleType = thumbScaleType;
            return this;
        }

        @NotNull
        public final ImageBuilder overrideWH(boolean overrideWH) {
            this.overrideWH = overrideWH;
            return this;
        }

        @NotNull
        public final ImageBuilder priority(@NotNull Priority priority) {
            Intrinsics.checkNotNullParameter((Object)priority, (String)"priority");
            this.priority = priority;
            return this;
        }

        @NotNull
        public final ImageBuilder downloadCallback(@Nullable Function3<? super Boolean, ? super Boolean, ? super Long, Unit> downloadCallback) {
            this.downloadCallback = downloadCallback;
            return this;
        }

        public final void into(@NotNull ImageView imageView) {
            Intrinsics.checkNotNullParameter((Object)imageView, (String)"imageView");
            Companion.loadNet(this.context, imageView, this.url, this.placeholder, this.width, this.height, this.round, this.isWebP, this.thumbnail, this.isQuality, this.thumbScaleType, this.overrideWH, this.supportH, this.priority, (Function3<? super Boolean, ? super Boolean, ? super Long, Unit>)this.downloadCallback);
        }
    }
}

