package com.transsion.baseui.image.glide

import android.graphics.Bitmap
import com.bumptech.glide.load.engine.bitmap_recycle.LruBitmapPool

/**
 *
 * Created by kun.xu on 2025/9/5 15:05
 * Description:安全的 BitmapPool，避免已被 recycle 的 Bitmap 导致崩溃
 *
 */
class GlideSafeBitmapPool(maxSize: Long) : LruBitmapPool(maxSize) {

    override fun put(bitmap: Bitmap?) {
        if (bitmap == null || bitmap.isRecycled) {
            // 丢弃已回收或空的 Bitmap
            return
        }
        kotlin.runCatching {
            super.put(bitmap)
        }
    }

    override fun get(width: Int, height: Int, config: Bitmap.Config): Bitmap {
        val bitmap = super.get(width, height, config)
        return if (bitmap.isRecycled) {
            // 丢掉已 recycle 的，返回一个全新的 Bitmap
            Bitmap.createBitmap(width, height, config)
        } else {
            bitmap
        }
    }

    override fun getDirty(width: Int, height: Int, config: Bitmap.Config): Bitmap {
        val bitmap = super.getDirty(width, height, config)
        return if (bitmap.isRecycled) {
            Bitmap.createBitmap(width, height, config)
        } else {
            bitmap
        }
    }
}