package com.transsion.base.image.blurhash

import android.graphics.drawable.BitmapDrawable
import com.blankj.utilcode.util.Utils

/**
 * 向外部提供 简单高斯效果，图片效果来源为 cover?.thumbnail
 *
 * 示例:
 * BlurHashHelper.execute(item.cover?.thumbnail ?: "",20,20){
    ivGaussianBlur.setImageDrawable(it)
   }
 *
 *
 */
object BlurHashHelper {

    private val blurHash by lazy { BlurHash(Utils.getApp(), 10, 0.6f) }

    /**
     *
     * @param blurString String  传递接口下发的 cover?.thumbnail
     * @param width Int   最好使用默认20  过大解析较慢
     * @param height Int  最好使用默认20  过大解析较慢
     * @param response Function1<[@kotlin.ParameterName] BitmapDrawable, Unit>
     */
    fun execute(
        blurString: String,
        width: Int = 20,
        height: Int = 20,
        response: (drawable: BitmapDrawable) -> Unit
    ) {
        blurHash.execute(blurString, width, height, response)
    }
}


