package com.tn.lib.thread.wrapper

import com.tn.lib.thread.config.LocalConfigs
import com.tn.lib.thread.config.ThreadTools
import com.tn.lib.thread.dispatcher.RunnableDispatcher
import java.util.concurrent.Callable


/**
 * 任务封装监听Runnable执行流程
 * @author: huangyeling
 * @date: 2021/7/28
 */
class RunnableWrapper:Runnable{

    private var threadName: String
    private var runnable: Runnable? = null
    private var dispatcher: RunnableDispatcher
    private var callable: Callable<*>? = null

    constructor(localConfigs: LocalConfigs){
        this.threadName = localConfigs.threadName
        this.dispatcher = RunnableDispatcher(localConfigs.runnableCallback,localConfigs.deliver,localConfigs.asyncCallback)

    }

    fun setRunnable(runnable: Runnable): RunnableWrapper {
        this.runnable = runnable
        return this
    }

    fun setCallable(callable: Callable<*>?): RunnableWrapper {
        this.callable = callable
        return this
    }


    override fun run() {
        var currentThread = Thread.currentThread()
        ThreadTools.restThread(currentThread, threadName, dispatcher)
        dispatcher?.onStart(threadName)

        if(runnable != null){
            runnable?.run()
        }else if(callable != null){
            try {
                var result = callable?.call()
                dispatcher?.onSuccess()
            }catch (e: Exception){
                dispatcher?.onError(threadName,e)
            }
        }
        dispatcher?.onCompleted(threadName)
    }

}