package com.tn.lib.util

import android.app.Activity
import android.app.Application
import android.os.Bundle
import java.util.*

/**
 * @author xinbing.zhang
 * @date :2022/12/21 11:10
 * @description: 自定义维护Activity栈
 */
class ActivityStackManager : Application.ActivityLifecycleCallbacks {

    companion object {
        val instance by lazy(LazyThreadSafetyMode.NONE) {
            ActivityStackManager()
        }
    }

    /***手动维护当前App的Activity栈*/
    private var stack: Stack<Activity>? = null

    init {
        stack = Stack()
    }

    /***这个必须要调用的*/
    fun register(app: Application) {
        app.registerActivityLifecycleCallbacks(this)
    }

    /***获取第二个Activity的class name*/
    fun getSecondActivitySimpleClassName(): String {
        return stack?.let {
            if (it.size <= 1) {
                ""
            } else {
                it[it.size - 2].javaClass.simpleName
            }
        } ?: kotlin.run {
            ""
        }
    }


    // =============================================================================================


    override fun onActivityCreated(activity: Activity, savedInstanceState: Bundle?) {
        stack?.add(activity);
    }

    override fun onActivityStarted(activity: Activity) {
        //("Not yet implemented")
    }

    override fun onActivityResumed(activity: Activity) {
        //("Not yet implemented")
    }

    override fun onActivityPaused(activity: Activity) {
        //("Not yet implemented")
    }

    override fun onActivityStopped(activity: Activity) {
        //("Not yet implemented")
    }

    override fun onActivitySaveInstanceState(activity: Activity, outState: Bundle) {
        //("Not yet implemented")
    }

    override fun onActivityDestroyed(activity: Activity) {
        stack?.remove(activity);
    }

}