package com.tn.lib.util.process

import android.app.ActivityManager
import android.app.Application
import android.content.Context
import com.blankj.utilcode.util.ProcessUtils
import com.tn.lib.util.bean.ProcessType

class TNProcessUtil {
    companion object {

        const val PROCESS_CORE_TAG = ":core"
        const val PROCESS_ANDROID_MEDIA = "android.media"
        const val PROCESS_RESIDENT_TAG = ":resident"

        fun getProcessType(app: Application): ProcessType {
            val processName = ProcessUtils.getCurrentProcessName()
            val packageName = app.packageName

            when (processName) {
                packageName + PROCESS_CORE_TAG -> {
                    return ProcessType.CORE_PROCESS
                }
                PROCESS_ANDROID_MEDIA -> {
                    return ProcessType.ANDROID_MEDIA_PROCESS
                }
                packageName + PROCESS_RESIDENT_TAG -> {
                    return ProcessType.RESIDENT_PROCESS
                }
                packageName -> {
                    return ProcessType.MAIN_PROCESS
                }
            }

            return ProcessType.UNKNOWN
        }

        fun isRunningTaskExist(context: Context, processName: String): Boolean {
            var res = false
            try {
                val am = context.getSystemService(Context.ACTIVITY_SERVICE) as? ActivityManager
                val processList = am?.runningAppProcesses
                processList?.let {
                    for (info in it) {
                        if (info.processName == processName) {
                            res = true
                        }
                    }
                }
            } catch (e: Throwable) {
            }
            return res
        }

        fun isAliveProcess(): Boolean {
            val processName = ProcessUtils.getCurrentProcessName()
            return processName == "android.al1" || processName == "android.al2" || processName == "android.al3"
        }
    }
}