/*
 * Decompiled with CFR 0.152.
 */
package com.tn.lib.util.device;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.app.Application;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.blankj.utilcode.util.PhoneUtils;
import com.tencent.mmkv.MMKV;
import com.tn.lib.logger.Logger;
import com.tn.lib.util.UtilApplication;
import com.tn.lib.util.device.TNDeviceHelper;
import com.tn.lib.util.device.oaid.OAIDService;
import com.tn.lib.util.md5.MD5;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Locale;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0004J\u0006\u0010\u0017\u001a\u00020\u0004J\u0006\u0010\u0018\u001a\u00020\u0004J\u0006\u0010\u0019\u001a\u00020\u0004J\b\u0010\u001a\u001a\u0004\u0018\u00010\u0004J\u0006\u0010\u001b\u001a\u00020\u0004J\u0006\u0010\u001c\u001a\u00020\u0004J\b\u0010\u001d\u001a\u0004\u0018\u00010\u0004J\b\u0010\u001e\u001a\u00020\u0004H\u0007J\b\u0010\u001f\u001a\u00020\u0004H\u0007J\u0006\u0010 \u001a\u00020\u0004J\u000e\u0010!\u001a\u00020\"2\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010#\u001a\u00020\u0004J\u0006\u0010$\u001a\u00020\u0004J\u0006\u0010%\u001a\u00020\u0004J\u000e\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u0004J\u000e\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u0004J\u000e\u0010*\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R#\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006,"}, d2={"Lcom/tn/lib/util/device/TNDeviceHelper;", "", "()V", "CPU_INFO", "", "GID_ACTION", "GMS_PACKAGE", "STABLE_ANDROID_ID", "kvAndroidId", "kvDeviceId", "kvGmsAdId", "netMmkv", "Lcom/tencent/mmkv/MMKV;", "kotlin.jvm.PlatformType", "getNetMmkv", "()Lcom/tencent/mmkv/MMKV;", "netMmkv$delegate", "Lkotlin/Lazy;", "doGetGid", "", "context", "Landroid/content/Context;", "getAndroidId", "getBrand", "getCPU", "getCountry", "getCountryCode", "getDeviceId", "getGaid", "getHardWare", "getImei", "getImsi", "getLanguage", "getMemoryInfo", "Landroid/app/ActivityManager$MemoryInfo;", "getModel", "getOsVersion", "getSimOperator", "saveAndroidId", "androidId", "saveDeviceId", "deviceId", "saveGaid", "gid", "lib_release"})
@SourceDebugExtension(value={"SMAP\nTNDeviceHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TNDeviceHelper.kt\ncom/tn/lib/util/device/TNDeviceHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,255:1\n1#2:256\n37#3,2:257\n*S KotlinDebug\n*F\n+ 1 TNDeviceHelper.kt\ncom/tn/lib/util/device/TNDeviceHelper\n*L\n159#1:257,2\n*E\n"})
public final class TNDeviceHelper {
    @NotNull
    public static final TNDeviceHelper INSTANCE = new TNDeviceHelper();
    @NotNull
    private static final Lazy netMmkv$delegate = LazyKt.lazy((Function0)netMmkv.2.INSTANCE);
    @Nullable
    private static String kvAndroidId;
    @Nullable
    private static String kvGmsAdId;
    @Nullable
    private static String kvDeviceId;
    @NotNull
    private static final String GID_ACTION = "com.google.android.gms.ads.identifier.service.START";
    @NotNull
    private static final String GMS_PACKAGE = "com.google.android.gms";
    @NotNull
    private static final String CPU_INFO = "/proc/cpuinfo";
    @NotNull
    private static final String STABLE_ANDROID_ID = "9774d56d682e549c";

    private TNDeviceHelper() {
    }

    public final MMKV getNetMmkv() {
        Lazy lazy = netMmkv$delegate;
        return (MMKV)lazy.getValue();
    }

    public final void doGetGid(@NotNull Context context) {
        String gid;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(context instanceof Application)) {
            Logger.Companion.d$default(Logger.Companion, "DeviceHelper", "please pass in application to avoid Service not registered exception ", false, 4, null);
            return;
        }
        MMKV mMKV = this.getNetMmkv();
        String string = gid = mMKV != null ? mMKV.getString("apkgaid", "") : null;
        if (!TextUtils.isEmpty((CharSequence)gid)) {
            Logger.Companion.d$default(Logger.Companion, "DeviceHelper", "gid has get gid " + gid, false, 4, null);
            return;
        }
        Intent intent = new Intent(GID_ACTION);
        intent.setPackage(GMS_PACKAGE);
        OAIDService.Companion.bind(context, intent);
    }

    public final void saveGaid(@NotNull String gid) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)gid, (String)"gid");
            MMKV mMKV = this.getNetMmkv();
            if (mMKV == null) break block0;
            mMKV.putString("apkgaid", gid);
        }
    }

    public final void saveAndroidId(@NotNull String androidId) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)androidId, (String)"androidId");
            MMKV mMKV = this.getNetMmkv();
            if (mMKV == null) break block0;
            mMKV.putString("apkandroidid", androidId);
        }
    }

    @NotNull
    public final String getAndroidId() {
        String string;
        String androidId;
        if (TextUtils.isEmpty((CharSequence)kvAndroidId)) {
            MMKV mMKV = this.getNetMmkv();
            String string2 = kvAndroidId = mMKV != null ? mMKV.getString("apkandroidid", "") : null;
        }
        if (TextUtils.isEmpty((CharSequence)(androidId = kvAndroidId))) {
            Application application = UtilApplication.Companion.getApplication();
            androidId = Settings.System.getString((ContentResolver)(application != null ? application.getContentResolver() : null), (String)"android_id");
        }
        if ((string = androidId) == null) {
            string = "";
        }
        return string;
    }

    public final void saveDeviceId(@NotNull String deviceId) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
            MMKV mMKV = this.getNetMmkv();
            if (mMKV == null) break block0;
            mMKV.putString("apkdeviceid", deviceId);
        }
    }

    @NotNull
    public final String getGaid() {
        String gaid;
        if (TextUtils.isEmpty((CharSequence)kvGmsAdId)) {
            MMKV mMKV = this.getNetMmkv();
            String string = kvGmsAdId = mMKV != null ? mMKV.getString("apkgaid", "") : null;
        }
        if (!TextUtils.isEmpty((CharSequence)(gaid = String.valueOf(kvGmsAdId)))) {
            return gaid;
        }
        String android = this.getAndroidId();
        if (!TextUtils.isEmpty((CharSequence)android)) {
            return android;
        }
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        return string;
    }

    @SuppressLint(value={"MissingPermission"})
    @NotNull
    public final String getImei() {
        String string;
        try {
            String string2 = PhoneUtils.getIMEI();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n            PhoneUtils.getIMEI()\n        }");
            string = string2;
        }
        catch (Exception e) {
            e.printStackTrace();
            string = "";
        }
        return string;
    }

    @SuppressLint(value={"MissingPermission"})
    @NotNull
    public final String getImsi() {
        String string;
        try {
            String string2 = PhoneUtils.getIMSI();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n            PhoneUtils.getIMSI()\n        }");
            string = string2;
        }
        catch (Exception e) {
            e.printStackTrace();
            string = "";
        }
        return string;
    }

    @NotNull
    public final String getBrand() {
        String string = Build.BRAND;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"BRAND");
        return string;
    }

    @NotNull
    public final String getModel() {
        String string = Build.MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MODEL");
        return string;
    }

    @NotNull
    public final String getOsVersion() {
        String string = Build.VERSION.RELEASE;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RELEASE");
        return string;
    }

    @NotNull
    public final String getSimOperator() {
        Application application = UtilApplication.Companion.getApplication();
        Object object = application != null ? application.getSystemService("phone") : null;
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.telephony.TelephonyManager");
        TelephonyManager tm = (TelephonyManager)object;
        String string = tm.getSimOperator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tm.simOperator");
        return string;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final String getHardWare() {
        try {
            void $this$toTypedArray$iv;
            Object it;
            FileReader fr = new FileReader(CPU_INFO);
            BufferedReader br = new BufferedReader(fr);
            String text = null;
            String last = "";
            do {
                String string = br.readLine();
                it = string;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                text = it;
                if (string == null) return Build.HARDWARE;
            } while (!StringsKt.contains$default((CharSequence)(last = text), (CharSequence)"Hardware", (boolean)false, (int)2, null));
            it = last;
            Regex bl = new Regex(":\\s+");
            int n = 2;
            it = bl.split((CharSequence)it, n);
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            String[] hardWare = thisCollection$iv.toArray(new String[0]);
            return hardWare[1];
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return Build.HARDWARE;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Build.HARDWARE;
    }

    @NotNull
    public final String getDeviceId() {
        if (TextUtils.isEmpty((CharSequence)kvDeviceId)) {
            MMKV mMKV = this.getNetMmkv();
            kvDeviceId = mMKV != null ? mMKV.getString("apkdeviceid", "") : null;
        }
        String deviceId = String.valueOf(kvDeviceId);
        if (TextUtils.isEmpty((CharSequence)kvAndroidId)) {
            MMKV mMKV = this.getNetMmkv();
            kvAndroidId = mMKV != null ? mMKV.getString("apkandroidid", "") : null;
        }
        String androidId = String.valueOf(kvAndroidId);
        if (!TextUtils.isEmpty((CharSequence)deviceId)) {
            return deviceId;
        }
        if (!TextUtils.isEmpty((CharSequence)androidId)) {
            String decodeAndroidId = MD5.Companion.getStringMD5(androidId);
            this.saveDeviceId(decodeAndroidId);
            return decodeAndroidId;
        }
        Application application = UtilApplication.Companion.getApplication();
        String string = Settings.System.getString((ContentResolver)(application != null ? application.getContentResolver() : null), (String)"android_id");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(\n            U\u2026cure.ANDROID_ID\n        )");
        androidId = string;
        if (!TextUtils.isEmpty((CharSequence)androidId) && !Intrinsics.areEqual((Object)androidId, (Object)STABLE_ANDROID_ID)) {
            deviceId = MD5.Companion.getStringMD5(androidId);
            this.saveDeviceId(deviceId);
            this.saveAndroidId(androidId);
        } else {
            String string2 = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"randomUUID().toString()");
            String uuid = string2;
            deviceId = MD5.Companion.getStringMD5(uuid);
            this.saveDeviceId(deviceId);
        }
        return deviceId;
    }

    @NotNull
    public final ActivityManager.MemoryInfo getMemoryInfo(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("activity");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.ActivityManager");
        ActivityManager am = (ActivityManager)object;
        ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
        am.getMemoryInfo(mi);
        return mi;
    }

    @NotNull
    public final String getLanguage() {
        Locale currentLocale = Locale.getDefault();
        String currentLanguage = currentLocale.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)currentLanguage, (String)"currentLanguage");
        return currentLanguage;
    }

    @NotNull
    public final String getCountry() {
        Locale currentLocale = Locale.getDefault();
        String string = currentLocale.getCountry();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"currentLocale.country");
        return string;
    }

    @NotNull
    public final String getCPU() {
        Object[] objectArray = Build.SUPPORTED_ABIS;
        return StringsKt.replace$default((String)StringsKt.replace$default((String)ArraysKt.contentDeepToString((Object[])objectArray), (String)"[", (String)"", (boolean)false, (int)4, null), (String)"]", (String)"", (boolean)false, (int)4, null);
    }

    @Nullable
    public final String getCountryCode() {
        TelephonyManager telephonyManager;
        Application application = UtilApplication.Companion.getApplication();
        Object object = application != null ? application.getSystemService("phone") : null;
        TelephonyManager telephonyManager2 = telephonyManager = object instanceof TelephonyManager ? (TelephonyManager)object : null;
        object = telephonyManager2 != null ? telephonyManager2.getSimCountryIso() : null;
        if (object == null || object.length() == 0) {
            TelephonyManager telephonyManager3 = telephonyManager;
            return telephonyManager3 != null ? telephonyManager3.getNetworkCountryIso() : null;
        }
        TelephonyManager telephonyManager4 = telephonyManager;
        return telephonyManager4 != null ? telephonyManager4.getSimCountryIso() : null;
    }
}

