/*
 * Decompiled with CFR 0.152.
 */
package com.tn.lib.util.networkinfo;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import com.blankj.utilcode.util.Utils;
import com.tn.lib.util.networkinfo.NetWorkCallback;
import com.tn.lib.util.networkinfo.NetworkType;
import com.tn.lib.util.networkinfo.OnNetworkStatusChangedListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0006\u0010\u000b\u001a\u00020\nJ\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u0004J\b\u0010\u000f\u001a\u00020\rH\u0002J\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0016\u001a\u00020\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u0010\u0010\u0019\u001a\u00020\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u00a8\u0006\u001a"}, d2={"Lcom/tn/lib/util/networkinfo/NetworkUtil;", "", "()V", "destroy", "", "getActiveNetworkInfo", "Landroid/net/NetworkInfo;", "getNetState", "", "getNetType", "Lcom/tn/lib/util/networkinfo/NetworkType;", "getNetworkType", "hasCapabilityAsync", "", "initNetwork", "isEthernet", "isMobileConnected", "context", "Landroid/content/Context;", "isNetworkCapability", "isNetworkConnected", "isWifiConnected", "registerNetworkStatusChangedListener", "listener", "Lcom/tn/lib/util/networkinfo/OnNetworkStatusChangedListener;", "unregisterNetworkStatusChangedListener", "lib_release"})
public final class NetworkUtil {
    @NotNull
    public static final NetworkUtil INSTANCE = new NetworkUtil();

    private NetworkUtil() {
    }

    public final void initNetwork() {
        NetWorkCallback.Companion.getINSTANCE().registerNetworkCallback();
    }

    public final void destroy() {
        NetWorkCallback.Companion.getINSTANCE().unregisterNetworkCallback();
    }

    public final void registerNetworkStatusChangedListener(@Nullable OnNetworkStatusChangedListener listener) {
        NetWorkCallback.Companion.getINSTANCE().registerNetworkStatusChangedListener(listener);
    }

    public final void unregisterNetworkStatusChangedListener(@Nullable OnNetworkStatusChangedListener listener) {
        NetWorkCallback.Companion.getINSTANCE().unregisterNetworkStatusChangedListener(listener);
    }

    public final boolean isNetworkCapability(@NotNull Context context) {
        Network activeNetwork;
        NetworkCapabilities networkCapabilities;
        NetworkInfo mNetworkInfo;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("connectivity");
        ConnectivityManager connectivityManager = object instanceof ConnectivityManager ? (ConnectivityManager)object : null;
        if (connectivityManager == null) {
            return false;
        }
        ConnectivityManager mConnectivityManager = connectivityManager;
        boolean bl = Build.VERSION.SDK_INT < 23 ? (mNetworkInfo = mConnectivityManager.getActiveNetworkInfo()) != null && mNetworkInfo.isConnected() : (networkCapabilities = mConnectivityManager.getNetworkCapabilities(activeNetwork = mConnectivityManager.getActiveNetwork())) != null && networkCapabilities.hasCapability(16);
        return bl;
    }

    public final boolean isWifiConnected(@NotNull Context context) {
        Network activeNetwork;
        NetworkCapabilities networkCapabilities;
        NetworkInfo mWiFiNetworkInfo;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("connectivity");
        ConnectivityManager connectivityManager = object instanceof ConnectivityManager ? (ConnectivityManager)object : null;
        if (connectivityManager == null) {
            return false;
        }
        ConnectivityManager mConnectivityManager = connectivityManager;
        boolean bl = Build.VERSION.SDK_INT < 23 ? (mWiFiNetworkInfo = mConnectivityManager.getNetworkInfo(1)) != null && mWiFiNetworkInfo.isConnected() : (networkCapabilities = mConnectivityManager.getNetworkCapabilities(activeNetwork = mConnectivityManager.getActiveNetwork())) != null && networkCapabilities.hasTransport(1);
        return bl;
    }

    public final boolean isMobileConnected(@NotNull Context context) {
        Network activeNetwork;
        NetworkCapabilities networkCapabilities;
        NetworkInfo mWiFiNetworkInfo;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("connectivity");
        ConnectivityManager connectivityManager = object instanceof ConnectivityManager ? (ConnectivityManager)object : null;
        if (connectivityManager == null) {
            return false;
        }
        ConnectivityManager mConnectivityManager = connectivityManager;
        boolean bl = Build.VERSION.SDK_INT < 23 ? (mWiFiNetworkInfo = mConnectivityManager.getNetworkInfo(0)) != null && mWiFiNetworkInfo.isConnected() : (networkCapabilities = mConnectivityManager.getNetworkCapabilities(activeNetwork = mConnectivityManager.getActiveNetwork())) != null && networkCapabilities.hasTransport(0);
        return bl;
    }

    public final boolean isNetworkConnected(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("connectivity");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.net.ConnectivityManager");
        ConnectivityManager mConnectivityManager = (ConnectivityManager)object;
        if (Build.VERSION.SDK_INT < 23) {
            NetworkInfo mNetworkInfo = mConnectivityManager.getActiveNetworkInfo();
            if (mNetworkInfo != null) {
                return mNetworkInfo.isAvailable();
            }
        } else {
            Network network = mConnectivityManager.getActiveNetwork();
            if (network == null) {
                return false;
            }
            Network network2 = network;
            NetworkCapabilities networkCapabilities = mConnectivityManager.getNetworkCapabilities(network2);
            if (networkCapabilities == null) {
                return false;
            }
            NetworkCapabilities status = networkCapabilities;
            if (status.hasCapability(12)) {
                return true;
            }
        }
        return false;
    }

    public final boolean hasCapabilityAsync() {
        return NetWorkCallback.Companion.getINSTANCE().isConnected();
    }

    public final int getNetState() {
        return NetWorkCallback.Companion.getINSTANCE().getNetState();
    }

    @Nullable
    public final NetworkType getNetType() {
        return NetWorkCallback.Companion.getINSTANCE().getNetworkType();
    }

    private final NetworkInfo getActiveNetworkInfo() {
        ConnectivityManager cm;
        Object object = Utils.getApp().getSystemService("connectivity");
        ConnectivityManager connectivityManager = cm = object instanceof ConnectivityManager ? (ConnectivityManager)object : null;
        return connectivityManager != null ? connectivityManager.getActiveNetworkInfo() : null;
    }

    private final boolean isEthernet() {
        Object object = Utils.getApp().getSystemService("connectivity");
        ConnectivityManager connectivityManager = object instanceof ConnectivityManager ? (ConnectivityManager)object : null;
        if (connectivityManager == null) {
            return false;
        }
        ConnectivityManager cm = connectivityManager;
        NetworkInfo networkInfo = cm.getNetworkInfo(9);
        if (networkInfo == null) {
            return false;
        }
        NetworkInfo info = networkInfo;
        NetworkInfo.State state = info.getState();
        if (state == null) {
            return false;
        }
        NetworkInfo.State state2 = state;
        return state2 == NetworkInfo.State.CONNECTED || state2 == NetworkInfo.State.CONNECTING;
    }

    @NotNull
    public final NetworkType getNetworkType() {
        NetworkType networkType;
        if (this.isEthernet()) {
            return NetworkType.NETWORK_ETHERNET;
        }
        NetworkInfo info = this.getActiveNetworkInfo();
        if (info != null) {
            block0 : switch (info.getType()) {
                case 1: {
                    networkType = NetworkType.NETWORK_WIFI;
                    break;
                }
                case 0: {
                    switch (info.getSubtype()) {
                        case 1: 
                        case 2: 
                        case 4: 
                        case 7: 
                        case 11: 
                        case 16: {
                            networkType = NetworkType.NETWORK_2G;
                            break block0;
                        }
                        case 3: 
                        case 5: 
                        case 6: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 12: 
                        case 14: 
                        case 15: 
                        case 17: {
                            networkType = NetworkType.NETWORK_3G;
                            break block0;
                        }
                        case 13: 
                        case 18: {
                            networkType = NetworkType.NETWORK_4G;
                            break block0;
                        }
                        case 20: {
                            networkType = NetworkType.NETWORK_5G;
                            break block0;
                        }
                    }
                    String subtypeName = info.getSubtypeName();
                    if (StringsKt.equals((String)subtypeName, (String)"TD-SCDMA", (boolean)true) || StringsKt.equals((String)subtypeName, (String)"WCDMA", (boolean)true) || StringsKt.equals((String)subtypeName, (String)"CDMA2000", (boolean)true)) {
                        networkType = NetworkType.NETWORK_3G;
                        break;
                    }
                    networkType = NetworkType.NETWORK_UNKNOWN;
                    break;
                }
                default: {
                    networkType = NetworkType.NETWORK_UNKNOWN;
                    break;
                }
            }
        } else {
            networkType = NetworkType.NETWORK_NO;
        }
        return networkType;
    }
}

