/*
 * Decompiled with CFR 0.152.
 */
package com.tn.lib.util.process;

import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import com.blankj.utilcode.util.ProcessUtils;
import com.tn.lib.util.bean.ProcessType;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/tn/lib/util/process/TNProcessUtil;", "", "()V", "Companion", "lib_release"})
public final class TNProcessUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PROCESS_CORE_TAG = ":core";
    @NotNull
    public static final String PROCESS_ANDROID_MEDIA = "android.media";
    @NotNull
    public static final String PROCESS_RESIDENT_TAG = ":resident";

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/tn/lib/util/process/TNProcessUtil$Companion;", "", "()V", "PROCESS_ANDROID_MEDIA", "", "PROCESS_CORE_TAG", "PROCESS_RESIDENT_TAG", "getProcessType", "Lcom/tn/lib/util/bean/ProcessType;", "app", "Landroid/app/Application;", "isAliveProcess", "", "isRunningTaskExist", "context", "Landroid/content/Context;", "processName", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ProcessType getProcessType(@NotNull Application app) {
            Intrinsics.checkNotNullParameter((Object)app, (String)"app");
            String processName = ProcessUtils.getCurrentProcessName();
            String packageName = app.getPackageName();
            String string = processName;
            if (Intrinsics.areEqual((Object)string, (Object)(packageName + TNProcessUtil.PROCESS_CORE_TAG))) {
                return ProcessType.CORE_PROCESS;
            }
            if (Intrinsics.areEqual((Object)string, (Object)TNProcessUtil.PROCESS_ANDROID_MEDIA)) {
                return ProcessType.ANDROID_MEDIA_PROCESS;
            }
            if (Intrinsics.areEqual((Object)string, (Object)(packageName + TNProcessUtil.PROCESS_RESIDENT_TAG))) {
                return ProcessType.RESIDENT_PROCESS;
            }
            if (Intrinsics.areEqual((Object)string, (Object)packageName)) {
                return ProcessType.MAIN_PROCESS;
            }
            return ProcessType.UNKNOWN;
        }

        public final boolean isRunningTaskExist(@NotNull Context context, @NotNull String processName) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
            boolean res = false;
            try {
                List processList;
                ActivityManager am;
                Object object = context.getSystemService("activity");
                ActivityManager activityManager = am = object instanceof ActivityManager ? (ActivityManager)object : null;
                List list = processList = activityManager != null ? activityManager.getRunningAppProcesses() : null;
                if (list != null) {
                    List it = list;
                    boolean bl = false;
                    for (ActivityManager.RunningAppProcessInfo info : it) {
                        if (!Intrinsics.areEqual((Object)info.processName, (Object)processName)) continue;
                        res = true;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return res;
        }

        public final boolean isAliveProcess() {
            String processName = ProcessUtils.getCurrentProcessName();
            return Intrinsics.areEqual((Object)processName, (Object)"android.al1") || Intrinsics.areEqual((Object)processName, (Object)"android.al2") || Intrinsics.areEqual((Object)processName, (Object)"android.al3");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

