/*
 * Decompiled with CFR 0.152.
 */
package com.tn.lib.util.scheme;

import com.tn.lib.util.scheme.ApkUtil;
import com.tn.lib.util.scheme.SignatureNotFoundException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Arrays;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class SchemeUtil {
    private static final int id = 0x71777777;
    private static final String CONTENT_CHARSET = "UTF-8";

    public static String getScheme(File file, String key) {
        Map<Integer, ByteBuffer> map = SchemeUtil._getV2ExtroInfo(file);
        if (null == map) {
            return null;
        }
        ByteBuffer buf = map.get(0x71777777);
        if (null == buf) {
            return null;
        }
        try {
            return SchemeUtil.parseRes(new String(SchemeUtil.getBytes(buf), CONTENT_CHARSET), key);
        }
        catch (UnsupportedEncodingException e) {
            return SchemeUtil.parseRes(new String(SchemeUtil.getBytes(buf)), key);
        }
    }

    public static String getScheme(File file) {
        Map<Integer, ByteBuffer> map = SchemeUtil._getV2ExtroInfo(file);
        if (null == map) {
            return null;
        }
        ByteBuffer buf = map.get(0x71777777);
        if (null == buf) {
            return null;
        }
        try {
            return SchemeUtil.parseRes(new String(SchemeUtil.getBytes(buf), CONTENT_CHARSET));
        }
        catch (UnsupportedEncodingException e) {
            return SchemeUtil.parseRes(new String(SchemeUtil.getBytes(buf)));
        }
    }

    private static byte[] getBytes(ByteBuffer byteBuffer) {
        byte[] array = byteBuffer.array();
        int arrayOffset = byteBuffer.arrayOffset();
        return Arrays.copyOfRange(array, arrayOffset + byteBuffer.position(), arrayOffset + byteBuffer.limit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Integer, ByteBuffer> _getV2ExtroInfo(File apkFile) {
        Map<Integer, ByteBuffer> idValues = null;
        try {
            RandomAccessFile randomAccessFile = null;
            AbstractInterruptibleChannel fileChannel = null;
            try {
                randomAccessFile = new RandomAccessFile(apkFile, "r");
                fileChannel = randomAccessFile.getChannel();
                ByteBuffer apkSigningBlock2 = ApkUtil.findApkSigningBlock((FileChannel)fileChannel).getFirst();
                idValues = ApkUtil.findIdValues(apkSigningBlock2);
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    if (fileChannel != null) {
                        fileChannel.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (randomAccessFile != null) {
                        randomAccessFile.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        catch (SignatureNotFoundException signatureNotFoundException) {
            // empty catch block
        }
        return idValues;
    }

    private static String parseRes(String res, String key) {
        try {
            JSONObject json = new JSONObject(res);
            if (json.has(key)) {
                return json.getString(key);
            }
            return null;
        }
        catch (JSONException e) {
            return null;
        }
    }

    private static String parseRes(String res) {
        return res;
    }
}

