package com.tn.lib.logger.conf

import com.elvishew.xlog.printer.file.naming.FileNameGenerator
import java.text.SimpleDateFormat
import java.util.*

class CusDateFileNameGenerator : FileNameGenerator {
    private var mLocalDateFormat: ThreadLocal<SimpleDateFormat?> =
        object : ThreadLocal<SimpleDateFormat?>() {
            override fun initialValue(): SimpleDateFormat {
                return SimpleDateFormat("yyyy-MM-dd", Locale.US)
            }
        }

    override fun isFileNameChangeable(): Boolean {
        return true
    }

    override fun generateFileName(logLevel: Int, timestamp: Long): String {
        val sdf: SimpleDateFormat? = mLocalDateFormat.get()
        sdf?.timeZone = TimeZone.getDefault()
        return if (sdf == null) UUID.randomUUID()
            .toString() + ".log" else sdf.format(Date(timestamp)) + ".log"
    }
}