package com.tn.lib.thread

import java.util.concurrent.ExecutorService
import java.util.concurrent.Executors

/**
 * 单线程线程池
 * @property executor ExecutorService?
 */
class ThreadSingleExecutor {

    companion object {


        @JvmStatic
        val INSTANCE: ThreadSingleExecutor by lazy(mode = LazyThreadSafetyMode.SYNCHRONIZED) {
            ThreadSingleExecutor()
        }


    }

    private var executor: ExecutorService? = null


    constructor() {
        executor = Executors.newSingleThreadExecutor(DefaultThreadFactory("oneroom_single"));
    }

    fun execute(runnable: Runnable) {
        executor?.submit(runnable)
    }


}