package com.tn.lib.thread.config

import android.text.TextUtils
import com.tn.lib.thread.ThreadEngine
import com.tn.lib.thread.callback.RunnableCallback
import java.util.concurrent.Executor
import java.util.concurrent.ExecutorService

/**
 * 构建者生成ThreadEngine
 * @author: huangyeling
 * @date: 2021/7/30
 */
class Builder(threadPoolSize: Int, threadPoolType: Int, thradPool: ExecutorService?) {

    /**
     * 配置线程数量
     */
    var threadPoolSize: Int = 0

    /**
     * 配置线程类型FIXED、CACHEABLE、SINGLE、SCHEDULED
     */
    var threadPoolOptions: Int = 0

    /**
     * 配置线程名称
     */
    var threadName: String = ""

    /**
     * 配置任务回调
     */
    var runnableCallback: RunnableCallback? = null

    /**
     * 配置deliver更新UI，默认RunnableDeliver
     */
    var deliver: Executor? = null

    /**
     * 配置线程池
     */
    var threadPool: ExecutorService? = null

    /**
     * 配置线程优先级
     */
    var threadPriority = Thread.NORM_PRIORITY

    fun setThreadName(name: String): Builder {
        this.threadName = name
        return this
    }

    fun setThreadPriority(priority: Int): Builder {
        this.threadPriority = priority
        return this
    }

    fun setCallback(runnableCallback: RunnableCallback): Builder {
        this.runnableCallback = runnableCallback
        return this
    }

    fun build(): ThreadEngine {
        this.threadPriority = Math.max(Thread.MAX_PRIORITY, threadPriority)
        this.threadPriority = Math.min(Thread.MIN_PRIORITY, threadPriority)
        this.threadPoolSize = Math.max(1, threadPoolSize)
        this.deliver = HandlerDeliver.instance;
        if (TextUtils.isEmpty(threadName)) {
            threadName = when (threadPoolOptions) {
                ThreadEngine.THREAD_FIXED -> "FIXED"
                ThreadEngine.THREAD_CACHEABLE -> "CACHEABLE"
                ThreadEngine.THREAD_SINGLE -> "SINGLE"
                ThreadEngine.THREAD_SCHEDULED -> "SCHEDULED"
                else -> "ThreadEngine"
            }
        }
        return ThreadEngine(
            threadPoolOptions,
            threadPoolSize,
            threadPriority,
            threadName,
            runnableCallback,
            deliver,
            threadPool
        )
    }

    init {
        this.threadPoolSize = Math.max(1, threadPoolSize)
        this.threadPoolOptions = threadPoolType
        this.threadPool = thradPool
    }

}