package com.tn.lib.thread.wrapper

import com.tn.lib.thread.callback.RunnableCallback
import com.tn.lib.thread.config.LocalConfigs
import com.tn.lib.thread.config.ThreadTools
import com.tn.lib.thread.dispatcher.RunnableDispatcher
import java.util.concurrent.Callable

/**
 *
 * @author: huangyeling
 * @date: 2021/7/27
 */
class CallableWrapper<T> : Callable<T> {

    var threadName: String = ""
    var runnableCallback: RunnableCallback
    var proxy: Callable<T>

    constructor(localConfigs: LocalConfigs, prox: Callable<T>){
        this.threadName = localConfigs?.threadName.toString()
        this.proxy = prox
        this.runnableCallback = RunnableDispatcher(localConfigs.runnableCallback, localConfigs.deliver, localConfigs.asyncCallback)
    }

    override fun call(): T? {
        ThreadTools.restThread(Thread.currentThread(), threadName, runnableCallback)
        if(runnableCallback != null){
            runnableCallback.onStart(threadName)
        }

        val t = if(proxy == null) null else proxy.call()
        runnableCallback?.onCompleted(threadName)
        return t
    }
}