/*
 * Decompiled with CFR 0.152.
 */
package com.tn.lib.logger;

import android.app.Application;
import android.os.Environment;
import android.util.Log;
import com.elvishew.xlog.LogConfiguration;
import com.elvishew.xlog.LogItem;
import com.elvishew.xlog.XLog;
import com.elvishew.xlog.flattener.ClassicFlattener;
import com.elvishew.xlog.flattener.Flattener2;
import com.elvishew.xlog.formatter.border.BorderFormatter;
import com.elvishew.xlog.formatter.border.DefaultBorderFormatter;
import com.elvishew.xlog.formatter.message.json.DefaultJsonFormatter;
import com.elvishew.xlog.formatter.message.json.JsonFormatter;
import com.elvishew.xlog.formatter.message.throwable.DefaultThrowableFormatter;
import com.elvishew.xlog.formatter.message.throwable.ThrowableFormatter;
import com.elvishew.xlog.formatter.message.xml.DefaultXmlFormatter;
import com.elvishew.xlog.formatter.message.xml.XmlFormatter;
import com.elvishew.xlog.formatter.stacktrace.DefaultStackTraceFormatter;
import com.elvishew.xlog.formatter.stacktrace.StackTraceFormatter;
import com.elvishew.xlog.formatter.thread.ThreadFormatter;
import com.elvishew.xlog.printer.AndroidPrinter;
import com.elvishew.xlog.printer.Printer;
import com.elvishew.xlog.printer.file.FilePrinter;
import com.elvishew.xlog.printer.file.backup.BackupStrategy;
import com.elvishew.xlog.printer.file.backup.NeverBackupStrategy;
import com.elvishew.xlog.printer.file.clean.CleanStrategy;
import com.elvishew.xlog.printer.file.naming.FileNameGenerator;
import com.tn.lib.logger.LogType;
import com.tn.lib.logger.conf.CusDateFileNameGenerator;
import com.tn.lib.logger.conf.CusThreadFormatter;
import com.tn.lib.logger.conf.FileSizeCleanStrategy;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/tn/lib/logger/LoggerApplication;", "", "()V", "Companion", "lib_release"})
public final class LoggerApplication {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String LOGGER_ABLE = "oneroom_logger";
    @Nullable
    private static Application application;
    private static boolean isDebug;
    @NotNull
    private static LogType logType;

    static {
        logType = LogType.TYPE_LOGCAT;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0006\u0010\u0010\u001a\u00020\u000eJ\u0006\u0010\u0011\u001a\u00020\fJ2\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u0014\u001a\u00020\u00042\b\b\u0002\u0010\u0015\u001a\u00020\u0016J \u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\u0019\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/tn/lib/logger/LoggerApplication$Companion;", "", "()V", "LOGGER_ABLE", "", "application", "Landroid/app/Application;", "getApplication", "()Landroid/app/Application;", "setApplication", "(Landroid/app/Application;)V", "isDebug", "", "logType", "Lcom/tn/lib/logger/LogType;", "getDefaultLogPath", "getLogType", "iSDebug", "initLog", "", "loggerPath", "autoCleanTime", "", "initLogCat", "initXLog", "isExternalStorageWritable", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Application getApplication() {
            return application;
        }

        public final void setApplication(@Nullable Application application) {
            LoggerApplication.application = application;
        }

        public final boolean iSDebug() {
            return isDebug;
        }

        @NotNull
        public final LogType getLogType() {
            return logType;
        }

        @NotNull
        public final String getDefaultLogPath(@Nullable Application application) {
            String string;
            if (application == null) {
                throw new RuntimeException("\u65e5\u5fd7\u5e93\u4f20\u5165Application\u4e3a\u7a7a");
            }
            if (this.isExternalStorageWritable()) {
                File file = application.getExternalFilesDir(null);
                string = (file != null ? file.getParent() : null) + File.separator + "log";
            } else {
                File file = application.getFilesDir();
                string = (file != null ? file.getParent() : null) + File.separator + "log";
            }
            return string;
        }

        private final boolean isExternalStorageWritable() {
            return Intrinsics.areEqual((Object)Environment.getExternalStorageState(), (Object)"mounted");
        }

        public final void initLog(@NotNull Application application, @NotNull LogType logType, boolean isDebug, @NotNull String loggerPath, long autoCleanTime) {
            Intrinsics.checkNotNullParameter((Object)application, (String)"application");
            Intrinsics.checkNotNullParameter((Object)((Object)logType), (String)"logType");
            Intrinsics.checkNotNullParameter((Object)loggerPath, (String)"loggerPath");
            if (Companion.getApplication() != null) {
                return;
            }
            LoggerApplication.logType = logType;
            isDebug = isDebug || Log.isLoggable((String)LoggerApplication.LOGGER_ABLE, (int)3);
            Companion.setApplication(application);
            switch (WhenMappings.$EnumSwitchMapping$0[logType.ordinal()]) {
                case 1: {
                    this.initLogCat(loggerPath, autoCleanTime, isDebug);
                    break;
                }
                case 2: {
                    this.initXLog(loggerPath, autoCleanTime, isDebug);
                }
            }
        }

        public static /* synthetic */ void initLog$default(Companion companion, Application application, LogType logType, boolean bl, String string, long l, int n, Object object) {
            if ((n & 8) != 0) {
                string = "";
            }
            if ((n & 0x10) != 0) {
                l = 0L;
            }
            companion.initLog(application, logType, bl, string, l);
        }

        private final void initLogCat(String loggerPath, long autoCleanTime, boolean isDebug) {
            this.initXLog(loggerPath, autoCleanTime, isDebug);
        }

        private final void initXLog(String loggerPath, long autoCleanTime, boolean isDebug) {
            long realCleanTime = 259200000L;
            if (autoCleanTime > 0L) {
                realCleanTime = autoCleanTime;
            }
            String realLoggerPath = this.getDefaultLogPath(this.getApplication());
            if (((CharSequence)loggerPath).length() > 0) {
                realLoggerPath = loggerPath;
            }
            LogConfiguration config = new LogConfiguration.Builder().logLevel(Integer.MIN_VALUE).tag("X-LOG").jsonFormatter((JsonFormatter)new DefaultJsonFormatter()).xmlFormatter((XmlFormatter)new DefaultXmlFormatter()).throwableFormatter((ThrowableFormatter)new DefaultThrowableFormatter()).threadFormatter((ThreadFormatter)new CusThreadFormatter()).stackTraceFormatter((StackTraceFormatter)new DefaultStackTraceFormatter()).borderFormatter((BorderFormatter)new DefaultBorderFormatter()).addInterceptor(Companion::initXLog$lambda$0).build();
            AndroidPrinter androidPrinter = new AndroidPrinter();
            FilePrinter filePrinter = null;
            if (((CharSequence)realLoggerPath).length() > 0) {
                filePrinter = new FilePrinter.Builder(realLoggerPath).fileNameGenerator((FileNameGenerator)new CusDateFileNameGenerator()).backupStrategy((BackupStrategy)new NeverBackupStrategy()).cleanStrategy((CleanStrategy)new FileSizeCleanStrategy()).flattener((Flattener2)new ClassicFlattener()).build();
            }
            if (isDebug) {
                if (filePrinter == null) {
                    Printer[] printerArray = new Printer[]{(Printer)androidPrinter};
                    XLog.init((LogConfiguration)config, (Printer[])printerArray);
                } else {
                    Printer[] printerArray = new Printer[]{(Printer)androidPrinter, (Printer)filePrinter};
                    XLog.init((LogConfiguration)config, (Printer[])printerArray);
                }
            } else if (filePrinter == null) {
                XLog.init((LogConfiguration)config);
            } else {
                Printer[] printerArray = new Printer[]{(Printer)filePrinter};
                XLog.init((LogConfiguration)config, (Printer[])printerArray);
            }
        }

        private static final LogItem initXLog$lambda$0(LogItem it) {
            return it;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[LogType.values().length];
                try {
                    nArray[LogType.TYPE_LOGCAT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LogType.TYPE_XLOG.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

