/*
 * Decompiled with CFR 0.152.
 */
package com.tn.lib.thread;

import com.tn.lib.thread.callback.AsyncCallback;
import com.tn.lib.thread.callback.RunnableCallback;
import com.tn.lib.thread.config.Builder;
import com.tn.lib.thread.config.LocalConfigs;
import com.tn.lib.thread.dispatcher.DelayDispatcher;
import com.tn.lib.thread.wrapper.CallableWrapper;
import com.tn.lib.thread.wrapper.RunnableWrapper;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 .2\u00020\u0001:\u0002./BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0001\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\"\u0010\u0014\u001a\u00020\u0015\"\u0004\b\u0000\u0010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ \u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0002J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0006\u0010!\u001a\u00020\u0015J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u0007J\u0006\u0010*\u001a\u00020\u0015J\u0006\u0010+\u001a\u00020\u0015J \u0010,\u001a\b\u0012\u0004\u0012\u0002H\u00160-\"\u0004\b\u0000\u0010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0018R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/tn/lib/thread/ThreadEngine;", "Ljava/util/concurrent/Executor;", "threadOption", "", "threadSize", "priority", "threadName", "", "runnableCallback", "Lcom/tn/lib/thread/callback/RunnableCallback;", "deliver", "threadPool", "Ljava/util/concurrent/ExecutorService;", "(IIILjava/lang/String;Lcom/tn/lib/thread/callback/RunnableCallback;Ljava/util/concurrent/Executor;Ljava/util/concurrent/ExecutorService;)V", "local", "Ljava/lang/ThreadLocal;", "Lcom/tn/lib/thread/config/LocalConfigs;", "localLocalConfigs", "getLocalLocalConfigs", "()Lcom/tn/lib/thread/config/LocalConfigs;", "async", "", "T", "callable", "Ljava/util/concurrent/Callable;", "callback", "Lcom/tn/lib/thread/callback/AsyncCallback;", "createPool", "type", "size", "execute", "command", "Ljava/lang/Runnable;", "resetLocalConfigs", "setCallBack", "setDelay", "time", "", "unit", "Ljava/util/concurrent/TimeUnit;", "setThreadName", "name", "shutDown", "shutDownNow", "submit", "Ljava/util/concurrent/Future;", "Companion", "DefaultFactory", "lib_release"})
public final class ThreadEngine
implements Executor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ExecutorService threadPool;
    @NotNull
    private String threadName;
    @Nullable
    private RunnableCallback runnableCallback;
    @Nullable
    private Executor deliver;
    @Nullable
    private ThreadLocal<LocalConfigs> local;
    public static final int THREAD_FIXED = 1;
    public static final int THREAD_CACHEABLE = 2;
    public static final int THREAD_SCHEDULED = 3;
    public static final int THREAD_SINGLE = 4;

    public ThreadEngine(int threadOption, int threadSize, int priority, @NotNull String threadName, @Nullable RunnableCallback runnableCallback, @Nullable Executor deliver, @Nullable ExecutorService threadPool) {
        Intrinsics.checkNotNullParameter((Object)threadName, (String)"threadName");
        this.threadName = threadName;
        this.runnableCallback = runnableCallback;
        this.deliver = deliver;
        ExecutorService pool = threadPool;
        if (pool == null) {
            pool = this.createPool(threadOption, threadSize, priority);
        }
        this.threadPool = pool;
        this.threadName = threadName;
        this.runnableCallback = runnableCallback;
        this.deliver = deliver;
        this.local = new ThreadLocal();
    }

    private final LocalConfigs getLocalLocalConfigs() {
        LocalConfigs localConfigs;
        block1: {
            ThreadLocal<LocalConfigs> threadLocal = this.local;
            LocalConfigs localConfigs2 = localConfigs = threadLocal != null ? threadLocal.get() : null;
            if (localConfigs != null) break block1;
            localConfigs = new LocalConfigs();
            localConfigs.setThreadName(this.threadName);
            localConfigs.setRunnableCallback(this.runnableCallback);
            localConfigs.setDeliver(this.deliver);
            ThreadLocal<LocalConfigs> threadLocal2 = this.local;
            if (threadLocal2 != null) {
                threadLocal2.set(localConfigs);
            }
        }
        return localConfigs;
    }

    @Override
    public void execute(@NotNull Runnable command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Runnable runnable = command;
        LocalConfigs config = this.getLocalLocalConfigs();
        runnable = new RunnableWrapper(config).setRunnable(runnable);
        DelayDispatcher.Companion.getInstance().postDelay(config.getDelay(), this.threadPool, runnable);
        this.resetLocalConfigs();
    }

    public final <T> void async(@NotNull Callable<T> callable, @NotNull AsyncCallback callback) {
        Intrinsics.checkNotNullParameter(callable, (String)"callable");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        LocalConfigs localConfigs = this.getLocalLocalConfigs();
        localConfigs.setAsyncCallback(callback);
        Runnable runnable = new RunnableWrapper(localConfigs).setCallable(callable);
        DelayDispatcher.Companion.getInstance().postDelay(localConfigs.getDelay(), this.threadPool, runnable);
    }

    @NotNull
    public final <T> Future<T> submit(@NotNull Callable<T> callable) {
        Intrinsics.checkNotNullParameter(callable, (String)"callable");
        Future result = null;
        CallableWrapper<T> callable2 = new CallableWrapper<T>(this.getLocalLocalConfigs(), callable);
        Future future = this.threadPool.submit(callable2);
        Intrinsics.checkNotNullExpressionValue(future, (String)"threadPool.submit(callable)");
        result = future;
        this.resetLocalConfigs();
        return result;
    }

    @NotNull
    public final ThreadEngine setThreadName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.getLocalLocalConfigs().setThreadName(name);
        return this;
    }

    @NotNull
    public final ThreadEngine setCallBack(@NotNull RunnableCallback runnableCallback) {
        Intrinsics.checkNotNullParameter((Object)runnableCallback, (String)"runnableCallback");
        this.getLocalLocalConfigs().setRunnableCallback(runnableCallback);
        return this;
    }

    @NotNull
    public final ThreadEngine setDelay(long time, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        long delay = unit.toMillis(time);
        this.getLocalLocalConfigs().setDelay(Math.max(0L, delay));
        return this;
    }

    public final void shutDown() {
        this.threadPool.shutdown();
    }

    public final void shutDownNow() {
        this.threadPool.shutdownNow();
    }

    public final void resetLocalConfigs() {
        block0: {
            ThreadLocal<LocalConfigs> threadLocal = this.local;
            if (threadLocal == null) break block0;
            threadLocal.set(null);
        }
    }

    private final ExecutorService createPool(int type, int size, int priority) {
        ExecutorService executorService;
        switch (type) {
            case 2: {
                ExecutorService executorService2 = Executors.newCachedThreadPool(new DefaultFactory(priority));
                executorService = executorService2;
                Intrinsics.checkNotNullExpressionValue((Object)executorService2, (String)"newCachedThreadPool(\n   \u2026y(priority)\n            )");
                break;
            }
            case 1: {
                ExecutorService executorService3 = Executors.newFixedThreadPool(size, new DefaultFactory(priority));
                executorService = executorService3;
                Intrinsics.checkNotNullExpressionValue((Object)executorService3, (String)"newFixedThreadPool(\n    \u2026y(priority)\n            )");
                break;
            }
            case 3: {
                ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(size, new DefaultFactory(priority));
                Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"newScheduledThreadPool(\n\u2026y(priority)\n            )");
                executorService = scheduledExecutorService;
                break;
            }
            case 4: {
                ExecutorService executorService4 = Executors.newSingleThreadExecutor(new DefaultFactory(priority));
                executorService = executorService4;
                Intrinsics.checkNotNullExpressionValue((Object)executorService4, (String)"newSingleThreadExecutor(\u2026y(priority)\n            )");
                break;
            }
            default: {
                ExecutorService executorService5 = Executors.newSingleThreadExecutor(new DefaultFactory(priority));
                executorService = executorService5;
                Intrinsics.checkNotNullExpressionValue((Object)executorService5, (String)"newSingleThreadExecutor(\u2026          )\n            )");
            }
        }
        return executorService;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\tJ\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0004J\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0004J\u0006\u0010\u0010\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/tn/lib/thread/ThreadEngine$Companion;", "", "()V", "THREAD_CACHEABLE", "", "THREAD_FIXED", "THREAD_SCHEDULED", "THREAD_SINGLE", "create", "Lcom/tn/lib/thread/config/Builder;", "pool", "Ljava/util/concurrent/ExecutorService;", "createCacheable", "createFixed", "size", "createScheduled", "createSingle", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Builder create(@NotNull ExecutorService pool) {
            Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
            return new Builder(1, 4, pool);
        }

        @NotNull
        public final Builder createCacheable() {
            return new Builder(0, 2, null);
        }

        @NotNull
        public final Builder createFixed(int size) {
            return new Builder(size, 1, null);
        }

        @NotNull
        public final Builder createScheduled(int size) {
            return new Builder(size, 3, null);
        }

        @NotNull
        public final Builder createSingle() {
            return new Builder(0, 4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/tn/lib/thread/ThreadEngine$DefaultFactory;", "Ljava/util/concurrent/ThreadFactory;", "priority", "", "(I)V", "newThread", "Ljava/lang/Thread;", "runnable", "Ljava/lang/Runnable;", "lib_release"})
    private static final class DefaultFactory
    implements ThreadFactory {
        private final int priority;

        public DefaultFactory(int priority) {
            this.priority = priority;
        }

        @Override
        @NotNull
        public Thread newThread(@NotNull Runnable runnable) {
            Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
            Thread thread = new Thread(runnable);
            thread.setPriority(this.priority);
            return thread;
        }
    }
}

