/*
 * Decompiled with CFR 0.152.
 */
package com.tn.lib.thread.config;

import android.text.TextUtils;
import com.tn.lib.thread.ThreadEngine;
import com.tn.lib.thread.callback.RunnableCallback;
import com.tn.lib.thread.config.HandlerDeliver;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010)\u001a\u00020*J\u000e\u0010+\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0015J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u0003R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010!\"\u0004\b%\u0010#R\u001a\u0010&\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010!\"\u0004\b(\u0010#\u00a8\u0006."}, d2={"Lcom/tn/lib/thread/config/Builder;", "", "threadPoolSize", "", "threadPoolType", "thradPool", "Ljava/util/concurrent/ExecutorService;", "(IILjava/util/concurrent/ExecutorService;)V", "deliver", "Ljava/util/concurrent/Executor;", "getDeliver", "()Ljava/util/concurrent/Executor;", "setDeliver", "(Ljava/util/concurrent/Executor;)V", "runnableCallback", "Lcom/tn/lib/thread/callback/RunnableCallback;", "getRunnableCallback", "()Lcom/tn/lib/thread/callback/RunnableCallback;", "setRunnableCallback", "(Lcom/tn/lib/thread/callback/RunnableCallback;)V", "threadName", "", "getThreadName", "()Ljava/lang/String;", "setThreadName", "(Ljava/lang/String;)V", "threadPool", "getThreadPool", "()Ljava/util/concurrent/ExecutorService;", "setThreadPool", "(Ljava/util/concurrent/ExecutorService;)V", "threadPoolOptions", "getThreadPoolOptions", "()I", "setThreadPoolOptions", "(I)V", "getThreadPoolSize", "setThreadPoolSize", "threadPriority", "getThreadPriority", "setThreadPriority", "build", "Lcom/tn/lib/thread/ThreadEngine;", "setCallback", "name", "priority", "lib_release"})
public final class Builder {
    private int threadPoolSize;
    private int threadPoolOptions;
    @NotNull
    private String threadName = "";
    @Nullable
    private RunnableCallback runnableCallback;
    @Nullable
    private Executor deliver;
    @Nullable
    private ExecutorService threadPool;
    private int threadPriority = 5;

    public Builder(int threadPoolSize, int threadPoolType, @Nullable ExecutorService thradPool) {
        this.threadPoolSize = Math.max(1, threadPoolSize);
        this.threadPoolOptions = threadPoolType;
        this.threadPool = thradPool;
    }

    public final int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public final void setThreadPoolSize(int n) {
        this.threadPoolSize = n;
    }

    public final int getThreadPoolOptions() {
        return this.threadPoolOptions;
    }

    public final void setThreadPoolOptions(int n) {
        this.threadPoolOptions = n;
    }

    @NotNull
    public final String getThreadName() {
        return this.threadName;
    }

    public final void setThreadName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.threadName = string;
    }

    @Nullable
    public final RunnableCallback getRunnableCallback() {
        return this.runnableCallback;
    }

    public final void setRunnableCallback(@Nullable RunnableCallback runnableCallback) {
        this.runnableCallback = runnableCallback;
    }

    @Nullable
    public final Executor getDeliver() {
        return this.deliver;
    }

    public final void setDeliver(@Nullable Executor executor) {
        this.deliver = executor;
    }

    @Nullable
    public final ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public final void setThreadPool(@Nullable ExecutorService executorService) {
        this.threadPool = executorService;
    }

    public final int getThreadPriority() {
        return this.threadPriority;
    }

    public final void setThreadPriority(int n) {
        this.threadPriority = n;
    }

    @NotNull
    public final Builder setThreadName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.threadName = name;
        return this;
    }

    @NotNull
    public final Builder setThreadPriority(int priority) {
        this.threadPriority = priority;
        return this;
    }

    @NotNull
    public final Builder setCallback(@NotNull RunnableCallback runnableCallback) {
        Intrinsics.checkNotNullParameter((Object)runnableCallback, (String)"runnableCallback");
        this.runnableCallback = runnableCallback;
        return this;
    }

    @NotNull
    public final ThreadEngine build() {
        this.threadPriority = Math.max(10, this.threadPriority);
        this.threadPriority = Math.min(1, this.threadPriority);
        this.threadPoolSize = Math.max(1, this.threadPoolSize);
        this.deliver = HandlerDeliver.Companion.getInstance();
        if (TextUtils.isEmpty((CharSequence)this.threadName)) {
            this.threadName = switch (this.threadPoolOptions) {
                case 1 -> "FIXED";
                case 2 -> "CACHEABLE";
                case 4 -> "SINGLE";
                case 3 -> "SCHEDULED";
                default -> "ThreadEngine";
            };
        }
        return new ThreadEngine(this.threadPoolOptions, this.threadPoolSize, this.threadPriority, this.threadName, this.runnableCallback, this.deliver, this.threadPool);
    }
}

