/*
 * Decompiled with CFR 0.152.
 */
package com.tn.lib.util.networkinfo;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkRequest;
import android.os.Build;
import android.os.Handler;
import android.telephony.TelephonyManager;
import androidx.core.content.ContextCompat;
import com.blankj.utilcode.util.Utils;
import com.tn.lib.logger.Logger;
import com.tn.lib.util.networkinfo.NetWorkCallback;
import com.tn.lib.util.networkinfo.NetworkType;
import com.tn.lib.util.networkinfo.NetworkUtil;
import com.tn.lib.util.networkinfo.OnNetworkStatusChangedListener;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 12\u00020\u0001:\u00011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0016\u001a\u00020\tH\u0002J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001c\u001a\u00020\u000eH\u0003J\b\u0010\u001d\u001a\u0004\u0018\u00010\u000eJ\u0006\u0010\u0003\u001a\u00020\u0004J\b\u0010\u0006\u001a\u00020\u0004H\u0002J\u0014\u0010\u001e\u001a\u0004\u0018\u00010\u00192\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u0010\u0010\u001f\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010 \u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u0004H\u0016J\u0018\u0010\"\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010#\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010$\u001a\u00020%H\u0016J\u0018\u0010&\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\u001bH\u0016J\u0010\u0010(\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010)\u001a\u00020\tH\u0016J\u0006\u0010*\u001a\u00020\tJ\u0010\u0010+\u001a\u00020\t2\b\u0010,\u001a\u0004\u0018\u00010\fJ\b\u0010-\u001a\u00020\tH\u0002J\b\u0010.\u001a\u00020\tH\u0002J\u0006\u0010/\u001a\u00020\tJ\u0010\u00100\u001a\u00020\t2\b\u0010,\u001a\u0004\u0018\u00010\fR\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/tn/lib/util/networkinfo/NetWorkCallback;", "Landroid/net/ConnectivityManager$NetworkCallback;", "()V", "isConnected", "", "Ljava/lang/Boolean;", "isValidated", "lostRunnable", "Lkotlin/Function0;", "", "mListeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/tn/lib/util/networkinfo/OnNetworkStatusChangedListener;", "mNetworkType", "Lcom/tn/lib/util/networkinfo/NetworkType;", "timerRunnable", "disposeConnect", "network", "Landroid/net/Network;", "networkCapabilities", "Landroid/net/NetworkCapabilities;", "disposeNetType", "disposeOnLost", "disposeValidated", "getClassTag", "", "getNetState", "", "getNetTypeMobile", "getNetworkType", "logNetWorkType", "onAvailable", "onBlockedStatusChanged", "blocked", "onCapabilitiesChanged", "onLinkPropertiesChanged", "linkProperties", "Landroid/net/LinkProperties;", "onLosing", "maxMsToLive", "onLost", "onUnavailable", "registerNetworkCallback", "registerNetworkStatusChangedListener", "listener", "reset", "startTimer", "unregisterNetworkCallback", "unregisterNetworkStatusChangedListener", "Companion", "lib_release"})
@SourceDebugExtension(value={"SMAP\nNetWorkCallback.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetWorkCallback.kt\ncom/tn/lib/util/networkinfo/NetWorkCallback\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,525:1\n1855#2,2:526\n*S KotlinDebug\n*F\n+ 1 NetWorkCallback.kt\ncom/tn/lib/util/networkinfo/NetWorkCallback\n*L\n375#1:526,2\n*E\n"})
public final class NetWorkCallback
extends ConnectivityManager.NetworkCallback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CopyOnWriteArrayList<OnNetworkStatusChangedListener> mListeners = new CopyOnWriteArrayList();
    @Nullable
    private volatile Boolean isConnected;
    @Nullable
    private volatile Boolean isValidated;
    @Nullable
    private NetworkType mNetworkType;
    @NotNull
    private final Function0<Unit> lostRunnable = (Function0)new Function0<Unit>(this){
        final /* synthetic */ NetWorkCallback this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        /*
         * WARNING - void declaration
         */
        public final void invoke() {
            Application application = Utils.getApp();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApp()");
            boolean networkConnected = NetworkUtil.INSTANCE.isNetworkConnected((Context)application);
            Application application2 = Utils.getApp();
            Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"getApp()");
            NetWorkCallback.access$setValidated$p(this.this$0, NetworkUtil.INSTANCE.isNetworkCapability((Context)application2));
            int netState = this.this$0.getNetState();
            if (networkConnected) {
                void $this$forEach$iv;
                NetWorkCallback.access$setConnected$p(this.this$0, true);
                Object object = new String[]{NetWorkCallback.access$getClassTag(this.this$0) + " --> onLost() --> disposeOnLost --> lostRunnable --> networkConnected = " + networkConnected + " netState = " + netState + " --  \u7f51\u7edc\u91cd\u65b0\u8fde\u63a5\u4e86"};
                Logger.Companion.i("net_log", (String[])object, true);
                object = NetWorkCallback.access$getMListeners$p(this.this$0);
                NetWorkCallback netWorkCallback = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    OnNetworkStatusChangedListener it = (OnNetworkStatusChangedListener)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)NetWorkCallback.access$isConnected$p(netWorkCallback), (Object)true)) continue;
                    it.onConnected();
                }
            } else {
                NetWorkCallback.access$reset(this.this$0);
                Object $this$forEach$iv = new String[]{NetWorkCallback.access$getClassTag(this.this$0) + " --> onLost() --> disposeOnLost --> lostRunnable --> networkConnected = " + networkConnected + " netState = " + netState + " -- \u7f51\u7edc\u65ad\u5f00\u4e86 "};
                Logger.Companion.i("net_log", (String[])$this$forEach$iv, true);
                $this$forEach$iv = NetWorkCallback.access$getMListeners$p(this.this$0);
                NetWorkCallback netWorkCallback = this.this$0;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    T element$iv = iterator.next();
                    OnNetworkStatusChangedListener it = (OnNetworkStatusChangedListener)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)NetWorkCallback.access$isConnected$p(netWorkCallback), (Object)false)) continue;
                    it.onDisconnected();
                }
            }
        }
    };
    @NotNull
    private final Function0<Unit> timerRunnable = (Function0)new Function0<Unit>(this){
        final /* synthetic */ NetWorkCallback this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        public final void invoke() {
            Application application = Utils.getApp();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApp()");
            NetWorkCallback.access$setValidated$p(this.this$0, NetworkUtil.INSTANCE.isNetworkCapability((Context)application));
            String[] stringArray = new String[]{NetWorkCallback.access$getClassTag(this.this$0) + " --> timerRunnable --> isValidated = " + NetWorkCallback.access$isValidated$p(this.this$0)};
            Logger.Companion.i$default(Logger.Companion, "net_log", stringArray, false, 4, null);
            NetWorkCallback.access$startTimer(this.this$0);
        }
    };
    @NotNull
    private static final String TAG = "net_log";
    @NotNull
    private static final Lazy<Handler> mHandler$delegate = LazyKt.lazy((Function0)Companion.mHandler.2.INSTANCE);
    @NotNull
    private static final Lazy<NetWorkCallback> INSTANCE$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)Companion.INSTANCE.2.INSTANCE);

    private final String getClassTag() {
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        return string;
    }

    public final void registerNetworkCallback() {
        ConnectivityManager connMgr;
        Application application = Utils.getApp();
        Object object = application != null && (application = application.getApplicationContext()) != null ? application.getSystemService("connectivity") : null;
        ConnectivityManager connectivityManager = connMgr = object instanceof ConnectivityManager ? (ConnectivityManager)object : null;
        if (connectivityManager != null) {
            connectivityManager.registerNetworkCallback(new NetworkRequest.Builder().build(), (ConnectivityManager.NetworkCallback)this);
        }
        this.startTimer();
    }

    public final void unregisterNetworkCallback() {
        ConnectivityManager connMgr;
        Application application = Utils.getApp();
        Object object = application != null && (application = application.getApplicationContext()) != null ? application.getSystemService("connectivity") : null;
        ConnectivityManager connectivityManager = connMgr = object instanceof ConnectivityManager ? (ConnectivityManager)object : null;
        if (connectivityManager != null) {
            connectivityManager.unregisterNetworkCallback((ConnectivityManager.NetworkCallback)this);
        }
        this.reset();
        this.mListeners.clear();
        Companion.getMHandler().removeCallbacksAndMessages(null);
    }

    public final void registerNetworkStatusChangedListener(@Nullable OnNetworkStatusChangedListener listener) {
        block1: {
            OnNetworkStatusChangedListener onNetworkStatusChangedListener = listener;
            if (onNetworkStatusChangedListener == null) break block1;
            OnNetworkStatusChangedListener it = onNetworkStatusChangedListener;
            boolean bl = false;
            if (!this.mListeners.contains(listener)) {
                this.mListeners.add(it);
            }
        }
    }

    public final void unregisterNetworkStatusChangedListener(@Nullable OnNetworkStatusChangedListener listener) {
        block0: {
            OnNetworkStatusChangedListener onNetworkStatusChangedListener = listener;
            if (onNetworkStatusChangedListener == null) break block0;
            OnNetworkStatusChangedListener it = onNetworkStatusChangedListener;
            boolean bl = false;
            this.mListeners.remove(it);
        }
    }

    public final int getNetState() {
        return this.isConnected() && this.isValidated() ? 2 : (this.isConnected() ? 1 : (!this.isConnected() ? 0 : 3));
    }

    public final boolean isConnected() {
        if (this.isConnected != null) {
            if (Intrinsics.areEqual((Object)this.isConnected, (Object)false)) {
                Application application = Utils.getApp();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApp()");
                return NetworkUtil.INSTANCE.isNetworkConnected((Context)application);
            }
            return Intrinsics.areEqual((Object)this.isConnected, (Object)true);
        }
        Application application = Utils.getApp();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApp()");
        return NetworkUtil.INSTANCE.isNetworkConnected((Context)application);
    }

    private final boolean isValidated() {
        if (this.isValidated != null) {
            return Intrinsics.areEqual((Object)this.isValidated, (Object)true);
        }
        Application application = Utils.getApp();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApp()");
        return NetworkUtil.INSTANCE.isNetworkCapability((Context)application);
    }

    @Nullable
    public final NetworkType getNetworkType() {
        if (this.mNetworkType != null) {
            return this.mNetworkType;
        }
        Application application = Utils.getApp();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApp()");
        if (NetworkUtil.INSTANCE.isWifiConnected((Context)application)) {
            this.mNetworkType = NetworkType.NETWORK_WIFI;
            return this.mNetworkType;
        }
        this.mNetworkType = this.getNetTypeMobile();
        return this.mNetworkType;
    }

    public void onLost(@NotNull Network network) {
        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
        super.onLost(network);
        this.disposeOnLost();
    }

    public void onCapabilitiesChanged(@NotNull Network network, @NotNull NetworkCapabilities networkCapabilities) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
        Intrinsics.checkNotNullParameter((Object)networkCapabilities, (String)"networkCapabilities");
        super.onCapabilitiesChanged(network, networkCapabilities);
        try {
            boolean bl = false;
            this.disposeConnect(network, networkCapabilities);
            this.disposeValidated(networkCapabilities);
            this.disposeNetType(networkCapabilities);
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            Logger.Companion.e$default(Logger.Companion, TAG, this.getClassTag() + " --> it = " + it, false, 4, null);
        }
    }

    public void onAvailable(@NotNull Network network) {
        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
        super.onAvailable(network);
    }

    public void onLinkPropertiesChanged(@NotNull Network network, @NotNull LinkProperties linkProperties) {
        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
        Intrinsics.checkNotNullParameter((Object)linkProperties, (String)"linkProperties");
        super.onLinkPropertiesChanged(network, linkProperties);
    }

    public void onBlockedStatusChanged(@NotNull Network network, boolean blocked) {
        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
        super.onBlockedStatusChanged(network, blocked);
    }

    public void onLosing(@NotNull Network network, int maxMsToLive) {
        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
        super.onLosing(network, maxMsToLive);
    }

    public void onUnavailable() {
        super.onUnavailable();
    }

    private final void reset() {
        this.isConnected = false;
        this.isValidated = false;
        this.mNetworkType = null;
    }

    private final void disposeOnLost() {
        Companion.getMHandler().removeCallbacks(() -> NetWorkCallback.disposeOnLost$lambda$4(this.lostRunnable));
        Companion.getMHandler().postDelayed(() -> NetWorkCallback.disposeOnLost$lambda$5(this.lostRunnable), 1000L);
    }

    private final void disposeConnect(Network network, NetworkCapabilities networkCapabilities) {
        if (networkCapabilities.hasCapability(12)) {
            if (Intrinsics.areEqual((Object)this.isConnected, (Object)true)) {
                return;
            }
            this.isConnected = true;
            String[] stringArray = new String[]{this.getClassTag() + " --> onCapabilitiesChanged --> disposeConnect --> \u8868\u793a\u662f\u5426\u8fde\u63a5\u4e0a\u4e86\u4e92\u8054\u7f51\uff08\u4e0d\u5173\u5fc3\u662f\u5426\u53ef\u4ee5\u4e0a\u7f51"};
            Logger.Companion.i(TAG, stringArray, true);
            Companion.getMHandler().post(() -> NetWorkCallback.disposeConnect$lambda$7(this, network, networkCapabilities));
        }
    }

    private final void disposeValidated(NetworkCapabilities networkCapabilities) {
        this.isValidated = Build.VERSION.SDK_INT >= 23 ? Boolean.valueOf(networkCapabilities.hasCapability(16)) : Boolean.valueOf(true);
        String[] stringArray = new String[]{this.getClassTag() + " --> disposeValidated() --> isValidated = " + this.isValidated + " netState = " + this.getNetState()};
        Logger.Companion.i(TAG, stringArray, true);
    }

    private final void disposeNetType(NetworkCapabilities networkCapabilities) {
        NetworkType networkType;
        NetworkType networkType2 = networkCapabilities.hasTransport(1) ? NetworkType.NETWORK_WIFI : (networkType = networkCapabilities.hasTransport(0) ? this.getNetTypeMobile() : NetworkType.NETWORK_UNKNOWN);
        if (this.mNetworkType == networkType) {
            return;
        }
        this.mNetworkType = networkType;
        String[] stringArray = new String[]{"\u5f53\u524d\u7f51\u7edc\u7c7b\u578b\u662f mNetworkType = " + this.mNetworkType};
        Logger.Companion.i(TAG, stringArray, true);
    }

    @SuppressLint(value={"MissingPermission"})
    private final NetworkType getNetTypeMobile() {
        NetworkType type = null;
        if (Build.VERSION.SDK_INT < 24) {
            type = NetworkUtil.INSTANCE.getNetworkType();
        } else if (ContextCompat.checkSelfPermission((Context)((Context)Utils.getApp()), (String)"android.permission.READ_PHONE_STATE") == 0) {
            NetworkType networkType;
            boolean bl;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            Integer n;
            TelephonyManager telephonyManager;
            TelephonyManager telephonyManager2 = telephonyManager = (TelephonyManager)Utils.getApp().getSystemService("phone");
            Integer n2 = n = telephonyManager2 != null ? Integer.valueOf(telephonyManager2.getDataNetworkType()) : null;
            int n3 = 1;
            if (n2 != null && n2 == n3) {
                bl4 = true;
            } else {
                Integer n4 = n;
                n3 = 2;
                bl4 = n4 != null && n4 == n3;
            }
            if (bl4) {
                bl3 = true;
            } else {
                Integer n5 = n;
                n3 = 4;
                bl3 = n5 != null && n5 == n3;
            }
            if (bl3) {
                bl2 = true;
            } else {
                Integer n6 = n;
                n3 = 11;
                bl2 = n6 != null && n6 == n3;
            }
            if (bl2) {
                bl = true;
            } else {
                Integer n7 = n;
                n3 = 7;
                bl = n7 != null && n7 == n3;
            }
            if (bl) {
                networkType = NetworkType.NETWORK_2G;
            } else {
                boolean bl5;
                boolean bl6;
                boolean bl7;
                boolean bl8;
                boolean bl9;
                boolean bl10;
                boolean bl11;
                Integer n8 = n;
                n3 = 5;
                if (n8 != null && n8 == n3) {
                    bl11 = true;
                } else {
                    Integer n9 = n;
                    n3 = 6;
                    bl11 = n9 != null && n9 == n3;
                }
                if (bl11) {
                    bl10 = true;
                } else {
                    Integer n10 = n;
                    n3 = 12;
                    bl10 = n10 != null && n10 == n3;
                }
                if (bl10) {
                    bl9 = true;
                } else {
                    Integer n11 = n;
                    n3 = 8;
                    bl9 = n11 != null && n11 == n3;
                }
                if (bl9) {
                    bl8 = true;
                } else {
                    Integer n12 = n;
                    n3 = 9;
                    bl8 = n12 != null && n12 == n3;
                }
                if (bl8) {
                    bl7 = true;
                } else {
                    Integer n13 = n;
                    n3 = 10;
                    bl7 = n13 != null && n13 == n3;
                }
                if (bl7) {
                    bl6 = true;
                } else {
                    Integer n14 = n;
                    n3 = 15;
                    bl6 = n14 != null && n14 == n3;
                }
                if (bl6) {
                    bl5 = true;
                } else {
                    Integer n15 = n;
                    n3 = 14;
                    bl5 = n15 != null && n15 == n3;
                }
                if (bl5) {
                    networkType = NetworkType.NETWORK_3G;
                } else {
                    boolean bl12;
                    Integer n16 = n;
                    n3 = 13;
                    if (n16 != null && n16 == n3) {
                        bl12 = true;
                    } else {
                        Integer n17 = n;
                        n3 = 19;
                        bl12 = n17 != null && n17 == n3;
                    }
                    if (bl12) {
                        networkType = NetworkType.NETWORK_4G;
                    } else {
                        Integer n18 = n;
                        n3 = 20;
                        if (n18 != null && n18 == n3) {
                            networkType = NetworkType.NETWORK_5G;
                        } else {
                            Integer n19 = n;
                            networkType = n19 != null && n19 == 0 ? NetworkType.NETWORK_UNKNOWN : NetworkType.NETWORK_UNKNOWN;
                        }
                    }
                }
            }
            type = networkType;
        } else {
            type = NetworkUtil.INSTANCE.getNetworkType();
        }
        return type;
    }

    private final void startTimer() {
        String[] stringArray = new String[]{this.getClassTag() + " --> startTimer() --> \u5f00\u542f\u5b9a\u65f6\u4efb\u52a1"};
        Logger.Companion.i$default(Logger.Companion, TAG, stringArray, false, 4, null);
        Companion.getMHandler().postDelayed(() -> NetWorkCallback.startTimer$lambda$8(this.timerRunnable), 120000L);
    }

    private final String logNetWorkType(NetworkCapabilities networkCapabilities) {
        String signalStrength;
        if (networkCapabilities == null) {
            return null;
        }
        String string = signalStrength = Build.VERSION.SDK_INT >= 29 ? " \u4fe1\u53f7\u5f3a\u5ea6 = " + networkCapabilities.getSignalStrength() : " \u5f53\u524d\u7248\u672c\u4e0d\u652f\u6301\u83b7\u53d6";
        if (networkCapabilities.hasTransport(0)) {
            return "\u8868\u793a\u6b64\u7f51\u7edc\u4f7f\u7528\u8702\u7a9d\u4f20\u8f93\u3002 -- " + signalStrength;
        }
        if (networkCapabilities.hasTransport(1)) {
            return "\u8868\u793a\u6b64\u7f51\u7edc\u4f7f\u7528 Wi-Fi \u4f20\u8f93\u3002-- " + signalStrength;
        }
        if (networkCapabilities.hasTransport(2)) {
            return "\u8868\u793a\u6b64\u7f51\u7edc\u4f7f\u7528\u84dd\u7259\u4f20\u8f93\u3002-- " + signalStrength;
        }
        if (networkCapabilities.hasTransport(3)) {
            return "\u8868\u793a\u6b64\u7f51\u7edc\u4f7f\u7528\u4ee5\u592a\u7f51\u4f20\u8f93\u3002-- " + signalStrength;
        }
        if (networkCapabilities.hasTransport(4)) {
            return "\u8868\u793a\u6b64\u7f51\u7edc\u4f7f\u7528 VPN \u4f20\u8f93\u3002-- " + signalStrength;
        }
        if (networkCapabilities.hasTransport(5)) {
            return "\u8868\u793a\u6b64\u7f51\u7edc\u4f7f\u7528 Wi-Fi \u611f\u77e5\u4f20\u8f93\u3002-- " + signalStrength;
        }
        if (networkCapabilities.hasTransport(6)) {
            return "\u8868\u793a\u6b64\u7f51\u7edc\u4f7f\u7528 LoWPAN \u4f20\u8f93\u3002-- " + signalStrength;
        }
        if (networkCapabilities.hasTransport(8)) {
            return "\u8868\u793a\u6b64\u7f51\u7edc\u4f7f\u7528 USB \u4f20\u8f93\u3002-- " + signalStrength;
        }
        return null;
    }

    private static final void disposeOnLost$lambda$4(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }

    private static final void disposeOnLost$lambda$5(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }

    private static final void disposeConnect$lambda$7(NetWorkCallback this$0, Network $network, NetworkCapabilities $networkCapabilities) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$network, (String)"$network");
        Intrinsics.checkNotNullParameter((Object)$networkCapabilities, (String)"$networkCapabilities");
        Iterable $this$forEach$iv = this$0.mListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OnNetworkStatusChangedListener it = (OnNetworkStatusChangedListener)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)this$0.isConnected, (Object)true)) continue;
            it.onConnected($network, $networkCapabilities);
        }
    }

    private static final void startTimer$lambda$8(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }

    public static final /* synthetic */ void access$setValidated$p(NetWorkCallback $this, Boolean bl) {
        $this.isValidated = bl;
    }

    public static final /* synthetic */ void access$setConnected$p(NetWorkCallback $this, Boolean bl) {
        $this.isConnected = bl;
    }

    public static final /* synthetic */ String access$getClassTag(NetWorkCallback $this) {
        return $this.getClassTag();
    }

    public static final /* synthetic */ CopyOnWriteArrayList access$getMListeners$p(NetWorkCallback $this) {
        return $this.mListeners;
    }

    public static final /* synthetic */ void access$reset(NetWorkCallback $this) {
        $this.reset();
    }

    public static final /* synthetic */ Boolean access$isConnected$p(NetWorkCallback $this) {
        return $this.isConnected;
    }

    public static final /* synthetic */ Boolean access$isValidated$p(NetWorkCallback $this) {
        return $this.isValidated;
    }

    public static final /* synthetic */ void access$startTimer(NetWorkCallback $this) {
        $this.startTimer();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\b\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lcom/tn/lib/util/networkinfo/NetWorkCallback$Companion;", "", "()V", "INSTANCE", "Lcom/tn/lib/util/networkinfo/NetWorkCallback;", "getINSTANCE", "()Lcom/tn/lib/util/networkinfo/NetWorkCallback;", "INSTANCE$delegate", "Lkotlin/Lazy;", "TAG", "", "mHandler", "Landroid/os/Handler;", "getMHandler", "()Landroid/os/Handler;", "mHandler$delegate", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Handler getMHandler() {
            Lazy lazy = mHandler$delegate;
            return (Handler)lazy.getValue();
        }

        @NotNull
        public final NetWorkCallback getINSTANCE() {
            Lazy lazy = INSTANCE$delegate;
            return (NetWorkCallback)((Object)lazy.getValue());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

