package com.transsion.lib_web

import android.content.Context
import android.content.Intent
import android.content.Intent.FLAG_ACTIVITY_NEW_TASK
import android.content.pm.ApplicationInfo
import android.content.pm.PackageManager
import android.net.Uri
import android.os.Build
import android.util.Log
import android.webkit.JavascriptInterface
import com.blankj.utilcode.util.Utils
import com.github.lzyzsd.jsbridge.BridgeWebView
import com.github.lzyzsd.jsbridge.BridgeWebView.BaseJavascriptInterface

/**
 * @author: zhangxinbing
 * @date : 2025/2/18 10:28
 * @description:
 */
open class OkSpinJsBridge(private val customWebView: BridgeWebView) :
    BaseJavascriptInterface(customWebView.callbacks) {

    override fun send(data: String?): String {
        return "send"
    }

    /**
     * 实现用户点击外跳浏览器
     */
    @JavascriptInterface
    open fun openBrowser(url: String) {
        Log.i("gs_log", "openBrowser() --> url = $url")
        try {
            var intent: Intent? = null
            intent = if (url.startsWith("intent")) {
                Intent.parseUri(url, Intent.URI_INTENT_SCHEME)
            } else {
                Intent("android.intent.action.VIEW", Uri.parse(url))
            }
            if (intent != null) {
                if (isHw()) {
                    intent.setPackage(getDefaultBrowser())
                }
                intent.addCategory(Intent.CATEGORY_BROWSABLE)
                intent.setComponent(null)
                intent.setFlags(FLAG_ACTIVITY_NEW_TASK)
            }
            //TODO:get context do startActivity
            //context.startActivity(intent)
            Utils.getApp().startActivity(intent)
        } catch (e: java.lang.Exception) {
            Log.e("gs_log", "openBrowser() --> url = $url --> e = $e")
        }
    }

    /**
     * 点击互动广告关闭按钮时调用该方法。
     * 用户点击关闭按钮关闭广告
     */
    @JavascriptInterface
    open fun close() {
        //TODO  close the ad page or activity.
        Log.i("gs_log", "close() --> close the ad page or activity.")
    }

    private fun isHw(): Boolean {
        return "huawei".equals(Build.MANUFACTURER, ignoreCase = true)
    }

    private fun getDefaultBrowser(): String? {
        var packageName: String? = null
        var systemApp: String? = null
        var userApp: String? = null
        val userAppList: MutableList<String?> = ArrayList()
        //val context: Context = GlobalCache.Singleton.getApplicationContext()
        val context: Context = Utils.getApp()
        val browserIntent = Intent("android.intent.action.VIEW", Uri.parse("https://"))
        val resolveInfo =
            context.packageManager.resolveActivity(browserIntent, PackageManager.MATCH_DEFAULT_ONLY)
        if (resolveInfo?.activityInfo != null) {
            packageName = resolveInfo.activityInfo.packageName
        }
        if (packageName == null || packageName == "android") {
            val lists = context.packageManager.queryIntentActivities(browserIntent, 0)
            for (app in lists) {
                if ((app.activityInfo.flags and ApplicationInfo.FLAG_SYSTEM) != 0) {
                    systemApp = app.activityInfo.packageName
                } else {
                    userApp = app.activityInfo.packageName
                    userAppList.add(userApp)
                }
            }
            if (userAppList.contains("com.android.chrome")) {
                packageName = "com.android.chrome"
            } else {
                if (systemApp != null) {
                    packageName = systemApp
                }
                if (userApp != null) {
                    packageName = userApp
                }
            }
        }
        return packageName
    }

}