package com.transsion.lib_web.zip

import android.content.Context
import com.blankj.utilcode.util.EncryptUtils
import com.transsion.lib_web.zip.utils.FileUtils
import com.transsion.lib_web.zip.db.WebViewCacheConfigData
import com.transsion.lib_web.zip.loader.WebViewCacheTask
import com.transsion.lib_web.zip.loader.getBaseUrl
import java.io.File

/**
 * @author: zhangxinbing
 * @date : 2024/12/11 14:04
 * @description:
 * 下载文件以md5命名
 * 下载后解压文件以md5(url)+"_"+md5 命名，其中url为页面的url 不是zip包的remote url 。主要用在拦截时通过url去匹配缓存文件
 */
object WebViewCacheDownloader {

    /**
     * 获取缓存文件夹
     */
    fun getWebViewCacheFile(context: Context) = File(context.cacheDir, "webViewCache")

    /**
     * 下载压缩包
     */
    suspend fun checkDownloadZip(context: Context, dbItem: WebViewCacheConfigData) {
        if (dbItem.zipUrl.isEmpty()) {
            return
        }
        // 开始下载任务
        WebViewCacheTask(context, dbItem).start()
    }

    /**
     * 获取本地文件
     */
    fun getLocalFile(context: Context, configData: WebViewCacheConfigData): File? {
        val baseUrl = configData.htmlUrl.getBaseUrl()
        if (baseUrl?.isEmpty() == true) return null
        return File(
            getWebViewCacheFile(context),
            EncryptUtils.encryptMD5ToString(baseUrl) + "_" + configData.zipMd5

        )
    }

    /**
     * 清除缓存
     */
    fun clearCacheFile(context: Context, cacheConfigData: WebViewCacheConfigData) {
        kotlin.runCatching {
            val localFile = getLocalFile(context, cacheConfigData)
            if (localFile?.exists() == true) {
                FileUtils.deleteFile(localFile)
            }
        }
    }
}