package com.transsion.lib_web.zip.db

import android.content.Context
import androidx.room.Database
import androidx.room.Room
import androidx.room.RoomDatabase
import androidx.room.migration.Migration
import androidx.sqlite.db.SupportSQLiteDatabase
import com.transsion.lib_web.WebLogger

/**
 * @author: zhangxinbing
 * @date : 2024/5/13 17:17
 * @description: 字幕数据库入口
 */
@Database(
    entities = [WebViewCacheConfigData::class], version = 1, exportSchema = true
)
abstract class WebResDatabase : RoomDatabase() {

    abstract fun webResDao(): WebResDao


    // =============================================================================================


    companion object {

        @Volatile
        private var instance: WebResDatabase? = null

        private const val MB_WEB_RES_DATABASE_NAME = "mb-web-res-db"

        /**
         * 数据库只能当前Module里面使用
         */
        internal fun getInstance(context: Context): WebResDatabase {
            return instance ?: synchronized(this) {
                instance ?: buildDatabase(context).also { instance = it }
            }
        }

        // Create and pre-populate the database. See this article for more details:
        // https://medium.com/google-developers/7-pro-tips-for-room-fbadea4bfbd1#4785
        private fun buildDatabase(context: Context): WebResDatabase {
            return Room.databaseBuilder(
                context.applicationContext, WebResDatabase::class.java, MB_WEB_RES_DATABASE_NAME
            )
                //是否允许在主线程进行查询
                //.allowMainThreadQueries()
                .addMigrations().addCallback(object : Callback() {
                    override fun onCreate(db: SupportSQLiteDatabase) {
                        super.onCreate(db)
                        WebLogger.logW("WebResDatabase --> getInstance() --> buildDatabase() --> onCreate() --> db.path = " + db.path)
                    }

                    override fun onOpen(db: SupportSQLiteDatabase) {
                        super.onOpen(db)
                        WebLogger.logW("WebResDatabase --> getInstance() --> buildDatabase() --> onOpen()")
                    }
                }).build()
        }

        /**
         *         MIGRATION
         * 如果有多个MIGRATION则往后添加：
        .addMigrations(MIGRATION_1_2, MIGRATION_3_4, MIGRATION_4_5, MIGRATION_5_6, MIGRATION_6_7)
         */
        private val MIGRATION_1_2 = object : Migration(1, 2) {
            override fun migrate(database: SupportSQLiteDatabase) {
                database.execSQL("ALTER TABLE DOWNLOAD_TABLE ADD COLUMN postId TEXT")
                database.execSQL("ALTER TABLE AUDIO ADD COLUMN ops TEXT")
            }
        }
    }

}