package com.transsion.lib_web.zip.db

import android.os.Parcelable
import kotlinx.parcelize.Parcelize

/**
 * @author: zhangxinbing
 * @date : 2024/12/10 20:29
 * @description: 服务端下发数据
 *
 * {
 *   "code": 0,
 *   "message": "string",
 *   "data": {
 *     "list": [
 *       {
 *         "scene": "string", // 主键
 *         "htmlUrl": "string",
 *         "zipUrl": "string",
 *         "zipMd5": "string",
 *         "sourceType": 0,
 *         "updateTime": "string"
 *       }
 *     ],
 *     "lastUpdateTime": "string"
 *   }
 * }
 */
@Parcelize
data class WebResRemoteBean(
    val list: List<WebViewCacheConfigData>? = null,     // 配置列表
    val lastUpdateTime: String? = null                  // 版本号，用于服务端判断是否需要下发数据，省流
) : Parcelable
