package com.transsion.lib_web.zip.loader

import android.text.TextUtils
import okhttp3.Interceptor
import okhttp3.Request
import okhttp3.Response
import java.io.IOException

/**
 * @author: zhangxinbing
 * @date : 2024/12/11 14:02
 * @description: 网络请求拦截器
 */
internal class HttpCacheInterceptor : Interceptor {

    companion object {
        const val KEY_CACHE = "WebResourceInterceptor-Key-Cache"
    }

    @Throws(IOException::class)
    override fun intercept(chain: Interceptor.Chain): Response {
        val request: Request = chain.request()
        val cache = request.header(KEY_CACHE)
        val originResponse: Response = chain.proceed(request)
        return if (!TextUtils.isEmpty(cache)) {
            originResponse
        } else originResponse.newBuilder().removeHeader("pragma").removeHeader("Cache-Control")
            .header("Cache-Control", "max-age=3153600000").build()
    }

}