package com.transsion.lib_web.zip.loader

import android.content.Context
import android.webkit.WebResourceRequest
import android.webkit.WebResourceResponse
import com.bumptech.glide.Glide
import com.transsion.lib_web.WebLogger
import com.transsion.lib_web.zip.utils.MimeTypeMapUtils
import java.io.File
import java.io.FileInputStream
import java.io.InputStream

/**
 * @author: zhangxinbing
 * @date : 2024/12/11 14:00
 * @description:
 */
class WebViewGlideLoader(val context: Context) : WebViewLoader {

    override fun interceptRequest(request: WebResourceRequest?): WebResourceResponse? {
        return interceptRequest(request?.url?.toString(), request?.requestHeaders ?: hashMapOf())
    }

    override fun interceptRequest(
        url: String?, headers: MutableMap<String, String>
    ): WebResourceResponse? {
        if (null == url) {
            return null
        }
        try {
            val mimeType: String? = MimeTypeMapUtils.getMimeTypeFromUrl(url)
            if (mimeType?.contains("image/") == true) {
                val submit = Glide.with(context).asFile().load(url).submit()
                val inputStream: InputStream = FileInputStream(submit.get())
                WebLogger.logD("WebViewGlideLoader --> interceptRequest() --> glide file   \nurl = $url  \nmimeType = $mimeType")
                return WebResourceResponse(
                    mimeType, "", 200, "OK", WebViewLoader.responseHeaders, inputStream
                )
            }
        } catch (e: Exception) {
            //Logger.logE("WebViewGlideLoader --> interceptRequest() --> it = $e")
            e.printStackTrace()
        }
        //Logger.d(TAG, "interceptRequest service  url:$url")
        return null
    }

    override fun getCachePath(): File? = null

    override fun clearCache() {}
}