package com.transsion.lib_web.zip.loader

import android.webkit.WebResourceRequest
import android.webkit.WebResourceResponse
import java.io.File

/**
 * @author: zhangxinbing
 * @date : 2024/12/11 11:55
 * @description:
 */
interface WebViewLoader {

    companion object {
        val responseHeaders: HashMap<String, String> = hashMapOf(
            Pair("Access-Control-Allow-Origin", "*"), Pair("Access-Control-Allow-Credentials", "*")
        )
    }

    fun interceptRequest(request: WebResourceRequest?): WebResourceResponse?
    fun interceptRequest(url: String?, headers: MutableMap<String, String>): WebResourceResponse?

    fun getCachePath(): File?
    fun clearCache()

}