/*
 * Decompiled with CFR 0.152.
 */
package com.github.lzyzsd.jsbridge;

import android.os.Looper;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import com.github.lzyzsd.jsbridge.BridgeHandler;
import com.github.lzyzsd.jsbridge.BridgeUtil;
import com.github.lzyzsd.jsbridge.DefaultHandler;
import com.github.lzyzsd.jsbridge.IWebView;
import com.github.lzyzsd.jsbridge.Message;
import com.github.lzyzsd.jsbridge.OnBridgeCallback;
import com.github.lzyzsd.jsbridge.WebViewJavascriptBridge;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BridgeHelper
implements WebViewJavascriptBridge {
    private static final String TAG = "BridgeHelper";
    private static final String BRIDGE_JS = "WebViewJavascriptBridge.js";
    private Map<String, OnBridgeCallback> responseCallbacks = new HashMap<String, OnBridgeCallback>();
    private Map<String, BridgeHandler> messageHandlers = new HashMap<String, BridgeHandler>();
    private BridgeHandler defaultHandler = new DefaultHandler();
    private List<Message> startupMessage = new ArrayList<Message>();
    private long uniqueId = 0L;
    private IWebView webView;

    private List<Message> getStartupMessage() {
        return this.startupMessage;
    }

    private void setStartupMessage(List<Message> startupMessage) {
        this.startupMessage = startupMessage;
    }

    public BridgeHelper(IWebView webView) {
        this.webView = webView;
    }

    public void setDefaultHandler(BridgeHandler handler) {
        this.defaultHandler = handler;
    }

    private void handlerReturnData(String url) {
        String functionName = BridgeUtil.getFunctionFromReturnUrl(url);
        OnBridgeCallback f = this.responseCallbacks.get(functionName);
        String data = BridgeUtil.getDataFromReturnUrl(url);
        if (f != null) {
            f.onCallBack(data);
            this.responseCallbacks.remove(functionName);
        }
    }

    private void doSend(String handlerName, String data, OnBridgeCallback responseCallback) {
        Message m = new Message();
        if (!TextUtils.isEmpty((CharSequence)data)) {
            m.setData(data);
        }
        if (responseCallback != null) {
            String callbackStr = String.format("JAVA_CB_%s", ++this.uniqueId + "_" + SystemClock.currentThreadTimeMillis());
            this.responseCallbacks.put(callbackStr, responseCallback);
            m.setCallbackId(callbackStr);
        }
        if (!TextUtils.isEmpty((CharSequence)handlerName)) {
            m.setHandlerName(handlerName);
        }
        this.queueMessage(m);
    }

    private void queueMessage(Message m) {
        if (this.startupMessage != null) {
            this.startupMessage.add(m);
        } else {
            this.dispatchMessage(m);
        }
    }

    private void dispatchMessage(Message m) {
        String messageJson = m.toJson();
        messageJson = messageJson.replaceAll("(\\\\)([^utrn])", "\\\\\\\\$1$2");
        messageJson = messageJson.replaceAll("(?<=[^\\\\])(\")", "\\\\\"");
        messageJson = messageJson.replaceAll("(?<=[^\\\\])(')", "\\\\'");
        messageJson = messageJson.replaceAll("%7B", URLEncoder.encode("%7B"));
        messageJson = messageJson.replaceAll("%7D", URLEncoder.encode("%7D"));
        messageJson = messageJson.replaceAll("%22", URLEncoder.encode("%22"));
        String javascriptCommand = String.format("javascript:WebViewJavascriptBridge._handleMessageFromNative(%s);", messageJson);
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            this.loadUrl(javascriptCommand);
        }
    }

    private void flushMessageQueue() {
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            this.loadUrl("javascript:WebViewJavascriptBridge._fetchQueue();", new OnBridgeCallback(){

                @Override
                public void onCallBack(String data) {
                    List<Message> list = null;
                    try {
                        list = Message.toArrayList(data);
                    }
                    catch (Exception e) {
                        Log.w((String)BridgeHelper.TAG, (Throwable)e);
                        return;
                    }
                    if (list == null || list.isEmpty()) {
                        return;
                    }
                    for (int i = 0; i < list.size(); ++i) {
                        Message m = list.get(i);
                        String responseId = m.getResponseId();
                        if (!TextUtils.isEmpty((CharSequence)responseId)) {
                            OnBridgeCallback function = BridgeHelper.this.responseCallbacks.get(responseId);
                            String responseData = m.getResponseData();
                            function.onCallBack(responseData);
                            BridgeHelper.this.responseCallbacks.remove(responseId);
                            continue;
                        }
                        OnBridgeCallback responseFunction = null;
                        final String callbackId = m.getCallbackId();
                        responseFunction = !TextUtils.isEmpty((CharSequence)callbackId) ? new OnBridgeCallback(){

                            @Override
                            public void onCallBack(String data) {
                                Message responseMsg = new Message();
                                responseMsg.setResponseId(callbackId);
                                responseMsg.setResponseData(data);
                                BridgeHelper.this.queueMessage(responseMsg);
                            }
                        } : new OnBridgeCallback(){

                            @Override
                            public void onCallBack(String data) {
                            }
                        };
                        BridgeHandler handler = !TextUtils.isEmpty((CharSequence)m.getHandlerName()) ? BridgeHelper.this.messageHandlers.get(m.getHandlerName()) : BridgeHelper.this.defaultHandler;
                        if (handler == null) continue;
                        handler.handler(m.getData(), responseFunction);
                    }
                }
            });
        }
    }

    private void loadUrl(String jsUrl, OnBridgeCallback returnCallback) {
        this.loadUrl(jsUrl);
        this.responseCallbacks.put(BridgeUtil.parseFunctionName(jsUrl), returnCallback);
    }

    private void loadUrl(String jsUrl) {
        this.webView.loadUrl(jsUrl);
    }

    public void registerHandler(String handlerName, BridgeHandler handler) {
        if (handler != null) {
            this.messageHandlers.put(handlerName, handler);
        }
    }

    public void unregisterHandler(String handlerName) {
        if (handlerName != null) {
            this.messageHandlers.remove(handlerName);
        }
    }

    public void callHandler(String handlerName, String data, OnBridgeCallback callBack) {
        this.doSend(handlerName, data, callBack);
    }

    public void onPageFinished() {
        this.webViewLoadLocalJs();
        if (this.getStartupMessage() != null) {
            for (Message m : this.getStartupMessage()) {
                this.dispatchMessage(m);
            }
            this.setStartupMessage(null);
        }
    }

    private void webViewLoadLocalJs() {
        String jsContent = BridgeUtil.assetFile2Str(this.webView.getContext(), BRIDGE_JS);
        this.loadUrl("javascript:" + jsContent);
    }

    public boolean shouldOverrideUrlLoading(String url) {
        try {
            String replacedUrl = url.replaceAll("%(?![0-9a-fA-F]{2})", "%25").replaceAll("\\+", "%2B");
            url = URLDecoder.decode(replacedUrl, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Log.w((String)TAG, (Throwable)e);
        }
        if (url.startsWith("yy://return/")) {
            this.handlerReturnData(url);
            return true;
        }
        if (url.startsWith("yy://")) {
            this.flushMessageQueue();
            return true;
        }
        return false;
    }

    @Override
    public void sendToWeb(String data) {
        this.sendToWeb(data, null);
    }

    @Override
    public void sendToWeb(String data, OnBridgeCallback responseCallback) {
        this.doSend(null, data, responseCallback);
    }

    @Override
    public void sendToWeb(String function, Object ... values) {
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            String jsCommand = String.format(function, values);
            jsCommand = String.format("javascript:%s", jsCommand);
            this.loadUrl(jsCommand);
        }
    }
}

