/*
 * Decompiled with CFR 0.152.
 */
package com.github.lzyzsd.jsbridge;

import android.content.Context;
import android.webkit.WebView;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class BridgeUtil {
    static final String YY_OVERRIDE_SCHEMA = "yy://";
    static final String YY_RETURN_DATA = "yy://return/";
    static final String YY_FETCH_QUEUE = "yy://return/_fetchQueue/";
    static final String EMPTY_STR = "";
    static final String UNDERLINE_STR = "_";
    static final String SPLIT_MARK = "/";
    static final String CALLBACK_ID_FORMAT = "JAVA_CB_%s";
    static final String JS_HANDLE_MESSAGE_FROM_JAVA = "javascript:WebViewJavascriptBridge._handleMessageFromNative(%s);";
    public static final String JS_NAVIGATOR_HOST = "javascript:window.navigator.hostInfo = { platform: 'Android',version: '%s' }";
    static final String JS_FETCH_QUEUE_FROM_JAVA = "javascript:WebViewJavascriptBridge._fetchQueue();";
    public static final String JAVA_SCRIPT = "WebViewJavascriptBridge.js";
    public static final String JAVASCRIPT_STR = "javascript:%s";

    public static void webViewLoadJs(WebView view, String url) {
        String js = "var newscript = document.createElement(\"script\");";
        js = js + "newscript.src=\"" + url + "\";";
        js = js + "document.scripts[0].parentNode.insertBefore(newscript,document.scripts[0]);";
        view.loadUrl("javascript:" + js);
    }

    public static void webViewLoadLocalJs(WebView view, String path) {
        String jsContent = BridgeUtil.assetFile2Str(view.getContext(), path);
        view.loadUrl("javascript:" + jsContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String assetFile2Str(Context c, String urlStr) {
        InputStream in = null;
        try {
            in = c.getAssets().open(urlStr);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in));
            String line = null;
            StringBuilder sb = new StringBuilder();
            do {
                if ((line = bufferedReader.readLine()) == null || line.matches("^\\s*\\/\\/.*")) continue;
                sb.append(line);
            } while (line != null);
            bufferedReader.close();
            in.close();
            String string = sb.toString();
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static String getFunctionFromReturnUrl(String url) {
        return EMPTY_STR;
    }

    public static String getDataFromReturnUrl(String url) {
        return EMPTY_STR;
    }

    public static String parseFunctionName(String jsUrl) {
        return EMPTY_STR;
    }
}

