/*
 * Decompiled with CFR 0.152.
 */
package com.github.lzyzsd.jsbridge;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.Looper;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.collection.ArrayMap;
import com.github.lzyzsd.jsbridge.BridgeWebViewClient;
import com.github.lzyzsd.jsbridge.JSRequest;
import com.github.lzyzsd.jsbridge.JSResponse;
import com.github.lzyzsd.jsbridge.OnBridgeCallback;
import com.github.lzyzsd.jsbridge.WebViewJavascriptBridge;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

@SuppressLint(value={"SetJavaScriptEnabled"})
public class BridgeWebView
extends WebView
implements WebViewJavascriptBridge,
BridgeWebViewClient.OnLoadJSListener {
    private final int URL_MAX_CHARACTER_NUM = 0x200000;
    private Map<String, OnBridgeCallback> mCallbacks = new ArrayMap();
    private List<Object> mMessages = new ArrayList<Object>();
    private BridgeWebViewClient mClient;
    private long mUniqueId = 0L;
    private boolean mJSLoaded = false;
    private Gson mGson;

    public BridgeWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public BridgeWebView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    public BridgeWebView(Context context) {
        super(context);
        this.init();
    }

    private void init() {
        this.clearCache(true);
        this.getSettings().setUseWideViewPort(true);
        this.getSettings().setCacheMode(2);
        this.getSettings().setJavaScriptEnabled(true);
        this.getSettings().setJavaScriptCanOpenWindowsAutomatically(true);
        this.mClient = new BridgeWebViewClient(this);
        super.setWebViewClient((WebViewClient)this.mClient);
    }

    public void setGson(Gson gson) {
        this.mGson = gson;
    }

    public boolean isJSLoaded() {
        return this.mJSLoaded;
    }

    public Map<String, OnBridgeCallback> getCallbacks() {
        return this.mCallbacks;
    }

    public void setWebViewClient(WebViewClient client2) {
        this.mClient.setWebViewClient(client2);
    }

    @Override
    public void onLoadStart() {
        this.mJSLoaded = false;
    }

    @Override
    public void onLoadFinished() {
        this.mJSLoaded = true;
        if (this.mMessages != null) {
            for (Object message : this.mMessages) {
                this.dispatchMessage(message);
            }
            this.mMessages = null;
        }
    }

    @Override
    public void sendToWeb(String data) {
        this.sendToWeb(data, null);
    }

    @Override
    public void sendToWeb(String data, OnBridgeCallback responseCallback) {
        this.doSend(null, data, responseCallback);
    }

    public void callHandler(String handlerName, String data, OnBridgeCallback callBack) {
        this.doSend(handlerName, data, callBack);
    }

    @Override
    public void sendToWeb(String function, Object ... values) {
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            String jsCommand = String.format(function, values);
            jsCommand = String.format("javascript:%s", jsCommand);
            this.loadUrl(jsCommand);
        }
    }

    private void doSend(String handlerName, Object data, OnBridgeCallback responseCallback) {
        if (!(data instanceof String) && this.mGson == null) {
            return;
        }
        JSRequest request = new JSRequest();
        if (data != null) {
            String string = request.data = data instanceof String ? (String)data : this.mGson.toJson(data);
        }
        if (responseCallback != null) {
            String callbackId = String.format("JAVA_CB_%s", ++this.mUniqueId + "_" + SystemClock.currentThreadTimeMillis());
            this.mCallbacks.put(callbackId, responseCallback);
            request.callbackId = callbackId;
        }
        if (!TextUtils.isEmpty((CharSequence)handlerName)) {
            request.handlerName = handlerName;
        }
        this.queueMessage(request);
    }

    private void queueMessage(Object message) {
        if (this.mMessages != null) {
            this.mMessages.add(message);
        } else {
            this.dispatchMessage(message);
        }
    }

    private void dispatchMessage(Object message) {
        if (this.mGson == null) {
            return;
        }
        String messageJson = this.mGson.toJson(message);
        messageJson = JSONObject.quote((String)messageJson);
        String javascriptCommand = String.format("javascript:WebViewJavascriptBridge._handleMessageFromNative(%s);", messageJson);
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            if (Build.VERSION.SDK_INT >= 19 && javascriptCommand.length() >= 0x200000) {
                this.evaluateJavascript(javascriptCommand, null);
            } else {
                this.loadUrl(javascriptCommand);
            }
        }
    }

    public void sendResponse(Object data, String callbackId) {
        if (!(data instanceof String) && this.mGson == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)callbackId)) {
            final JSResponse response = new JSResponse();
            response.responseId = callbackId;
            String string = response.responseData = data instanceof String ? (String)data : this.mGson.toJson(data);
            if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
                this.dispatchMessage(response);
            } else {
                this.post(new Runnable(){

                    @Override
                    public void run() {
                        BridgeWebView.this.dispatchMessage(response);
                    }
                });
            }
        }
    }

    public void destroy() {
        super.destroy();
        this.mCallbacks.clear();
    }

    public static abstract class BaseJavascriptInterface {
        private Map<String, OnBridgeCallback> mCallbacks;

        public BaseJavascriptInterface(Map<String, OnBridgeCallback> callbacks) {
            this.mCallbacks = callbacks;
        }

        @JavascriptInterface
        public String send(String data, String callbackId) {
            Log.d((String)"BaseJavascriptInterface", (String)(data + ", callbackId: " + callbackId + " " + Thread.currentThread().getName()));
            return this.send(data);
        }

        @JavascriptInterface
        public void response(String data, String responseId) {
            OnBridgeCallback function;
            Log.d((String)"BaseJavascriptInterface", (String)(data + ", responseId: " + responseId + " " + Thread.currentThread().getName()));
            if (!TextUtils.isEmpty((CharSequence)responseId) && (function = this.mCallbacks.remove(responseId)) != null) {
                function.onCallBack(data);
            }
        }

        public abstract String send(String var1);
    }
}

