/*
 * Decompiled with CFR 0.152.
 */
package com.github.lzyzsd.jsbridge;

import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.net.http.SslError;
import android.os.Build;
import android.os.Message;
import android.util.Log;
import android.view.KeyEvent;
import android.webkit.ClientCertRequest;
import android.webkit.HttpAuthHandler;
import android.webkit.RenderProcessGoneDetail;
import android.webkit.SafeBrowsingResponse;
import android.webkit.SslErrorHandler;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.Nullable;
import com.github.lzyzsd.jsbridge.BridgeUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

class BridgeWebViewClient
extends WebViewClient {
    private static final String TAG = "BridgeWebViewClient";
    private OnLoadJSListener mListener;
    private WebViewClient mClient;
    private boolean isLoadNavigator = false;

    public BridgeWebViewClient(OnLoadJSListener listener) {
        this.mListener = listener;
    }

    public void setWebViewClient(WebViewClient client2) {
        this.mClient = client2;
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        if (this.mClient != null) {
            return this.mClient.shouldOverrideUrlLoading(view, url);
        }
        return this.interceptUrl(url) ? true : super.shouldOverrideUrlLoading(view, url);
    }

    private boolean interceptUrl(String url) {
        try {
            url = URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        Log.i((String)TAG, (String)("shouldOverrideUrlLoading, url = " + url));
        if (url.startsWith("yy://return/")) {
            return true;
        }
        return url.startsWith("yy://");
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        if (this.mClient != null) {
            this.mClient.onPageStarted(view, url, favicon);
        } else {
            super.onPageStarted(view, url, favicon);
        }
        if (!this.isLoadNavigator) {
            PackageManager manager = view.getContext().getPackageManager();
            String name = null;
            try {
                PackageInfo info = manager.getPackageInfo(view.getContext().getPackageName(), 0);
                name = info.versionName;
                String jsCall = String.format("javascript:window.navigator.hostInfo = { platform: 'Android',version: '%s' }", name);
                Log.e((String)"yy", (String)("jsCall:" + jsCall));
                view.loadUrl(jsCall);
                this.isLoadNavigator = true;
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public void onPageFinished(WebView view, String url) {
        if (this.mClient != null) {
            this.mClient.onPageFinished(view, url);
        } else {
            super.onPageFinished(view, url);
        }
        this.mListener.onLoadStart();
        BridgeUtil.webViewLoadLocalJs(view, "WebViewJavascriptBridge.js");
        this.mListener.onLoadFinished();
    }

    public void onLoadResource(WebView view, String url) {
        if (this.mClient != null) {
            this.mClient.onLoadResource(view, url);
        } else {
            super.onLoadResource(view, url);
        }
    }

    public void onPageCommitVisible(WebView view, String url) {
        if (Build.VERSION.SDK_INT >= 23 && this.mClient != null) {
            this.mClient.onPageCommitVisible(view, url);
        } else {
            super.onPageCommitVisible(view, url);
        }
    }

    @Nullable
    public WebResourceResponse shouldInterceptRequest(WebView view, String url) {
        if (this.mClient != null) {
            return this.mClient.shouldInterceptRequest(view, url);
        }
        return super.shouldInterceptRequest(view, url);
    }

    @Nullable
    public WebResourceResponse shouldInterceptRequest(WebView view, WebResourceRequest request) {
        if (Build.VERSION.SDK_INT >= 21 && this.mClient != null) {
            return this.mClient.shouldInterceptRequest(view, request);
        }
        return super.shouldInterceptRequest(view, request);
    }

    public void onTooManyRedirects(WebView view, Message cancelMsg, Message continueMsg) {
        if (this.mClient != null) {
            this.mClient.onTooManyRedirects(view, cancelMsg, continueMsg);
        } else {
            super.onTooManyRedirects(view, cancelMsg, continueMsg);
        }
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        if (this.mClient != null) {
            this.mClient.onReceivedError(view, errorCode, description, failingUrl);
        } else {
            super.onReceivedError(view, errorCode, description, failingUrl);
        }
    }

    public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
        if (Build.VERSION.SDK_INT >= 23 && this.mClient != null) {
            this.mClient.onReceivedError(view, request, error);
        } else {
            super.onReceivedError(view, request, error);
        }
    }

    public void onReceivedHttpError(WebView view, WebResourceRequest request, WebResourceResponse errorResponse) {
        if (Build.VERSION.SDK_INT >= 23 && this.mClient != null) {
            this.mClient.onReceivedHttpError(view, request, errorResponse);
        } else {
            super.onReceivedHttpError(view, request, errorResponse);
        }
    }

    public void onFormResubmission(WebView view, Message dontResend, Message resend) {
        if (this.mClient != null) {
            this.mClient.onFormResubmission(view, dontResend, resend);
        } else {
            super.onFormResubmission(view, dontResend, resend);
        }
    }

    public void doUpdateVisitedHistory(WebView view, String url, boolean isReload) {
        if (this.mClient != null) {
            this.mClient.doUpdateVisitedHistory(view, url, isReload);
        } else {
            super.doUpdateVisitedHistory(view, url, isReload);
        }
    }

    public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
        if (this.mClient != null) {
            this.mClient.onReceivedSslError(view, handler, error);
        } else {
            super.onReceivedSslError(view, handler, error);
        }
    }

    public void onReceivedClientCertRequest(WebView view, ClientCertRequest request) {
        if (Build.VERSION.SDK_INT >= 21 && this.mClient != null) {
            this.mClient.onReceivedClientCertRequest(view, request);
        } else {
            super.onReceivedClientCertRequest(view, request);
        }
    }

    public void onReceivedHttpAuthRequest(WebView view, HttpAuthHandler handler, String host, String realm) {
        if (this.mClient != null) {
            this.mClient.onReceivedHttpAuthRequest(view, handler, host, realm);
        } else {
            super.onReceivedHttpAuthRequest(view, handler, host, realm);
        }
    }

    public boolean shouldOverrideKeyEvent(WebView view, KeyEvent event) {
        if (this.mClient != null) {
            return this.mClient.shouldOverrideKeyEvent(view, event);
        }
        return super.shouldOverrideKeyEvent(view, event);
    }

    public void onUnhandledKeyEvent(WebView view, KeyEvent event) {
        if (this.mClient != null) {
            this.mClient.onUnhandledKeyEvent(view, event);
        } else {
            super.onUnhandledKeyEvent(view, event);
        }
    }

    public void onScaleChanged(WebView view, float oldScale, float newScale) {
        if (this.mClient != null) {
            this.mClient.onScaleChanged(view, oldScale, newScale);
        } else {
            super.onScaleChanged(view, oldScale, newScale);
        }
    }

    public void onReceivedLoginRequest(WebView view, String realm, @Nullable String account, String args) {
        if (this.mClient != null) {
            this.mClient.onReceivedLoginRequest(view, realm, account, args);
        } else {
            super.onReceivedLoginRequest(view, realm, account, args);
        }
    }

    public boolean onRenderProcessGone(WebView view, RenderProcessGoneDetail detail) {
        if (Build.VERSION.SDK_INT >= 26 && this.mClient != null) {
            return this.mClient.onRenderProcessGone(view, detail);
        }
        return super.onRenderProcessGone(view, detail);
    }

    public void onSafeBrowsingHit(WebView view, WebResourceRequest request, int threatType, SafeBrowsingResponse callback) {
        if (Build.VERSION.SDK_INT >= 27 && this.mClient != null) {
            this.mClient.onSafeBrowsingHit(view, request, threatType, callback);
        } else {
            super.onSafeBrowsingHit(view, request, threatType, callback);
        }
    }

    public static interface OnLoadJSListener {
        public void onLoadStart();

        public void onLoadFinished();
    }
}

