/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.lib_web;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.webkit.JavascriptInterface;
import android.webkit.RenderProcessGoneDetail;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import androidx.activity.OnBackPressedCallback;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleOwner;
import com.blankj.utilcode.util.GsonUtils;
import com.blankj.utilcode.util.SizeUtils;
import com.github.lzyzsd.jsbridge.BridgeWebView;
import com.gyf.immersionbar.BarHide;
import com.gyf.immersionbar.ImmersionBar;
import com.tn.lib.util.networkinfo.NetworkUtil;
import com.tn.lib.util.networkinfo.OnNetworkStatusChangedListener;
import com.transsion.lib_web.H5BarUtil;
import com.transsion.lib_web.OkSpinJsBridge;
import com.transsion.lib_web.ParseDeeplinkManager;
import com.transsion.lib_web.WebLogger;
import com.transsion.lib_web.cache.TWebViewCacheManager;
import com.transsion.lib_web.databinding.LibWebWebFragmentLayoutBinding;
import com.transsion.lib_web.domain.DomPerformance;
import com.transsion.lib_web.domain.LoadInfoStats;
import com.transsion.lib_web.domain.LoadStatus;
import com.transsion.lib_web.zip.loader.WebViewFileCacheLoader;
import com.transsion.lib_web.zip.loader.WebViewLoaderManager;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\u0083\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u00105\u001a\u0002062\b\u00107\u001a\u0004\u0018\u00010\u001fH\u0002J<\u00108\u001a\u0002062\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020.2\b\u0010<\u001a\u0004\u0018\u00010.2\b\u0010=\u001a\u0004\u0018\u00010.2\u0006\u0010>\u001a\u00020\u00132\u0006\u0010?\u001a\u00020.H\u0016J\u0010\u0010@\u001a\u0002062\u0006\u0010A\u001a\u00020\u001fH&J\u0010\u0010B\u001a\u0002062\u0006\u0010C\u001a\u00020.H\u0002J\u0006\u0010D\u001a\u00020.J\b\u0010E\u001a\u00020.H\u0016J\u0006\u0010F\u001a\u00020\u001fJ\u001a\u0010G\u001a\u0002062\b\u0010H\u001a\u0004\u0018\u00010.2\u0006\u0010I\u001a\u00020+H\u0002J\u0010\u0010J\u001a\u0002062\u0006\u0010K\u001a\u00020LH\u0002J\b\u0010M\u001a\u000206H\u0003J\b\u0010N\u001a\u000206H\u0002J\u0012\u0010O\u001a\u0002062\b\u00107\u001a\u0004\u0018\u00010\u001fH\u0003J\u0012\u0010P\u001a\u0002062\b\u00107\u001a\u0004\u0018\u00010\u001fH\u0002J\u0012\u0010Q\u001a\u0002062\b\u00107\u001a\u0004\u0018\u00010\u001fH\u0003J\u0012\u0010R\u001a\u0002062\b\u00107\u001a\u0004\u0018\u00010\u001fH\u0002J\b\u0010S\u001a\u000206H\u0002J\u0012\u0010T\u001a\u0002062\b\u00107\u001a\u0004\u0018\u00010\u001fH\u0002J\b\u0010U\u001a\u000206H\u0002J\u0012\u0010V\u001a\u0002062\b\u0010W\u001a\u0004\u0018\u00010XH\u0002J\b\u0010Y\u001a\u00020LH\u0002J\u0018\u0010Z\u001a\u0002062\u0006\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020^H\u0016J\u0012\u0010_\u001a\u0002062\b\u0010`\u001a\u0004\u0018\u00010aH\u0016J&\u0010b\u001a\u0004\u0018\u0001042\u0006\u0010c\u001a\u00020d2\b\u0010e\u001a\u0004\u0018\u00010f2\b\u0010`\u001a\u0004\u0018\u00010aH\u0016J\b\u0010g\u001a\u000206H\u0016J\b\u0010h\u001a\u000206H\u0016J\b\u0010i\u001a\u000206H\u0016J\u001a\u0010j\u001a\u0002062\u0006\u0010k\u001a\u0002042\b\u0010`\u001a\u0004\u0018\u00010aH\u0016J\b\u0010l\u001a\u000206H\u0016J\u0018\u0010m\u001a\u0002062\u0006\u0010k\u001a\u00020X2\u0006\u0010n\u001a\u00020+H\u0016J\u0018\u0010o\u001a\u0002062\u0006\u0010k\u001a\u00020X2\u0006\u0010=\u001a\u00020.H\u0016J\u001c\u0010p\u001a\u0002062\b\u0010k\u001a\u0004\u0018\u0001042\b\u0010q\u001a\u0004\u0018\u00010\u0011H\u0016J\u0018\u0010r\u001a\u0002062\u0006\u0010k\u001a\u00020X2\u0006\u0010<\u001a\u00020.H\u0016J\"\u0010s\u001a\u0002062\u0006\u0010k\u001a\u00020X2\u0006\u0010<\u001a\u00020.2\b\u0010t\u001a\u0004\u0018\u00010uH\u0016J\"\u0010v\u001a\u0002062\b\u0010k\u001a\u0004\u0018\u00010X2\u0006\u0010w\u001a\u00020x2\u0006\u0010y\u001a\u00020zH\u0016J.\u0010v\u001a\u0002062\b\u0010k\u001a\u0004\u0018\u00010X2\u0006\u0010w\u001a\u00020+2\b\u0010y\u001a\u0004\u0018\u00010.2\b\u0010{\u001a\u0004\u0018\u00010.H\u0016J \u0010|\u001a\u0002062\u0006\u0010k\u001a\u00020X2\u0006\u0010w\u001a\u00020x2\u0006\u0010}\u001a\u00020~H\u0016J\u0012\u0010\u007f\u001a\u0002062\b\u00107\u001a\u0004\u0018\u00010\u001fH\u0002J%\u0010\u0080\u0001\u001a\u0002062\b\u0010<\u001a\u0004\u0018\u00010.2\u0006\u0010I\u001a\u00020+2\b\u0010H\u001a\u0004\u0018\u00010.H\u0016J\u001c\u0010\u0081\u0001\u001a\u0002062\b\u0010<\u001a\u0004\u0018\u00010.2\u0007\u0010\u0082\u0001\u001a\u00020\u0013H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001c\u0010$\u001a\u0004\u0018\u00010%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u000e\u0010*\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010-\u001a\u0004\u0018\u00010.X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u0010\u00103\u001a\u0004\u0018\u000104X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0084\u0001"}, d2={"Lcom/transsion/lib_web/BaseLibWebFragment;", "Landroidx/fragment/app/Fragment;", "Lcom/tn/lib/util/networkinfo/OnNetworkStatusChangedListener;", "()V", "binding", "Lcom/transsion/lib_web/databinding/LibWebWebFragmentLayoutBinding;", "getBinding", "()Lcom/transsion/lib_web/databinding/LibWebWebFragmentLayoutBinding;", "setBinding", "(Lcom/transsion/lib_web/databinding/LibWebWebFragmentLayoutBinding;)V", "currentState", "Lcom/transsion/lib_web/domain/LoadStatus;", "getCurrentState", "()Lcom/transsion/lib_web/domain/LoadStatus;", "setCurrentState", "(Lcom/transsion/lib_web/domain/LoadStatus;)V", "customViewCallback", "Landroid/webkit/WebChromeClient$CustomViewCallback;", "firstLoadStartTime", "", "getFirstLoadStartTime", "()J", "setFirstLoadStartTime", "(J)V", "fullscreenContainer", "Landroid/widget/FrameLayout;", "loadInfoStats", "Lcom/transsion/lib_web/domain/LoadInfoStats;", "getLoadInfoStats", "()Lcom/transsion/lib_web/domain/LoadInfoStats;", "mWebView", "Lcom/github/lzyzsd/jsbridge/BridgeWebView;", "getMWebView", "()Lcom/github/lzyzsd/jsbridge/BridgeWebView;", "setMWebView", "(Lcom/github/lzyzsd/jsbridge/BridgeWebView;)V", "mWebViewLoaderManager", "Lcom/transsion/lib_web/zip/loader/WebViewLoaderManager;", "getMWebViewLoaderManager", "()Lcom/transsion/lib_web/zip/loader/WebViewLoaderManager;", "setMWebViewLoaderManager", "(Lcom/transsion/lib_web/zip/loader/WebViewLoaderManager;)V", "originalOrientation", "", "originalSystemUiVisibility", "strTitle", "", "getStrTitle", "()Ljava/lang/String;", "setStrTitle", "(Ljava/lang/String;)V", "webCustomView", "Landroid/view/View;", "addCallback", "", "webView", "addDownloadWithDialogForWeb", "requireActivity", "Landroidx/fragment/app/FragmentActivity;", "tag", "url", "title", "contentLength", "originalUrl", "addJsInterface", "bridgeWebView", "checkFirstLoadStatus", "string", "getClassTag", "getUrl", "getWebView", "handleFirstLoadFailure", "errorMsg", "errorCode", "hideToolBar", "isHideToolBar", "", "initLayout", "initListener", "initSettings", "initWebChromeClient", "initWebContentMonitor", "initWebOptions", "initWebView", "initWebViewClient", "initWebViewFileCacheLoader", "injectPerformanceScript", "view1", "Landroid/webkit/WebView;", "loadUrlOnly", "onConnected", "network", "Landroid/net/Network;", "networkCapabilities", "Landroid/net/NetworkCapabilities;", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onCreateView", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "onDestroy", "onDestroyView", "onDisconnected", "onViewCreated", "view", "onWebChromeClientHideCustomView", "onWebChromeClientProgressChanged", "newProgress", "onWebChromeClientReceivedTitle", "onWebChromeClientShowCustomView", "callback", "onWebViewClientPageFinished", "onWebViewClientPageStarted", "favicon", "Landroid/graphics/Bitmap;", "onWebViewClientReceivedError", "request", "Landroid/webkit/WebResourceRequest;", "error", "Landroid/webkit/WebResourceError;", "failingUrl", "onWebViewClientReceivedHttpError", "errorResponse", "Landroid/webkit/WebResourceResponse;", "setDownloadListener", "trackError", "trackEvent", "loadTime", "LoadTimeInterface", "lib_web_release"})
public abstract class BaseLibWebFragment
extends Fragment
implements OnNetworkStatusChangedListener {
    @Nullable
    private FrameLayout fullscreenContainer;
    public LibWebWebFragmentLayoutBinding binding;
    @Nullable
    private WebViewLoaderManager mWebViewLoaderManager;
    @Nullable
    private String strTitle = "";
    @NotNull
    private LoadStatus currentState = LoadStatus.INIT;
    @Nullable
    private View webCustomView;
    private int originalSystemUiVisibility;
    @Nullable
    private WebChromeClient.CustomViewCallback customViewCallback;
    private int originalOrientation = -1;
    public BridgeWebView mWebView;
    private long firstLoadStartTime;
    @NotNull
    private final LoadInfoStats loadInfoStats = new LoadInfoStats();

    @NotNull
    public final LibWebWebFragmentLayoutBinding getBinding() {
        LibWebWebFragmentLayoutBinding libWebWebFragmentLayoutBinding = this.binding;
        if (libWebWebFragmentLayoutBinding != null) {
            return libWebWebFragmentLayoutBinding;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        return null;
    }

    public final void setBinding(@NotNull LibWebWebFragmentLayoutBinding libWebWebFragmentLayoutBinding) {
        Intrinsics.checkNotNullParameter((Object)libWebWebFragmentLayoutBinding, (String)"<set-?>");
        this.binding = libWebWebFragmentLayoutBinding;
    }

    @Nullable
    public final WebViewLoaderManager getMWebViewLoaderManager() {
        return this.mWebViewLoaderManager;
    }

    public final void setMWebViewLoaderManager(@Nullable WebViewLoaderManager webViewLoaderManager) {
        this.mWebViewLoaderManager = webViewLoaderManager;
    }

    @Nullable
    public final String getStrTitle() {
        return this.strTitle;
    }

    public final void setStrTitle(@Nullable String string) {
        this.strTitle = string;
    }

    @NotNull
    public final LoadStatus getCurrentState() {
        return this.currentState;
    }

    public final void setCurrentState(@NotNull LoadStatus loadStatus) {
        Intrinsics.checkNotNullParameter((Object)((Object)loadStatus), (String)"<set-?>");
        this.currentState = loadStatus;
    }

    @NotNull
    public final String getClassTag() {
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        return string;
    }

    @NotNull
    public final BridgeWebView getMWebView() {
        BridgeWebView bridgeWebView = this.mWebView;
        if (bridgeWebView != null) {
            return bridgeWebView;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"mWebView");
        return null;
    }

    public final void setMWebView(@NotNull BridgeWebView bridgeWebView) {
        Intrinsics.checkNotNullParameter((Object)bridgeWebView, (String)"<set-?>");
        this.mWebView = bridgeWebView;
    }

    @NotNull
    public final BridgeWebView getWebView() {
        return this.getMWebView();
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setMWebView(TWebViewCacheManager.INSTANCE.getWebView(this.getUrl(), this.getContext()));
    }

    @Nullable
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)inflater, (String)"inflater");
        LibWebWebFragmentLayoutBinding libWebWebFragmentLayoutBinding = LibWebWebFragmentLayoutBinding.inflate(inflater);
        Intrinsics.checkNotNullExpressionValue((Object)libWebWebFragmentLayoutBinding, (String)"inflate(inflater)");
        this.setBinding(libWebWebFragmentLayoutBinding);
        return (View)this.getBinding().getRoot();
    }

    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super.onViewCreated(view, savedInstanceState);
        this.getBinding().webContainer.addView((View)this.getMWebView());
        this.initLayout();
        this.initListener();
        this.initWebView();
        NetworkUtil.INSTANCE.registerNetworkStatusChangedListener((OnNetworkStatusChangedListener)this);
    }

    public void onDestroyView() {
        super.onDestroyView();
        TWebViewCacheManager.INSTANCE.destroy(this.getWebView());
    }

    public void onDestroy() {
        super.onDestroy();
        NetworkUtil.INSTANCE.unregisterNetworkStatusChangedListener((OnNetworkStatusChangedListener)this);
        WebLogger.INSTANCE.logE(this.getClassTag() + " --> onDestroy()");
    }

    public void onConnected(@NotNull Network network, @NotNull NetworkCapabilities networkCapabilities) {
        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
        Intrinsics.checkNotNullParameter((Object)networkCapabilities, (String)"networkCapabilities");
    }

    public void onDisconnected() {
    }

    private final void initListener() {
        this.getBinding().ivBack.setOnClickListener(arg_0 -> BaseLibWebFragment.initListener$lambda$0(this, arg_0));
        this.getBinding().ivClose.setOnClickListener(arg_0 -> BaseLibWebFragment.initListener$lambda$1(this, arg_0));
        this.getBinding().ivRight.setOnClickListener(arg_0 -> BaseLibWebFragment.initListener$lambda$2(this, arg_0));
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private final void initLayout() {
        boolean isShowHomeHeader;
        LibWebWebFragmentLayoutBinding libWebWebFragmentLayoutBinding;
        Bundle bundle = this.getArguments();
        boolean statusBarHide = bundle != null ? bundle.getBoolean("tool_status_bar_hidden", false) : false;
        Bundle bundle2 = this.getArguments();
        boolean isFieldToolBarHidden = bundle2 != null ? bundle2.getBoolean("tool_bar_hidden", false) : false;
        Bundle bundle3 = this.getArguments();
        int bottomMargin = bundle3 != null ? bundle3.getInt("bottom_margin", 0) : 0;
        Bundle bundle4 = this.getArguments();
        boolean isNestedScrollIntercept = bundle4 != null ? bundle4.getBoolean("nested_scroll_intercept", false) : false;
        LibWebWebFragmentLayoutBinding $this$initLayout_u24lambda_u243 = libWebWebFragmentLayoutBinding = this.getBinding();
        boolean bl = false;
        $this$initLayout_u24lambda_u243.getRoot().setFitsSystemWindows(!statusBarHide);
        if (bottomMargin > 0) {
            ViewGroup.LayoutParams layoutParams = $this$initLayout_u24lambda_u243.webContainer.getLayoutParams();
            Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
            ConstraintLayout.LayoutParams layoutParams2 = (ConstraintLayout.LayoutParams)layoutParams;
            layoutParams2.bottomMargin = bottomMargin;
            $this$initLayout_u24lambda_u243.webContainer.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
        }
        if (isNestedScrollIntercept) {
            this.getWebView().setOnTouchListener(new View.OnTouchListener(this){
                private float startX;
                private float startY;
                private boolean isDragging;
                private final int touchSlop;
                {
                    this.touchSlop = ViewConfiguration.get((Context)$receiver.getWebView().getContext()).getScaledTouchSlop();
                }

                public final float getStartX() {
                    return this.startX;
                }

                public final void setStartX(float f) {
                    this.startX = f;
                }

                public final float getStartY() {
                    return this.startY;
                }

                public final void setStartY(float f) {
                    this.startY = f;
                }

                public final boolean isDragging() {
                    return this.isDragging;
                }

                public final void setDragging(boolean bl) {
                    this.isDragging = bl;
                }

                public boolean onTouch(@NotNull View v, @NotNull MotionEvent event) {
                    Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    switch (event.getAction()) {
                        case 0: {
                            this.startX = event.getX();
                            this.startY = event.getY();
                            v.getParent().requestDisallowInterceptTouchEvent(true);
                            this.isDragging = false;
                            break;
                        }
                        case 2: {
                            float deltaX = Math.abs(event.getX() - this.startX);
                            float deltaY = Math.abs(event.getY() - this.startY);
                            if (this.isDragging || !(deltaX > (float)this.touchSlop) && !(deltaY > (float)this.touchSlop)) break;
                            this.isDragging = true;
                            if (deltaX > deltaY * 1.2f) {
                                v.getParent().requestDisallowInterceptTouchEvent(false);
                                break;
                            }
                            v.getParent().requestDisallowInterceptTouchEvent(true);
                            break;
                        }
                        case 1: 
                        case 3: {
                            v.getParent().requestDisallowInterceptTouchEvent(false);
                            this.isDragging = false;
                        }
                    }
                    return false;
                }
            });
        }
        boolean hideNavigationBar = H5BarUtil.INSTANCE.hideNavigationBar(this.getUrl());
        this.hideToolBar(isFieldToolBarHidden || hideNavigationBar);
        WebLogger.INSTANCE.logD(this.getClassTag() + " --> initLayout() --> statusBarHide = " + statusBarHide + " --> isFieldToolBarHidden = " + isFieldToolBarHidden + " -- bottomMargin = " + bottomMargin + " --> hideNavigationBar = " + hideNavigationBar);
        Bundle bundle5 = this.getArguments();
        boolean bl2 = isShowHomeHeader = bundle5 != null ? bundle5.getBoolean("need_header", false) : false;
        if (isShowHomeHeader) {
            int backgroundRes;
            View view;
            View $this$initLayout_u24lambda_u244 = view = this.getBinding().subWebHeaderBg;
            boolean bl3 = false;
            $this$initLayout_u24lambda_u244.getLayoutParams().height = SizeUtils.dp2px((float)80.0f);
            Bundle bundle6 = this.getArguments();
            int n = backgroundRes = bundle6 != null ? bundle6.getInt("header_GB") : 0;
            if (backgroundRes != 0) {
                $this$initLayout_u24lambda_u244.setBackgroundResource(backgroundRes);
            }
            $this$initLayout_u24lambda_u244.setVisibility(0);
        }
    }

    private final void hideToolBar(boolean isHideToolBar) {
        LibWebWebFragmentLayoutBinding libWebWebFragmentLayoutBinding;
        LibWebWebFragmentLayoutBinding $this$hideToolBar_u24lambda_u245 = libWebWebFragmentLayoutBinding = this.getBinding();
        boolean bl = false;
        if (isHideToolBar) {
            this.getBinding().llToolBar.setVisibility(8);
        } else {
            this.getBinding().llToolBar.setVisibility(0);
        }
    }

    private final void initWebView() {
        this.initWebContentMonitor(this.getWebView());
        this.initWebChromeClient(this.getWebView());
        this.initWebViewClient(this.getWebView());
        this.setDownloadListener(this.getWebView());
        this.addJsInterface(this.getMWebView());
        this.addCallback(this.getWebView());
        this.initWebViewFileCacheLoader();
        BridgeWebView bridgeWebView = this.getWebView();
        this.getWebView().addJavascriptInterface(new OkSpinJsBridge(this, bridgeWebView){
            final /* synthetic */ BaseLibWebFragment this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            @JavascriptInterface
            public void close() {
                block0: {
                    super.close();
                    FragmentActivity fragmentActivity = this.this$0.getActivity();
                    if (fragmentActivity == null) break block0;
                    fragmentActivity.finish();
                }
            }
        }, "MbOkSpinJsBridge");
        this.getWebView().loadUrl(this.getUrl());
    }

    private final void initWebOptions(BridgeWebView webView) {
        block0: {
            BridgeWebView bridgeWebView;
            BridgeWebView bridgeWebView2 = webView;
            if (bridgeWebView2 == null) break block0;
            BridgeWebView $this$initWebOptions_u24lambda_u246 = bridgeWebView = bridgeWebView2;
            boolean bl = false;
            $this$initWebOptions_u24lambda_u246.setGson(GsonUtils.getGson());
            $this$initWebOptions_u24lambda_u246.setLayerType(2, null);
            $this$initWebOptions_u24lambda_u246.setOverScrollMode(2);
        }
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private final void initSettings(BridgeWebView webView) {
        block0: {
            BridgeWebView bridgeWebView;
            BridgeWebView bridgeWebView2 = webView;
            if (bridgeWebView2 == null || (bridgeWebView2 = bridgeWebView2.getSettings()) == null) break block0;
            BridgeWebView $this$initSettings_u24lambda_u247 = bridgeWebView = bridgeWebView2;
            boolean bl = false;
            $this$initSettings_u24lambda_u247.setJavaScriptEnabled(true);
            $this$initSettings_u24lambda_u247.setSupportZoom(true);
            $this$initSettings_u24lambda_u247.setBuiltInZoomControls(false);
            Context context = webView.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"webView.context");
            $this$initSettings_u24lambda_u247.setCacheMode(NetworkUtil.INSTANCE.isNetworkConnected(context) ? -1 : 1);
            $this$initSettings_u24lambda_u247.setMixedContentMode(0);
            $this$initSettings_u24lambda_u247.setTextZoom(100);
            $this$initSettings_u24lambda_u247.setDatabaseEnabled(true);
            $this$initSettings_u24lambda_u247.setLoadsImagesAutomatically(true);
            $this$initSettings_u24lambda_u247.setSupportMultipleWindows(false);
            $this$initSettings_u24lambda_u247.setBlockNetworkImage(false);
            $this$initSettings_u24lambda_u247.setAllowFileAccess(true);
            $this$initSettings_u24lambda_u247.setJavaScriptCanOpenWindowsAutomatically(true);
            $this$initSettings_u24lambda_u247.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.SINGLE_COLUMN);
            $this$initSettings_u24lambda_u247.setLoadWithOverviewMode(false);
            $this$initSettings_u24lambda_u247.setUseWideViewPort(false);
            $this$initSettings_u24lambda_u247.setDomStorageEnabled(true);
            $this$initSettings_u24lambda_u247.setNeedInitialFocus(true);
            $this$initSettings_u24lambda_u247.setDefaultTextEncodingName("utf-8");
            $this$initSettings_u24lambda_u247.setDefaultFontSize(16);
            $this$initSettings_u24lambda_u247.setMinimumFontSize(12);
            $this$initSettings_u24lambda_u247.setGeolocationEnabled(true);
        }
    }

    private final void initWebChromeClient(BridgeWebView webView) {
        BridgeWebView bridgeWebView = webView;
        if (bridgeWebView != null) {
            bridgeWebView.setWebChromeClient(new WebChromeClient(this){
                final /* synthetic */ BaseLibWebFragment this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onProgressChanged(@NotNull WebView view, int newProgress) {
                    Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                    super.onProgressChanged(view, newProgress);
                    this.this$0.onWebChromeClientProgressChanged(view, newProgress);
                }

                public void onReceivedTitle(@NotNull WebView view, @NotNull String title) {
                    Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                    Intrinsics.checkNotNullParameter((Object)title, (String)"title");
                    super.onReceivedTitle(view, title);
                    this.this$0.setStrTitle(title);
                    this.this$0.onWebChromeClientReceivedTitle(view, title);
                }

                public void onShowCustomView(@Nullable View view, @Nullable WebChromeClient.CustomViewCallback callback) {
                    super.onShowCustomView(view, callback);
                    this.this$0.onWebChromeClientShowCustomView(view, callback);
                }

                public void onHideCustomView() {
                    super.onHideCustomView();
                    this.this$0.onWebChromeClientHideCustomView();
                }
            });
        }
    }

    private final void initWebViewClient(BridgeWebView webView) {
        BridgeWebView bridgeWebView = webView;
        if (bridgeWebView != null) {
            bridgeWebView.setWebViewClient(new WebViewClient(this){
                final /* synthetic */ BaseLibWebFragment this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onPageStarted(@NotNull WebView view, @NotNull String url, @Nullable Bitmap favicon) {
                    Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                    Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                    super.onPageStarted(view, url, favicon);
                    this.this$0.onWebViewClientPageStarted(view, url, favicon);
                }

                public void onPageFinished(@NotNull WebView view, @NotNull String url) {
                    Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                    Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                    super.onPageFinished(view, url);
                    this.this$0.onWebViewClientPageFinished(view, url);
                }

                public boolean onRenderProcessGone(@Nullable WebView view, @Nullable RenderProcessGoneDetail detail) {
                    return true;
                }

                public void onReceivedHttpError(@NotNull WebView view, @NotNull WebResourceRequest request, @NotNull WebResourceResponse errorResponse) {
                    Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                    Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                    Intrinsics.checkNotNullParameter((Object)errorResponse, (String)"errorResponse");
                    super.onReceivedHttpError(view, request, errorResponse);
                    this.this$0.onWebViewClientReceivedHttpError(view, request, errorResponse);
                }

                public void onReceivedError(@Nullable WebView view, int errorCode, @Nullable String description, @Nullable String failingUrl) {
                    super.onReceivedError(view, errorCode, description, failingUrl);
                    this.this$0.onWebViewClientReceivedError(view, errorCode, description, failingUrl);
                }

                public void onReceivedError(@NotNull WebView view, @NotNull WebResourceRequest request, @NotNull WebResourceError error) {
                    Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                    Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                    Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                    super.onReceivedError(view, request, error);
                    this.this$0.onWebViewClientReceivedError(view, request, error);
                }

                public boolean shouldOverrideUrlLoading(@NotNull WebView view, @NotNull String url) {
                    Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                    Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                    return ParseDeeplinkManager.INSTANCE.deepLink(url, this.this$0.getContext()) ? true : super.shouldOverrideUrlLoading(view, url);
                }

                public boolean shouldOverrideUrlLoading(@Nullable WebView view, @Nullable WebResourceRequest request) {
                    Object url;
                    Object object = request;
                    if (object == null || (object = object.getUrl()) == null || (object = object.toString()) == null) {
                        object = "";
                    }
                    return ParseDeeplinkManager.INSTANCE.deepLink((String)(url = object), this.this$0.getContext()) ? true : super.shouldOverrideUrlLoading(view, request);
                }

                @Nullable
                public WebResourceResponse shouldInterceptRequest(@Nullable WebView view, @Nullable String url) {
                    WebViewLoaderManager webViewLoaderManager = this.this$0.getMWebViewLoaderManager();
                    if (webViewLoaderManager == null || (webViewLoaderManager = WebViewLoaderManager.interceptRequest$default(webViewLoaderManager, url, null, 2, null)) == null) {
                        webViewLoaderManager = super.shouldInterceptRequest(view, url);
                    }
                    return webViewLoaderManager;
                }

                @Nullable
                public WebResourceResponse shouldInterceptRequest(@NotNull WebView view, @NotNull WebResourceRequest request) {
                    Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                    Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                    WebViewLoaderManager webViewLoaderManager = this.this$0.getMWebViewLoaderManager();
                    if (webViewLoaderManager == null || (webViewLoaderManager = webViewLoaderManager.interceptRequest(request)) == null) {
                        webViewLoaderManager = super.shouldInterceptRequest(view, request);
                    }
                    return webViewLoaderManager;
                }
            });
        }
    }

    private final void setDownloadListener(BridgeWebView webView) {
        block0: {
            BridgeWebView bridgeWebView = webView;
            if (bridgeWebView == null) break block0;
            bridgeWebView.setDownloadListener((arg_0, arg_1, arg_2, arg_3, arg_4) -> BaseLibWebFragment.setDownloadListener$lambda$8(this, arg_0, arg_1, arg_2, arg_3, arg_4));
        }
    }

    private final void addCallback(BridgeWebView webView) {
        this.requireActivity().getOnBackPressedDispatcher().addCallback((LifecycleOwner)this, new OnBackPressedCallback(webView, this){
            final /* synthetic */ BridgeWebView $webView;
            final /* synthetic */ BaseLibWebFragment this$0;
            {
                this.$webView = $webView;
                this.this$0 = $receiver;
                super(true);
            }

            public void handleOnBackPressed() {
                BridgeWebView bridgeWebView = this.$webView;
                boolean bl = bridgeWebView != null ? bridgeWebView.canGoBack() : false;
                if (bl) {
                    this.this$0.getMWebView().goBack();
                } else {
                    this.this$0.requireActivity().finish();
                }
            }
        });
    }

    private final void initWebViewFileCacheLoader() {
        block0: {
            Context context = this.getContext();
            if (context == null) break block0;
            Context it = context;
            boolean bl = false;
            this.mWebViewLoaderManager = new WebViewLoaderManager(it, CollectionsKt.listOf((Object)new WebViewFileCacheLoader(it, this.getUrl())));
        }
    }

    public abstract void addJsInterface(@NotNull BridgeWebView var1);

    public void addDownloadWithDialogForWeb(@NotNull FragmentActivity requireActivity, @NotNull String tag, @Nullable String url, @Nullable String title, long contentLength, @NotNull String originalUrl) {
        Intrinsics.checkNotNullParameter((Object)requireActivity, (String)"requireActivity");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)originalUrl, (String)"originalUrl");
    }

    @NotNull
    public String getUrl() {
        Bundle bundle = this.getArguments();
        String string = bundle != null ? bundle.getString("url") : null;
        if (string == null) {
            string = "";
        }
        return string;
    }

    public final long getFirstLoadStartTime() {
        return this.firstLoadStartTime;
    }

    public final void setFirstLoadStartTime(long l) {
        this.firstLoadStartTime = l;
    }

    public void onWebViewClientPageStarted(@NotNull WebView view, @NotNull String url, @Nullable Bitmap favicon) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        WebLogger.INSTANCE.logD("onWebViewClientPageStarted " + url);
        this.currentState = LoadStatus.LOADING;
        this.firstLoadStartTime = System.currentTimeMillis();
        this.injectPerformanceScript(view);
    }

    public void onWebViewClientPageFinished(@NotNull WebView view, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        WebLogger.INSTANCE.logD("onWebViewClientPageFinished " + url);
        if (this.currentState == LoadStatus.LOADING) {
            this.checkFirstLoadStatus(url);
        }
    }

    public void onWebViewClientReceivedHttpError(@NotNull WebView view, @NotNull WebResourceRequest request, @NotNull WebResourceResponse errorResponse) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)errorResponse, (String)"errorResponse");
        if (this.currentState == LoadStatus.LOADING && request.isForMainFrame()) {
            int statusCode = errorResponse.getStatusCode();
            String reasonPhrase = errorResponse.getReasonPhrase();
            this.handleFirstLoadFailure(reasonPhrase, statusCode);
        }
    }

    public void onWebViewClientReceivedError(@Nullable WebView view, int request, @Nullable String error, @Nullable String failingUrl) {
        if (this.currentState == LoadStatus.LOADING) {
            this.handleFirstLoadFailure("WebResourceError: " + error, -1);
        }
    }

    public void onWebViewClientReceivedError(@Nullable WebView view, @NotNull WebResourceRequest request, @NotNull WebResourceError error) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        if (this.currentState == LoadStatus.LOADING && Build.VERSION.SDK_INT >= 23) {
            this.handleFirstLoadFailure(((Object)error.getDescription()).toString(), error.getErrorCode());
        }
    }

    public void onWebChromeClientReceivedTitle(@NotNull WebView view, @NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        this.getBinding().tvTitle.setText((CharSequence)title);
    }

    public void onWebChromeClientProgressChanged(@NotNull WebView view, int newProgress) {
        int n;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        ProgressBar progressBar = this.getBinding().progressBar;
        if (newProgress == 100) {
            n = 8;
        } else {
            this.getBinding().progressBar.setProgress(newProgress);
            n = 0;
        }
        progressBar.setVisibility(n);
    }

    /*
     * WARNING - void declaration
     */
    public void onWebChromeClientShowCustomView(@Nullable View view, @Nullable WebChromeClient.CustomViewCallback callback) {
        void $this$onWebChromeClientShowCustomView_u24lambda_u2410;
        if (this.webCustomView != null) {
            WebChromeClient.CustomViewCallback customViewCallback = callback;
            if (customViewCallback != null) {
                customViewCallback.onCustomViewHidden();
            }
            return;
        }
        FragmentActivity activity = this.getActivity();
        if (activity == null || activity.isDestroyed() || activity.isFinishing()) {
            return;
        }
        this.webCustomView = view;
        this.originalSystemUiVisibility = activity.getWindow().getDecorView().getSystemUiVisibility();
        this.originalOrientation = activity.getRequestedOrientation();
        this.customViewCallback = callback;
        View view2 = activity.getWindow().getDecorView();
        FrameLayout decor = view2 instanceof FrameLayout ? (FrameLayout)view2 : null;
        View view3 = view2 = new FrameLayout((Context)activity);
        BaseLibWebFragment baseLibWebFragment = this;
        boolean bl = false;
        $this$onWebChromeClientShowCustomView_u24lambda_u2410.setBackgroundColor(-16777216);
        $this$onWebChromeClientShowCustomView_u24lambda_u2410.addView(this.webCustomView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        baseLibWebFragment.fullscreenContainer = view2;
        FrameLayout frameLayout = decor;
        if (frameLayout != null) {
            frameLayout.addView((View)this.fullscreenContainer, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        }
        ImmersionBar.with((Activity)((Activity)activity)).hideBar(BarHide.FLAG_HIDE_BAR).init();
        activity.setRequestedOrientation(6);
    }

    public void onWebChromeClientHideCustomView() {
        FragmentActivity activity = this.getActivity();
        if (activity == null || activity.isDestroyed() || activity.isFinishing()) {
            return;
        }
        View view = activity.getWindow().getDecorView();
        Intrinsics.checkNotNull((Object)view, (String)"null cannot be cast to non-null type android.widget.FrameLayout");
        FrameLayout decor = (FrameLayout)view;
        decor.removeView((View)this.fullscreenContainer);
        this.fullscreenContainer = null;
        this.webCustomView = null;
        ImmersionBar.with((Activity)((Activity)activity)).hideBar(BarHide.FLAG_SHOW_BAR).init();
        activity.setRequestedOrientation(this.originalOrientation);
        WebChromeClient.CustomViewCallback customViewCallback = this.customViewCallback;
        Intrinsics.checkNotNull((Object)customViewCallback);
        customViewCallback.onCustomViewHidden();
        this.customViewCallback = null;
    }

    private final boolean loadUrlOnly() {
        Bundle bundle = this.getArguments();
        return bundle != null ? bundle.getBoolean("load_url_only", false) : false;
    }

    @SuppressLint(value={"JavascriptInterface"})
    private final void initWebContentMonitor(BridgeWebView webView) {
        block0: {
            BridgeWebView bridgeWebView = webView;
            if (bridgeWebView == null) break block0;
            bridgeWebView.addJavascriptInterface(new LoadTimeInterface(), "AndroidInterface");
        }
    }

    private final void checkFirstLoadStatus(String string) {
        this.currentState = LoadStatus.SUCCESS;
        long loadTime = System.currentTimeMillis() - this.firstLoadStartTime;
        this.trackEvent(string, loadTime);
    }

    private final void handleFirstLoadFailure(String errorMsg, int errorCode) {
        this.currentState = LoadStatus.FAILED;
        this.trackError(this.getUrl(), errorCode, errorMsg);
    }

    @NotNull
    public final LoadInfoStats getLoadInfoStats() {
        return this.loadInfoStats;
    }

    public void trackEvent(@Nullable String url, long loadTime) {
        WebLogger.INSTANCE.logW("trackEvent --> loadTime = " + loadTime + " --> url = " + url);
        this.loadInfoStats.setLoad_time(loadTime);
        if (this.currentState == LoadStatus.SUCCESS) {
            this.loadInfoStats.setLoadSuccess(true);
        }
    }

    public void trackError(@Nullable String url, int errorCode, @Nullable String errorMsg) {
        WebLogger.INSTANCE.logW("trackError --> errorCode = " + errorCode + " --> url = " + url + " --> errorMsg = " + errorMsg);
        this.loadInfoStats.setError_code(errorCode);
        this.loadInfoStats.setError_msg(errorMsg);
    }

    private final void injectPerformanceScript(WebView view1) {
        block0: {
            String script = "\n              (function() {\n                window.addEventListener('load',\n                function() {\n                    try {\n                        const intervalId = setInterval(function() {\n                            var timing = window.performance.timing;\n                            if (timing.loadEventEnd <= 0) {\n                                console.log(timing.loadEventEnd);\n                                return;\n                            }\n            \n                            var stats = {\n                                // \u57fa\u672c\u52a0\u8f7d\u65f6\u95f4\n                                dnsLookup: timing.domainLookupEnd - timing.domainLookupStart,\n                                tcpConnect: timing.connectEnd - timing.connectStart,\n                                requestTime: timing.responseStart - timing.requestStart,\n                                responseTime: timing.responseEnd - timing.responseStart,\n            \n                                // DOM\u76f8\u5173\u65f6\u95f4\n                                domLoading: timing.domLoading - timing.navigationStart,\n                                domInteractive: timing.domInteractive - timing.navigationStart,\n                                domComplete: timing.domComplete - timing.navigationStart,\n            \n                                // \u6574\u4f53\u52a0\u8f7d\u65f6\u95f4\n                                loadEventTime: timing.loadEventEnd - timing.loadEventStart,\n                                totalLoadTime: timing.loadEventEnd - timing.navigationStart,\n            \n                                // \u52a0\u8f7d\u72b6\u6001\n                                readyState: document.readyState,\n                                success: document.readyState === 'complete'\n                            };\n                            clearInterval(intervalId)\n                            console.log(timing.loadEventEnd)\n                            console.warn(JSON.stringify(stats))\n                            // \u5982\u679c\u6709Android\u63a5\u53e3\u53ef\u7528\uff0c\u5219\u901a\u8fc7\u63a5\u53e3\u62a5\u544a\n                            if (window.AndroidInterface) {\n                                window.AndroidInterface.reportLoadStats(JSON.stringify(stats));\n                            } else {\n                                console.warn(window.AndroidInterface);\n                                console.warn(stats);\n                            }\n            \n                        },\n                        1000);\n                    } catch(e) {\n                        if (window.AndroidInterface) {\n                            window.AndroidInterface.reportLoadError(e.message);\n                        } else {\n                            console.error('Error collecting load stats:', e);\n                        }\n                    }\n                })\n            \n            })()\n            ";
            WebView webView = view1;
            if (webView == null) break block0;
            webView.evaluateJavascript(script, null);
        }
    }

    public void onConnected() {
        OnNetworkStatusChangedListener.DefaultImpls.onConnected((OnNetworkStatusChangedListener)this);
    }

    private static final void initListener$lambda$0(BaseLibWebFragment this$0, View it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            FragmentActivity fragmentActivity = this$0.getActivity();
            if (fragmentActivity == null || (fragmentActivity = fragmentActivity.getOnBackPressedDispatcher()) == null) break block0;
            fragmentActivity.onBackPressed();
        }
    }

    private static final void initListener$lambda$1(BaseLibWebFragment this$0, View it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            FragmentActivity fragmentActivity = this$0.getActivity();
            if (fragmentActivity == null) break block0;
            fragmentActivity.finish();
        }
    }

    private static final void initListener$lambda$2(BaseLibWebFragment this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.loadInfoStats.setReload(true);
        this$0.getWebView().reload();
    }

    private static final void setDownloadListener$lambda$8(BaseLibWebFragment this$0, String url, String userAgent, String contentDisposition, String mimetype, long contentLength) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (this$0.loadUrlOnly()) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"url");
        if (StringsKt.endsWith$default((String)url, (String)".apk", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)url, (String)".APK", (boolean)false, (int)2, null) || TextUtils.equals((CharSequence)mimetype, (CharSequence)"application/vnd.android.package-archive")) {
            WebLogger.INSTANCE.logW("\u62e6\u622aAPK\u4e0b\u8f7d --> mimetype = " + mimetype + " --> url = " + url + " --> contentLength = " + contentLength + " --> contentDisposition = " + contentDisposition + " --> userAgent = " + userAgent);
            return;
        }
        FragmentActivity fragmentActivity = this$0.requireActivity();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentActivity, (String)"requireActivity()");
        String string = this$0.strTitle;
        String string2 = this$0.getUrl();
        if (string2 == null) {
            string2 = "";
        }
        this$0.addDownloadWithDialogForWeb(fragmentActivity, "web_load", url, string, contentLength, string2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006H\u0007\u00a8\u0006\t"}, d2={"Lcom/transsion/lib_web/BaseLibWebFragment$LoadTimeInterface;", "", "(Lcom/transsion/lib_web/BaseLibWebFragment;)V", "reportLoadError", "", "errorMsg", "", "reportLoadStats", "json", "lib_web_release"})
    public final class LoadTimeInterface {
        @JavascriptInterface
        public final void reportLoadError(@NotNull String errorMsg) {
            Intrinsics.checkNotNullParameter((Object)errorMsg, (String)"errorMsg");
            WebLogger.INSTANCE.logD("reportLoadError: " + errorMsg);
            DomPerformance domPerformance = new DomPerformance();
            domPerformance.setErrorMsg(errorMsg);
            BaseLibWebFragment.this.getLoadInfoStats().setDom_performance(domPerformance);
        }

        @JavascriptInterface
        public final void reportLoadStats(@NotNull String json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            WebLogger.INSTANCE.logD("reportLoadStats: " + json);
            try {
                DomPerformance domPerformance = new DomPerformance();
                JSONObject jsonObject = new JSONObject(json);
                domPerformance.setDnsLookup(jsonObject.optLong("dnsLookup"));
                domPerformance.setTcpConnect(jsonObject.optLong("tcpConnect"));
                domPerformance.setRequestTime(jsonObject.optLong("requestTime"));
                domPerformance.setResponseTime(jsonObject.optLong("responseTime"));
                domPerformance.setDomLoading(jsonObject.optLong("domLoading"));
                domPerformance.setDomInteractive(jsonObject.optLong("domInteractive"));
                domPerformance.setDomComplete(jsonObject.optLong("domComplete"));
                domPerformance.setLoadEventTime(jsonObject.optLong("loadEventTime"));
                domPerformance.setTotalLoadTime(jsonObject.optLong("totalLoadTime"));
                domPerformance.setReadyState(jsonObject.optString("readyState"));
                domPerformance.setSuccess(jsonObject.optBoolean("success"));
                BaseLibWebFragment.this.getLoadInfoStats().setDom_performance(domPerformance);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

