/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.lib_web.cache;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.annotation.MainThread;
import com.blankj.utilcode.util.Utils;
import com.github.lzyzsd.jsbridge.BridgeWebView;
import com.transsion.lib_web.cache.TWebViewProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0006J\u001a\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0007J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0004J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0004H\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/transsion/lib_web/cache/TWebViewCacheManager;", "", "()V", "mCurrentH5Url", "", "mCurrentWebView", "Lcom/github/lzyzsd/jsbridge/BridgeWebView;", "destroy", "", "webView", "getWebView", "url", "context", "Landroid/content/Context;", "isCacheUrl", "", "preload", "lib_web_release"})
public final class TWebViewCacheManager {
    @NotNull
    public static final TWebViewCacheManager INSTANCE = new TWebViewCacheManager();
    @Nullable
    private static String mCurrentH5Url = "";
    @Nullable
    private static BridgeWebView mCurrentWebView;

    private TWebViewCacheManager() {
    }

    @MainThread
    public final void preload(@NotNull String url) {
        block2: {
            BridgeWebView bridgeWebView;
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            if (TextUtils.equals((CharSequence)url, (CharSequence)mCurrentH5Url)) {
                TWebViewProvider.INSTANCE.logCache("preload() --> \u6b63\u5728\u7f13\u5b58\u7684\u5730\u5740\uff0c\u65e0\u9700\u91cd\u590d\u521b\u5efa --> url = " + url);
                return;
            }
            mCurrentH5Url = url;
            if (mCurrentWebView == null) {
                Context context = Utils.getApp().getApplicationContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getApp().applicationContext");
                mCurrentWebView = TWebViewProvider.INSTANCE.getWebView(context);
                TWebViewProvider.INSTANCE.logCache("preloadInternal() --> \u4e0d\u5b58\u5728\u521b\u5efa\u65b0\u7684\u5bf9\u8c61");
            }
            BridgeWebView bridgeWebView2 = mCurrentWebView;
            if (bridgeWebView2 == null) break block2;
            BridgeWebView $this$preload_u24lambda_u240 = bridgeWebView = bridgeWebView2;
            boolean bl = false;
            $this$preload_u24lambda_u240.setTag(-1001, String.valueOf(System.currentTimeMillis()));
            $this$preload_u24lambda_u240.stopLoading();
            $this$preload_u24lambda_u240.clearHistory();
            $this$preload_u24lambda_u240.clearCache(true);
            $this$preload_u24lambda_u240.loadUrl("about:blank");
            $this$preload_u24lambda_u240.loadUrl(url);
            TWebViewProvider.INSTANCE.logCache("preloadInternal() --> \u521b\u5efa\u65b0\u5bf9\u8c61\u52a0\u5165\u7f13\u5b58\u6c60 --> \u9884\u52a0\u8f7d\u57cb\u70b9 --> url = " + url);
            TWebViewProvider.INSTANCE.report(url, "preload");
            $this$preload_u24lambda_u240.setTag(-1001, true);
        }
    }

    @MainThread
    @NotNull
    public final BridgeWebView getWebView(@NotNull String url, @Nullable Context context) {
        BridgeWebView bridgeWebView;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (this.isCacheUrl(url)) {
            BridgeWebView valueWeb = mCurrentWebView;
            mCurrentWebView = null;
            mCurrentH5Url = null;
            TWebViewProvider.INSTANCE.logCache("get() --> \u7f13\u5b58\u547d\u4e2d\uff0c\u76f4\u63a5\u590d\u7528 --> url = " + url);
            bridgeWebView = valueWeb;
            if (bridgeWebView == null) {
                Context context2 = Utils.getApp().getApplicationContext();
                Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getApp().applicationContext");
                bridgeWebView = TWebViewProvider.INSTANCE.getWebView(context2);
            }
        } else {
            TWebViewProvider.INSTANCE.logCache("get() --> \u6ca1\u6709\u7f13\u5b58\uff0c\u76f4\u63a5\u521b\u5efa\u4e00\u4e2a\u65b0\u7684 --> url = " + url);
            Context context3 = context;
            if (context3 == null) {
                context3 = Utils.getApp().getApplicationContext();
            }
            Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"context ?: Utils.getApp().applicationContext");
            bridgeWebView = TWebViewProvider.INSTANCE.getWebView(context3);
        }
        return bridgeWebView;
    }

    public final boolean isCacheUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return TextUtils.equals((CharSequence)url, (CharSequence)mCurrentH5Url);
    }

    public final void destroy(@Nullable BridgeWebView webView) {
        block1: {
            BridgeWebView bridgeWebView = webView;
            if (bridgeWebView == null) break block1;
            BridgeWebView it = bridgeWebView;
            boolean bl = false;
            ViewParent viewParent = it.getParent();
            ViewGroup viewGroup = viewParent instanceof ViewGroup ? (ViewGroup)viewParent : null;
            if (viewGroup != null) {
                viewGroup.removeView((View)it);
            }
            it.stopLoading();
            it.clearHistory();
            it.clearCache(true);
            it.loadUrl("about:blank");
            it.destroy();
        }
    }
}

