/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.lib_web.zip;

import android.content.Context;
import com.blankj.utilcode.util.EncryptUtils;
import com.transsion.lib_web.zip.db.WebViewCacheConfigData;
import com.transsion.lib_web.zip.loader.WebViewCacheTask;
import com.transsion.lib_web.zip.loader.WebViewFileCacheLoaderKt;
import com.transsion.lib_web.zip.utils.FileUtils;
import java.io.File;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\bJ\u0018\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\bJ\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0010"}, d2={"Lcom/transsion/lib_web/zip/WebViewCacheDownloader;", "", "()V", "checkDownloadZip", "", "context", "Landroid/content/Context;", "dbItem", "Lcom/transsion/lib_web/zip/db/WebViewCacheConfigData;", "(Landroid/content/Context;Lcom/transsion/lib_web/zip/db/WebViewCacheConfigData;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "clearCacheFile", "cacheConfigData", "getLocalFile", "Ljava/io/File;", "configData", "getWebViewCacheFile", "lib_web_release"})
public final class WebViewCacheDownloader {
    @NotNull
    public static final WebViewCacheDownloader INSTANCE = new WebViewCacheDownloader();

    private WebViewCacheDownloader() {
    }

    @NotNull
    public final File getWebViewCacheFile(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new File(context.getCacheDir(), "webViewCache");
    }

    @Nullable
    public final Object checkDownloadZip(@NotNull Context context, @NotNull WebViewCacheConfigData dbItem, @NotNull Continuation<? super Unit> $completion) {
        if (((CharSequence)dbItem.getZipUrl()).length() == 0) {
            return Unit.INSTANCE;
        }
        Object object = new WebViewCacheTask(context, dbItem).start($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final File getLocalFile(@NotNull Context context, @NotNull WebViewCacheConfigData configData) {
        String baseUrl;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configData, (String)"configData");
        String string = baseUrl = WebViewFileCacheLoaderKt.getBaseUrl(configData.getHtmlUrl());
        boolean bl = string != null ? ((CharSequence)string).length() == 0 : false;
        if (bl) {
            return null;
        }
        return new File(this.getWebViewCacheFile(context), EncryptUtils.encryptMD5ToString((String)baseUrl) + "_" + configData.getZipMd5());
    }

    public final void clearCacheFile(@NotNull Context context, @NotNull WebViewCacheConfigData cacheConfigData) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cacheConfigData, (String)"cacheConfigData");
        try {
            File localFile;
            boolean bl = false;
            File file = localFile = INSTANCE.getLocalFile(context, cacheConfigData);
            boolean bl2 = file != null ? file.exists() : false;
            if (bl2) {
                FileUtils.Companion.deleteFile(localFile);
            }
            Object object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }
}

